/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.AckSessionReplica;
import com.oracle.bricks.j2ee.LiveSession;
import com.oracle.bricks.j2ee.SessionEventListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.util.Promise;

public class AckLiveSession
extends LiveSession {
    protected AckObject m_ackObject;
    private static final Logger m_logger = ClusteringTraceLogger.getHttpTraceLogger(AckLiveSession.class);

    protected AckLiveSession(AckSessionReplica replica, long timeout) {
        super(replica);
        this.m_ackObject = new AckObject(timeout);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckLiveSession with AckSessionReplica");
        }
    }

    public AckLiveSession(Serializable id, SessionEventListener listener, int addr, long creationTime, long timeout) {
        super(id, listener, addr, creationTime);
        this.m_ackObject = new AckObject(timeout);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckLiveSession with args");
        }
    }

    protected final void send(Replica.Message message) throws InterruptedException {
        AckSessionReplica.ApplyDeltaWithAck msg = (AckSessionReplica.ApplyDeltaWithAck)message;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "AckLiveSession::send:: sending msg: " + msg);
        }
        Promise promise = new Promise();
        Integer currentAckSeqNo = new Integer(msg.getAckSeqNo());
        this.m_ackObject.put(currentAckSeqNo, promise);
        super.send(message);
        Address sender = (Address)promise.getResult(this.m_ackObject.getTimeout());
        if (sender == null) {
            this.m_ackObject.remove(currentAckSeqNo);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "AckLiveSession::no promise response within timout: " + this.m_ackObject.getTimeout() + " for ackSeqNo: " + currentAckSeqNo);
            }
        } else if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "AckLiveSession::received promise response from sender: " + sender);
        }
    }

    protected Replica.Message createApplyDeltaMessage(Serializable[] thePuts, Serializable[] theRemoves) {
        return new AckSessionReplica.ApplyDeltaWithAck(this.getId(), this.getLastAccessed(), this.getUser(), thePuts.length == 0 ? null : thePuts, theRemoves.length == 0 ? null : theRemoves, this.m_ackObject.getNextAckSeqNo(), this.getOwner());
    }

    protected void acknowledgeUpdate(int ackSeqNo, Address sender) {
        Promise promise = this.m_ackObject.remove(new Integer(ackSeqNo));
        if (promise != null) {
            promise.setResult((Object)sender);
        }
    }

    protected void remove() throws InterruptedException {
        super.remove();
        this.m_ackObject.clearOutstandingAckMap();
    }

    protected Replica getReplica(Address address) throws Exception {
        return new AckSessionReplica(this, (HashMap)this.map.clone(), this.adapter.getMarshaller());
    }

    protected long getAcknowledgementTimeout() {
        return this.m_ackObject.getTimeout();
    }

    public static class AckObject {
        protected final Map m_promisedAcks = new ConcurrentHashMap();
        protected int m_ackNo = 0;
        protected long m_timeout = 0L;

        public AckObject() {
        }

        public AckObject(long timeout) {
            this.m_timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Integer ackSeqNo, Promise promise) {
            Map map = this.m_promisedAcks;
            synchronized (map) {
                this.m_promisedAcks.put(ackSeqNo, promise);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Promise remove(Integer ackSeqNo) {
            Map map = this.m_promisedAcks;
            synchronized (map) {
                return (Promise)this.m_promisedAcks.remove(ackSeqNo);
            }
        }

        public long getTimeout() {
            return this.m_timeout;
        }

        public void setTimeout(long timeout) {
            this.m_timeout = timeout;
        }

        int getNextAckSeqNo() {
            return this.m_ackNo++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearOutstandingAckMap() {
            Map map = this.m_promisedAcks;
            synchronized (map) {
                Set keys = this.m_promisedAcks.keySet();
                Iterator itr = keys.iterator();
                while (itr.hasNext()) {
                    Integer key = (Integer)itr.next();
                    Promise promise = this.remove(key);
                    if (promise == null) continue;
                    promise.setResult(null);
                }
            }
        }
    }
}

