/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.EJBLiveSession;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;

public class EJBSessionReplica
extends Replica {
    protected long lastAccessed;
    protected long creationTime;
    protected int lifetime;
    protected String user;
    protected byte[] sfsbBytes;
    protected String location;
    protected long sfsbChecksum;
    protected long sfsbId;
    protected HashMap contextPropertyDeltas;
    protected static Logger m_logger = ClusteringTraceLogger.getEJBTraceLogger(EJBSessionReplica.class);

    public EJBSessionReplica() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating replica no args");
        }
    }

    protected EJBSessionReplica(EJBLiveSession session) throws Exception {
        super(session);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating replica with args");
        }
        this.lastAccessed = session.getLastAccessed();
        this.creationTime = session.getCreationTime();
        this.lifetime = session.getMaxInactiveTime();
        this.user = session.getUser();
        this.location = session.getLocation();
        this.sfsbId = session.getSFSBId();
        this.sfsbChecksum = session.getChecksum();
        this.sfsbBytes = session.getBytes();
    }

    public synchronized long getLastAccessed() {
        return this.lastAccessed;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    protected LocalObject reify(ObjectMarshaller marshaller) {
        ClusteringMessages.fineEjbSessionFailover(this.getId());
        return new EJBLiveSession(this);
    }

    public boolean shouldReap(long currentTime) {
        return this.getLastAccessed() + (long)this.lifetime < currentTime;
    }

    protected synchronized void updateLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public void reap() {
    }

    protected void applyBroadcast(BroadcastState state) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "applying state" + state);
        }
        this.location = state.location;
        this.lastAccessed = state.lastAccessed;
        this.creationTime = state.creationTime;
        this.lifetime = state.lifetime;
        this.sfsbChecksum = state.checksum;
        this.sfsbId = state.id;
        this.user = state.user;
        this.sfsbBytes = state.sfsbBytes;
        ClusteringMessages.finestEjbSessionUpdatedWithId(this.sfsbId);
    }

    protected void applyDelta(ApplyDelta applyDelta) {
        if (this.contextPropertyDeltas == null) {
            this.contextPropertyDeltas = new HashMap(5);
        }
        this.contextPropertyDeltas.put(applyDelta.name, applyDelta.broadcastValue);
    }

    public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
        super.readExternal(in, marshaller);
        this.location = in.readUTF();
        this.lastAccessed = in.readLong();
        this.creationTime = in.readLong();
        this.lifetime = in.readInt();
        this.sfsbChecksum = in.readLong();
        this.sfsbId = in.readLong();
        this.user = (String)in.readObject();
        int length = in.readInt();
        if (length != 0) {
            this.sfsbBytes = new byte[length];
            in.read(this.sfsbBytes, 0, length);
        } else {
            this.sfsbBytes = new byte[0];
        }
        if (in.readBoolean()) {
            this.contextPropertyDeltas = (HashMap)in.readObject();
        }
    }

    public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
        super.writeExternal(out, marshaller);
        out.writeUTF(this.location == null ? "" : this.location);
        out.writeLong(this.lastAccessed);
        out.writeLong(this.creationTime);
        out.writeInt(this.lifetime);
        out.writeLong(this.sfsbChecksum);
        out.writeLong(this.sfsbId);
        out.writeObject(this.user);
        if (this.sfsbBytes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.sfsbBytes.length);
            out.write(this.sfsbBytes);
        }
        if (this.contextPropertyDeltas == null || this.contextPropertyDeltas.size() > 0) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.contextPropertyDeltas);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public static class ApplyDelta
    extends Replica.Message {
        String name;
        Serializable value;
        byte[] broadcastValue;

        public ApplyDelta() {
        }

        public ApplyDelta(Serializable id, String name, Serializable value) {
            super(id);
            this.name = name;
            this.value = value;
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeObject(this.name);
            try {
                out.writeObject(marshaller.serializableToBytes(this.value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            super.readExternal(in, marshaller);
            this.name = (String)in.readObject();
            this.broadcastValue = (byte[])in.readObject();
        }

        protected void applyTo(Replica replicated, AbstractGroup manager, Serializable id) {
            ((EJBSessionReplica)replicated).applyDelta(this);
        }
    }

    public static class BroadcastState
    extends Replica.Message {
        protected EJBLiveSession liveSession;
        protected String location;
        protected long checksum;
        protected long lastAccessed;
        protected long creationTime;
        protected long id;
        protected int lifetime;
        protected String user;
        protected byte[] sfsbBytes;

        public BroadcastState() {
        }

        public BroadcastState(EJBLiveSession liveSession) {
            super(new Long(liveSession.getSFSBId()));
            this.liveSession = liveSession;
        }

        public String toString() {
            if (this.liveSession == null) {
                return "MigrateState session";
            }
            return "MigrateState session: " + this.liveSession.getId();
        }

        public void applyTo(Replica replicated, AbstractGroup manager, Serializable id) {
            ((EJBSessionReplica)replicated).applyBroadcast(this);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeUTF(this.liveSession.getLocation() == null ? "" : this.liveSession.getLocation());
            out.writeLong(this.liveSession.getChecksum());
            out.writeLong(this.liveSession.getLastAccessed());
            out.writeLong(this.liveSession.getCreationTime());
            out.writeLong(this.liveSession.getSFSBId());
            out.writeInt(this.liveSession.getMaxInactiveTime());
            out.writeObject(this.liveSession.getUser());
            byte[] ejbBytes = this.liveSession.getBytes();
            out.writeInt(ejbBytes.length);
            out.write(ejbBytes);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            super.readExternal(in, marshaller);
            this.location = in.readUTF();
            this.checksum = in.readLong();
            this.lastAccessed = in.readLong();
            this.creationTime = in.readLong();
            this.id = in.readLong();
            this.lifetime = in.readInt();
            this.user = (String)in.readObject();
            int length = in.readInt();
            this.sfsbBytes = new byte[length];
            in.read(this.sfsbBytes);
        }
    }
}

