/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.LiveSession;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;

public class SessionReplica
extends Replica {
    private long lastAccessed;
    private long creationTime;
    private int lifetime;
    private HashMap map;
    private String user;
    private int ip;
    private static Logger m_logger = ClusteringTraceLogger.getHttpTraceLogger(SessionReplica.class);

    public SessionReplica() {
    }

    protected SessionReplica(LiveSession session, HashMap clonedAttributes, ObjectMarshaller marshaller) throws Exception {
        super(session);
        this.lastAccessed = session.getLastAccessed();
        this.creationTime = session.getCreationTime();
        this.lifetime = session.getMaxInactiveTime();
        this.user = session.getUser();
        this.ip = session.getIp();
        this.map = clonedAttributes;
        Iterator i = clonedAttributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            try {
                this.map.put(entry.getKey(), marshaller.serializableToBytes((Serializable)entry.getValue()));
            }
            catch (Throwable t) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.log(Level.FINEST, "error serializing", t);
            }
        }
    }

    protected HashMap getMap() {
        return this.map;
    }

    public synchronized long getLastAccessed() {
        return this.lastAccessed;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    protected LocalObject reify(ObjectMarshaller marshaller) {
        ClusteringMessages.fineHttpSessionFailover(this.getId());
        return new LiveSession(this);
    }

    public boolean shouldReap(long currentTime) {
        return this.getLastAccessed() + (long)(this.lifetime * 1000) < currentTime;
    }

    protected void applyDelta(long lastAccessed, String user, Serializable[] puts, Serializable[] removes) {
        int i;
        this.updateLastAccessed(lastAccessed);
        this.setUser(user);
        if (puts != null) {
            i = 0;
            while (i < puts.length) {
                Serializable key = puts[i++];
                Serializable value = puts[i++];
                this.map.put(key, value);
                if (!this.isDebugEnabled()) continue;
                m_logger.log(Level.FINEST, " Applying put: {0} value: {1}", new Object[]{key, value});
            }
        }
        if (removes != null) {
            for (i = 0; i < removes.length; ++i) {
                this.map.remove(removes[i]);
            }
        }
        if (this.isDebugEnabled()) {
            m_logger.log(Level.FINEST, "Applied " + (puts == null ? 0 : puts.length / 2) + " puts and " + (removes == null ? 0 : removes.length) + " removes ");
        }
        ClusteringMessages.finestHttpSessionUpdatedWithId(this.getId().toString());
    }

    private boolean isDebugEnabled() {
        return m_logger.isLoggable(Level.FINEST);
    }

    protected synchronized void updateLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public void reap() {
        this.map.clear();
    }

    public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
        super.readExternal(in, marshaller);
        this.lastAccessed = in.readLong();
        this.creationTime = in.readLong();
        this.lifetime = in.readInt();
        this.ip = in.readInt();
        this.user = (String)in.readObject();
        int size = in.readInt();
        this.map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            try {
                this.map.put(in.readObject(), (byte[])in.readObject());
                continue;
            }
            catch (Throwable t) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.log(Level.FINEST, "error serializing", t);
            }
        }
    }

    public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
        super.writeExternal(out, marshaller);
        out.writeLong(this.lastAccessed);
        out.writeLong(this.creationTime);
        out.writeInt(this.lifetime);
        out.writeInt(this.ip);
        out.writeObject(this.user);
        out.writeInt(this.map.size());
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            out.writeObject(entry.getKey());
            try {
                out.writeObject(marshaller.serializableToBytes((Serializable)entry.getValue()));
            }
            catch (Throwable t) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.log(Level.FINEST, "error serializing", t);
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getIp() {
        return this.ip;
    }

    public void setIp(int ip) {
        this.ip = ip;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public static class ApplyDelta
    extends Replica.Message {
        protected long lastAccessed;
        protected String user;
        protected Serializable[] puts;
        protected Serializable[] removes;

        public ApplyDelta() {
        }

        protected ApplyDelta(Serializable id, long lastAccessed, String user, Serializable[] puts, Serializable[] removes) {
            super(id);
            this.lastAccessed = lastAccessed;
            this.puts = puts;
            this.removes = removes;
            this.user = user;
        }

        public String toString() {
            return "ApplyDelta- - " + this.id;
        }

        protected void applyTo(Replica replicated, AbstractGroup manager, Serializable id) {
            if (replicated == null) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Replicated object no longer exists");
                }
                return;
            }
            ((SessionReplica)replicated).applyDelta(this.lastAccessed, this.user, this.puts, this.removes);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            int i;
            block6: {
                super.writeExternal(out, marshaller);
                out.writeLong(this.lastAccessed);
                out.writeObject(this.user);
                out.writeBoolean(this.puts != null);
                if (this.puts != null) {
                    out.writeInt(this.puts.length);
                    try {
                        i = 0;
                        while (i < this.puts.length) {
                            out.writeObject(this.puts[i++]);
                            byte[] bytes = marshaller.serializableToBytes(this.puts[i++]);
                            out.writeObject(bytes);
                        }
                    }
                    catch (Throwable t) {
                        if (!m_logger.isLoggable(Level.FINEST)) break block6;
                        m_logger.log(Level.FINEST, "error serializing", t);
                    }
                }
            }
            out.writeBoolean(this.removes != null);
            if (this.removes != null) {
                out.writeInt(this.removes.length);
                for (i = 0; i < this.removes.length; ++i) {
                    out.writeObject(this.removes[i]);
                }
            }
            this.removes = null;
            this.puts = null;
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            int i;
            int count;
            super.readExternal(in, marshaller);
            this.lastAccessed = in.readLong();
            this.user = (String)in.readObject();
            if (in.readBoolean()) {
                count = in.readInt();
                this.puts = new Serializable[count];
                i = 0;
                while (i < count) {
                    Object o = in.readObject();
                    this.puts[i++] = (Serializable)o;
                    o = in.readObject();
                    this.puts[i++] = (Serializable)o;
                }
            }
            if (in.readBoolean()) {
                count = in.readInt();
                this.removes = new Serializable[count];
                for (i = 0; i < count; ++i) {
                    this.removes[i] = (Serializable)in.readObject();
                }
            }
        }
    }
}

