/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.naming;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class LookupFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new NamingException(obj + " is not a reference");
        }
        Reference ref = (Reference)obj;
        RefAddr remote = ref.get("remote-server-ref");
        if (remote != null && "true".equalsIgnoreCase((String)remote.getContent())) {
            return this.lookupInRemoteContext(ref);
        }
        return this.lookupInContext(nameCtx, ref);
    }

    private Object lookupInContext(Context context, Reference reference) throws NamingException {
        RefAddr location = reference.get("location");
        if (location == null) {
            throw new NamingException("No location found in reference " + reference);
        }
        if (context == null) {
            throw new NamingException("No root context available to lookup" + location.getContent());
        }
        Object obj = null;
        try {
            obj = context.lookup((String)location.getContent());
        }
        catch (NamingException e) {
            String lookupName = (String)location.getContent();
            if (lookupName.startsWith("corbaname:")) {
                obj = new InitialContext().lookup(lookupName);
            }
            throw e;
        }
        return obj;
    }

    private Object lookupInRemoteContext(Reference reference) throws NamingException, InstantiationException, IOException {
        Object obj = null;
        RefAddr jndiPropFile = reference.get("jndi-properties-file");
        if (jndiPropFile == null) {
            throw new NamingException("No jndi-properties-file in reference " + reference);
        }
        RefAddr location = reference.get("location");
        if (location == null) {
            throw new NamingException("No location found in reference " + reference);
        }
        Properties env = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceStream = classLoader.getResourceAsStream((String)jndiPropFile.getContent());
        if (resourceStream == null) {
            throw new InstantiationException("JNDI init:" + (String)jndiPropFile.getContent() + " not found in the ejb jar");
        }
        env.load(resourceStream);
        InitialContext context = new InitialContext(env);
        obj = context.lookup((String)location.getContent());
        return obj;
    }

    public static Reference createBinding(Class type, String location) {
        return LookupFactory.createBinding(type.getName(), location, true);
    }

    public static Reference createBinding(String typeClassName, String location, boolean cacheLookupResult) {
        Reference ref = new Reference(typeClassName, new StringRefAddr("location", location), LookupFactory.class.getName(), null);
        if (!cacheLookupResult) {
            ref.add(new StringRefAddr("CachePolicy", "NEVER"));
        }
        return ref;
    }
}

