/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.InputParam;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.OperatorBase;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import java.util.Iterator;
import java.util.Vector;

public abstract class BinaryOperator
extends OperatorBase {
    public static final boolean debug = false;
    public static final BinaryOperator IN_STRINGS = new InStrings(false);
    public static final BinaryOperator NOT_IN_STRINGS = new InStrings(true);
    public static final BinaryOperator EQUAL = new Equal(false);
    public static final BinaryOperator NOT_EQUAL = new Equal(true);
    public static final BinaryOperator GREATER_THAN = new GreaterThan();
    public static final BinaryOperator GREATER_THAN_OR_EQUAL = new GreaterThanOrEqual();
    public static final BinaryOperator LESS_THAN_OR_EQUAL = new LessThanOrEqual();
    public static final BinaryOperator LESS_THAN = new LessThan();
    public static final BinaryOperator ADD = new Add();
    public static final BinaryOperator SUBTRACT = new Subtract();
    public static final BinaryOperator MULTIPLY = new Multiply();
    public static final BinaryOperator DIVIDE = new Divide();
    public static final BinaryOperator CONCAT = new Concat();
    public static final BinaryOperator MEMBER_OF = new MemberOf(false);
    public static final BinaryOperator NOT_MEMBER_OF = new MemberOf(true);
    public static final BinaryOperator SELECT_FIELD = new SelectField();

    public boolean isBinary() {
        return true;
    }

    public boolean operatesOn(Vector expressions) {
        if (expressions.size() != 2) {
            throw new IllegalArgumentException("Wrong arity");
        }
        return this.operatesOn((Expression)expressions.firstElement(), (Expression)expressions.lastElement());
    }

    public abstract boolean operatesOn(Expression var1, Expression var2);

    public String getResultType(Vector expressions) {
        if (!this.operatesOn(expressions)) {
            throw new IllegalArgumentException("Wrong expr type");
        }
        return this.getResultType((Expression)expressions.firstElement(), (Expression)expressions.lastElement());
    }

    public String getResultType(Expression firstExpr, Expression secondExpr) {
        return BOOLEAN_OBJECT_TYPE_NAME;
    }

    protected String getBinaryPromotionType(Expression firstExpr, Expression secondExpr) {
        if (BinaryOperator.hasDoubleType(firstExpr) || BinaryOperator.hasDoubleType(secondExpr)) {
            return DOUBLE_PRIMITIVE_TYPE_NAME;
        }
        if (BinaryOperator.hasFloatType(firstExpr) || BinaryOperator.hasFloatType(secondExpr)) {
            return FLOAT_PRIMITIVE_TYPE_NAME;
        }
        if (BinaryOperator.hasLongType(firstExpr) || BinaryOperator.hasLongType(secondExpr)) {
            return LONG_PRIMITIVE_TYPE_NAME;
        }
        return INTEGER_PRIMITIVE_TYPE_NAME;
    }

    public Iterator getPrintStrings(Vector expressions) {
        Vector<String> printStrings = new Vector<String>();
        printStrings.add(this.doGetPrintString());
        return printStrings.iterator();
    }

    protected abstract String doGetPrintString();

    private static boolean validInputParamComparison(InputParam inputParam, AbstractSchemaName abstractSchema) {
        boolean valid = false;
        EjbCMPEntityDescriptor ejbDescriptor = abstractSchema.getEjbDescriptor();
        Class paramClass = inputParam.getParamClass();
        ClassLoader classLoader = paramClass.getClassLoader();
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            String localClassName = ejbDescriptor.getLocalClassName();
            try {
                Class<?> localClass = classLoader.loadClass(localClassName);
                valid = localClass.isAssignableFrom(paramClass);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (!valid && ejbDescriptor.isRemoteInterfacesSupported()) {
            String remoteClassName = ejbDescriptor.getRemoteClassName();
            try {
                Class<?> remoteClass = classLoader.loadClass(remoteClassName);
                valid = remoteClass.isAssignableFrom(paramClass);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return valid;
    }

    private static AbstractSchemaName getAbstractSchema(Expression expr) {
        AbstractSchemaName abstractSchema = null;
        if (expr.isNavigationExpression()) {
            NavigationExpression navExpr = (NavigationExpression)expr;
            abstractSchema = navExpr.endsInCmrField() ? navExpr.getAbstractSchema() : null;
        } else if (expr.isIdentificationVar()) {
            IdentificationVar identVar = (IdentificationVar)expr;
            abstractSchema = identVar.getAbstractSchema();
        }
        return abstractSchema;
    }

    private static boolean equalityComparable(Expression firstExpression, Expression secondExpression) {
        boolean firstExprNumeric = BinaryOperator.hasNumericType(firstExpression);
        boolean secondExprNumeric = BinaryOperator.hasNumericType(secondExpression);
        if (firstExprNumeric || secondExprNumeric) {
            return firstExprNumeric && secondExprNumeric;
        }
        boolean firstExprBoolean = BinaryOperator.hasBooleanType(firstExpression);
        boolean secondExprBoolean = BinaryOperator.hasBooleanType(secondExpression);
        if (firstExprBoolean || secondExprBoolean) {
            return firstExprBoolean && secondExprBoolean;
        }
        boolean firstExprChar = BinaryOperator.hasCharType(firstExpression);
        boolean secondExprChar = BinaryOperator.hasCharType(secondExpression);
        if (firstExprChar || secondExprChar) {
            return firstExprChar && secondExprChar;
        }
        boolean firstExprString = BinaryOperator.hasStringType(firstExpression);
        boolean secondExprString = BinaryOperator.hasStringType(secondExpression);
        if (firstExprString || secondExprString) {
            return firstExprString && secondExprString;
        }
        boolean firstExprDate = BinaryOperator.hasDateType(firstExpression);
        boolean secondExprDate = BinaryOperator.hasDateType(secondExpression);
        if (firstExprDate || secondExprDate) {
            boolean res = firstExprDate && secondExprDate;
            return firstExprDate && secondExprDate;
        }
        AbstractSchemaName firstExprAbstractSchema = BinaryOperator.getAbstractSchema(firstExpression);
        if (firstExprAbstractSchema != null) {
            if (secondExpression.isInputParam()) {
                InputParam inputParam = (InputParam)secondExpression;
                return BinaryOperator.validInputParamComparison(inputParam, firstExprAbstractSchema);
            }
            AbstractSchemaName secondExprAbstractSchema = BinaryOperator.getAbstractSchema(secondExpression);
            return secondExprAbstractSchema != null && firstExprAbstractSchema.equals(secondExprAbstractSchema);
        }
        return false;
    }

    private static boolean scalarOperable(Expression firstExpression, Expression secondExpression) {
        return BinaryOperator.hasNumericType(firstExpression) && BinaryOperator.hasNumericType(secondExpression);
    }

    private static boolean scalarOrDateOperable(Expression firstExpression, Expression secondExpression) {
        return BinaryOperator.hasNumericType(firstExpression) && BinaryOperator.hasNumericType(secondExpression) || BinaryOperator.hasDateType(firstExpression) && BinaryOperator.hasDateType(secondExpression);
    }

    private static class SelectField
    extends BinaryOperator {
        private SelectField() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return false;
        }

        public String doGetPrintString() {
            return "SELECT SINGLE FIELD";
        }
    }

    private static class MemberOf
    extends BinaryOperator {
        private boolean not_;

        public MemberOf(boolean not) {
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitMemberOfExpression(operatorExpr);
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            boolean result = false;
            NavigationExpression secondExpr = (NavigationExpression)secondExpression;
            AbstractSchemaName secondExprSchema = secondExpr.getAbstractSchema();
            if (firstExpression.isInputParam()) {
                InputParam inputParam = (InputParam)firstExpression;
                result = BinaryOperator.validInputParamComparison(inputParam, secondExprSchema);
            } else {
                AbstractSchemaName firstExprSchema = firstExpression.isIdentificationVar() ? ((IdentificationVar)firstExpression).getAbstractSchema() : ((NavigationExpression)firstExpression).getAbstractSchema();
                result = firstExprSchema.equals(secondExprSchema);
            }
            return result;
        }

        public String doGetPrintString() {
            return this.not_ ? "NOT MEMBER_OF" : "MEMBER_OF";
        }
    }

    private static class Concat
    extends BinaryOperator {
        private Concat() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return Concat.hasStringType(firstExpression) && Concat.hasStringType(secondExpression);
        }

        public String getResultType(Expression firstExpression, Expression secondExpression) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public String doGetPrintString() {
            return "CONCAT";
        }
    }

    private static class Divide
    extends BinaryOperator {
        private Divide() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOperable(firstExpression, secondExpression);
        }

        public String getResultType(Expression firstExpression, Expression secondExpression) {
            return this.getBinaryPromotionType(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "/";
        }
    }

    private static class Multiply
    extends BinaryOperator {
        private Multiply() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOperable(firstExpression, secondExpression);
        }

        public String getResultType(Expression firstExpression, Expression secondExpression) {
            return this.getBinaryPromotionType(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "*";
        }
    }

    private static class Subtract
    extends BinaryOperator {
        private Subtract() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOperable(firstExpression, secondExpression);
        }

        public String getResultType(Expression firstExpression, Expression secondExpression) {
            return this.getBinaryPromotionType(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "-";
        }
    }

    private static class Add
    extends BinaryOperator {
        private Add() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOperable(firstExpression, secondExpression);
        }

        public String getResultType(Expression firstExpression, Expression secondExpression) {
            return this.getBinaryPromotionType(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "+";
        }
    }

    private static class LessThanOrEqual
    extends BinaryOperator {
        private LessThanOrEqual() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOrDateOperable(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "<=";
        }
    }

    private static class LessThan
    extends BinaryOperator {
        private LessThan() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOrDateOperable(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return "<";
        }
    }

    private static class GreaterThanOrEqual
    extends BinaryOperator {
        private GreaterThanOrEqual() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOrDateOperable(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return ">=";
        }
    }

    private static class GreaterThan
    extends BinaryOperator {
        private GreaterThan() {
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.scalarOrDateOperable(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return ">";
        }
    }

    private static class Equal
    extends BinaryOperator {
        private boolean not_;

        public Equal(boolean not) {
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitComparisonExpression(operatorExpr);
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return BinaryOperator.equalityComparable(firstExpression, secondExpression);
        }

        public String doGetPrintString() {
            return this.not_ ? "<>" : "=";
        }
    }

    private static class InStrings
    extends BinaryOperator {
        private boolean not_;

        public InStrings(boolean not) {
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitInExpression(operatorExpr);
        }

        public boolean operatesOn(Expression firstExpression, Expression secondExpression) {
            return InStrings.hasStringType(firstExpression) && InStrings.hasStringType(secondExpression);
        }

        public String doGetPrintString() {
            return this.not_ ? "NOT IN" : "IN";
        }
    }
}

