/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.web.EjbReference;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EjbReferenceDescriptor
extends EnvironmentProperty
implements EjbReference,
NamedDescriptor {
    public static String EXTERNAL_STATE = "external";
    public static String INTERNAL_UNRESOLVED_STATE = "internalUnresolved";
    public static String INTERNAL_RESOLVED_STATE = "internalResolved";
    private EjbAbstractDescriptor ejbDescriptor;
    private String state;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbReferenceDescriptor == null ? (class$com$sun$enterprise$deployment$EjbReferenceDescriptor = EjbReferenceDescriptor.class$("com.sun.enterprise.deployment.EjbReferenceDescriptor")) : class$com$sun$enterprise$deployment$EjbReferenceDescriptor);
    private BundleDescriptor referringBundle;
    private boolean local = false;
    private String originalLinkName = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbReferenceDescriptor;

    public EjbReferenceDescriptor(String name, String description, EjbAbstractDescriptor ejbDescriptor) {
        super(name, "", description);
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor(String name, String description, EjbAbstractDescriptor ejbDescriptor, boolean isLocal) {
        super(name, "", description);
        this.local = isLocal;
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor() {
        this.state = EXTERNAL_STATE;
    }

    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    public String getState() {
        return this.state;
    }

    public void setEjbDescriptor(EjbAbstractDescriptor ejbDescriptor) {
        if (ejbDescriptor instanceof EjbExternalDescriptor) {
            EjbExternalDescriptor e = (EjbExternalDescriptor)ejbDescriptor;
            this.state = !"".equals(e.getLinkName()) ? INTERNAL_UNRESOLVED_STATE : EXTERNAL_STATE;
        } else {
            this.state = INTERNAL_RESOLVED_STATE;
            if (this.ejbDescriptor != null && this.ejbDescriptor instanceof EjbExternalDescriptor) {
                this.originalLinkName = ((EjbExternalDescriptor)this.ejbDescriptor).getLinkName();
            }
            EjbDescriptor knownEjb = (EjbDescriptor)ejbDescriptor;
            knownEjb.addEjbReferencer(this);
        }
        if (Descriptor.isBoundsChecking()) {
            if (this.isLocal()) {
                if (ejbDescriptor.getLocalClassName() == null) {
                    throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidLocalInterfaceReference", "Trying to set an ejb-local-ref on an EJB while the EJB does not define local interfaces"));
                }
            } else if (ejbDescriptor.getRemoteClassName() == null) {
                throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidRemoteInterfaceReference", "Trying to set an ejb-ref on an EJB, while the EJB does not define remote interfaces"));
            }
        }
        this.ejbDescriptor = ejbDescriptor;
    }

    public void setJndiName(String jndiName) {
        this.setValue(jndiName);
    }

    public boolean isLinked() {
        return this.state.equals(INTERNAL_RESOLVED_STATE) || this.state.equals(INTERNAL_UNRESOLVED_STATE);
    }

    public String getLinkName() {
        if (INTERNAL_RESOLVED_STATE.equals(this.getState())) {
            if (this.originalLinkName != null && this.originalLinkName.length() != 0) {
                return this.originalLinkName;
            }
            return this.getEjbDescriptor().getName();
        }
        if (INTERNAL_UNRESOLVED_STATE.equals(this.getState())) {
            return ((EjbExternalDescriptor)this.getEjbDescriptor()).getLinkName();
        }
        if (EXTERNAL_STATE.equals(this.getState()) && Descriptor.isBoundsChecking()) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionincorrectapiusage", "Incorrect API usage - can't get the link name of an external reference"));
        }
        return "";
    }

    public String getJndiName() {
        return this.getValue();
    }

    public String getValue() {
        if (this.ejbDescriptor == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionejbrefhasnoejbdscrptor", "This ejb reference has no ejb descriptor"));
        }
        if (this.isLocal()) {
            if (INTERNAL_UNRESOLVED_STATE.equals(this.getState())) {
                return null;
            }
            return ((EjbDescriptor)this.ejbDescriptor).getLocalJndiName();
        }
        return this.ejbDescriptor.getJndiName();
    }

    public void setValue(String value) {
        if (this.ejbDescriptor == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionejbrefhasnoejbdscrptor", "This ejb reference has no ejb descriptor"));
        }
        super.setValue(value);
        if (!INTERNAL_RESOLVED_STATE.equals(this.getState())) {
            this.ejbDescriptor.setJndiName(value);
        }
    }

    public EjbAbstractDescriptor getEjbDescriptor() {
        if (this.ejbDescriptor == null) {
            this.ejbDescriptor = new EjbExternalDescriptor();
            this.state = EXTERNAL_STATE;
        }
        return this.ejbDescriptor;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String getType() {
        return this.getEjbDescriptor().getType();
    }

    public void setType(String type) {
        this.getEjbDescriptor().setType(type);
    }

    public String getHomeClassName() {
        if (this.local) {
            return this.getEjbDescriptor().getLocalHomeClassName();
        }
        return this.getEjbDescriptor().getHomeClassName();
    }

    public void setHomeClassName(String homeClassName) {
        if (!(this.ejbDescriptor instanceof EjbDescriptor)) {
            if (this.local) {
                this.getEjbDescriptor().setLocalHomeClassName(homeClassName);
            } else {
                this.getEjbDescriptor().setHomeClassName(homeClassName);
            }
        }
    }

    public String getBeanClassName() {
        if (this.local) {
            return this.getEjbDescriptor().getLocalClassName();
        }
        return this.getEjbDescriptor().getRemoteClassName();
    }

    public void setBeanClassName(String remoteClassName) {
        if (!(this.ejbDescriptor instanceof EjbDescriptor)) {
            if (this.local) {
                this.getEjbDescriptor().setLocalClassName(remoteClassName);
            } else {
                this.getEjbDescriptor().setRemoteClassName(remoteClassName);
            }
        }
    }

    public String setLinkName(String linkName) {
        if (this.getEjbDescriptor() instanceof EjbExternalDescriptor) {
            this.state = INTERNAL_UNRESOLVED_STATE;
            ((EjbExternalDescriptor)this.getEjbDescriptor()).setLinkName(linkName);
        }
        return linkName;
    }

    public String toString() {
        String toString = "Ejb-Ref-: ";
        if (this.state.equals(INTERNAL_RESOLVED_STATE)) {
            toString = toString + INTERNAL_RESOLVED_STATE + " ";
            toString = toString + super.getName() + "@jndi: " + this.getJndiName() + " - > " + this.getEjbDescriptor().getName();
        }
        if (this.state.equals(INTERNAL_UNRESOLVED_STATE)) {
            toString = toString + INTERNAL_UNRESOLVED_STATE + " ";
            toString = toString + super.getName() + "@jndi: " + this.getJndiName() + "@" + this.getEjbDescriptor();
        }
        if (this.state.equals(EXTERNAL_STATE)) {
            toString = toString + EXTERNAL_STATE + " ";
            toString = toString + super.getName() + "@jndi: " + this.getJndiName() + "@" + this.getEjbDescriptor();
        }
        return toString;
    }

    public boolean equals(Object object) {
        if (object instanceof EjbReference) {
            EjbReference ejbReference = (EjbReference)object;
            return ejbReference.getName().equals(this.getName());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

