/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import oracle.oc4j.corba.util.LocalStringManagerImpl;

public final class RelationRoleDescriptor
extends Descriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RelationRoleDescriptor.class);
    private EjbCMPEntityDescriptor owner;
    private PersistenceDescriptor pers;
    private RelationshipDescriptor relnDesc;
    private String roleSourceDescription;
    private String cmrField;
    private String cmrFieldDescription;
    private String cmrFieldType;
    private boolean isMany;
    private RelationRoleDescriptor partner;
    private boolean cascadeDelete;
    private CMRFieldInfo cmrFieldInfo;
    boolean needsForeignColumnInOwnerTableFlag = false;
    boolean needsForeignColumnInOwnerTableFlagInitialized = false;

    public String toString() {
        return super.toString() + " cmrField: " + this.cmrField + " cmrFieldType: " + this.cmrFieldType + " isMany: " + this.isMany + " cmrFieldInfo: " + this.cmrFieldInfo;
    }

    public PersistenceDescriptor getPersistenceDescriptor() {
        return this.pers;
    }

    public void setPersistenceDescriptor(PersistenceDescriptor newPers) {
        if (this.pers != null) {
            this.pers.invalidate();
        }
        this.pers = newPers;
        if (newPers != null) {
            this.owner = (EjbCMPEntityDescriptor)newPers.getParentDescriptor();
        }
        this.invalidateCMRFieldStuff();
    }

    private void invalidateCMRFieldStuff() {
        this.cmrFieldInfo = null;
        if (this.pers != null) {
            this.pers.invalidate();
        }
    }

    public RelationshipDescriptor getRelationshipDescriptor() {
        return this.relnDesc;
    }

    public void setRelationshipDescriptor(RelationshipDescriptor relnDesc) {
        this.relnDesc = relnDesc;
    }

    public void setOwner(EjbCMPEntityDescriptor owner) {
        this.owner = owner;
        this.invalidateCMRFieldStuff();
    }

    public EjbCMPEntityDescriptor getOwner() {
        return this.owner;
    }

    public RelationRoleDescriptor getPartner() {
        return this.partner;
    }

    public void setPartner(RelationRoleDescriptor partner) {
        this.partner = partner;
    }

    public void setRoleSourceDescription(String roleSourceDescription) {
        this.roleSourceDescription = roleSourceDescription;
    }

    public String getRoleSourceDescription() {
        if (this.roleSourceDescription == null) {
            this.roleSourceDescription = "";
        }
        return this.roleSourceDescription;
    }

    public void setCMRField(String cmrField) {
        this.cmrField = cmrField;
        this.invalidateCMRFieldStuff();
    }

    public String getCMRField() {
        return this.cmrField;
    }

    public void setCMRFieldDescription(String cmrFieldDescription) {
        this.cmrFieldDescription = cmrFieldDescription;
    }

    public String getCMRFieldDescription() {
        if (this.cmrFieldDescription == null) {
            this.cmrFieldDescription = "";
        }
        return this.cmrFieldDescription;
    }

    public void setCMRFieldType(String newCmrFieldType) {
        if (newCmrFieldType == null) {
            this.cmrFieldType = null;
            this.invalidateCMRFieldStuff();
        } else if (newCmrFieldType.equals("java.util.Collection") || newCmrFieldType.equals("java.util.Set")) {
            this.cmrFieldType = newCmrFieldType;
            this.invalidateCMRFieldStuff();
        } else {
            throw new IllegalArgumentException("cmr-field-type is " + newCmrFieldType + ", must be java.util.Collection or java.util.Set");
        }
    }

    public String getCMRFieldType() {
        return this.cmrFieldType;
    }

    public void setIsMany(boolean isMany) {
        this.isMany = isMany;
        this.invalidateCMRFieldStuff();
    }

    public boolean getIsMany() {
        return this.isMany;
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
    }

    public boolean getCascadeDelete() {
        return this.cascadeDelete;
    }

    public void setCMRFieldInfo(CMRFieldInfo cmrFieldInfo) {
        this.cmrFieldInfo = cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfo() {
        if (this.cmrFieldInfo == null && this.pers != null) {
            this.pers.getCMRFieldInfo();
        }
        return this.cmrFieldInfo;
    }

    public boolean needsForeignColumnInOwnerTable() {
        if (!this.needsForeignColumnInOwnerTableFlagInitialized) {
            this.needsForeignColumnInOwnerTableFlagInitialized = true;
            RelationRoleDescriptor partner = this.getPartner();
            if (!partner.getIsMany()) {
                if (!this.getIsMany()) {
                    this.needsForeignColumnInOwnerTableFlag = true;
                } else {
                    Boolean needsAssocTable;
                    String ownerName = partner.getOwner().getName();
                    String cmrName = partner.getCMRField();
                    if (cmrName == null) {
                        this.getPersistenceDescriptor();
                        cmrName = PersistenceDescriptor.makeReverseFkeyName(partner);
                    }
                    if ((needsAssocTable = this.getPersistenceDescriptor().getEjbBundleDescriptor().getAssociateUsingThirdTableFlag(ownerName, cmrName)) != null) {
                        this.needsForeignColumnInOwnerTableFlag = needsAssocTable == false;
                    }
                }
            }
        }
        return this.needsForeignColumnInOwnerTableFlag;
    }
}

