/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.client.orion.AdminCommandException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.DatabaseStore;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.MultiFileStore;
import oracle.as.j2ee.transaction.tpc.RMFactoryJndiLocation;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.jdbc.driver.OracleDriver;

public class OfflineTransactionLogTool {
    String m_logType;
    String m_location;
    String m_username;
    String m_password;
    String m_instanceIdOld;
    String m_instanceIdNew;
    String m_rmidLocationOld;
    String m_rmidLocationNew;
    String m_rmidArgOld;
    String m_rmidArgNew;
    boolean m_isUpdate;
    PrintStream m_printStream = System.out;

    public OfflineTransactionLogTool(List arguments, PrintStream printStream) throws AdminCommandException {
        this.m_printStream = printStream;
        this.parseArgsAndAnalyzeOrUpdate(arguments);
    }

    public OfflineTransactionLogTool(List arguments) throws AdminCommandException {
        this.parseArgsAndAnalyzeOrUpdate(arguments);
    }

    private void parseArgsAndAnalyzeOrUpdate(List arguments) throws AdminCommandException {
        String nextArg = this.getNextArgument(arguments, "command");
        if (nextArg.equals("-analyzeTransactionLogs")) {
            this.m_isUpdate = false;
        } else if (nextArg.equals("-updateTransactionLogs")) {
            this.m_isUpdate = true;
        } else {
            throw new AdminCommandException("Unknown command :" + nextArg);
        }
        while ((nextArg = this.getNextArgument(arguments, null)) != null) {
            if (nextArg.equals("-logType")) {
                this.m_logType = this.getNextArgument(arguments, "-logType");
                continue;
            }
            if (nextArg.equals("-location")) {
                this.m_location = this.getNextArgument(arguments, "-location");
                continue;
            }
            if (nextArg.equals("-username")) {
                this.m_username = this.getNextArgument(arguments, "-username");
                continue;
            }
            if (nextArg.equals("-password")) {
                this.m_password = this.getNextArgument(arguments, "-password");
                continue;
            }
            if (nextArg.equals("-instanceId")) {
                this.m_instanceIdOld = this.getNextArgument(arguments, "-instanceId");
                this.m_instanceIdNew = this.getNextArgument(arguments, "-instanceId");
                continue;
            }
            if (nextArg.equals("-branchLocation")) {
                this.m_rmidLocationOld = this.getNextArgument(arguments, "-branchLocation");
                this.m_rmidLocationNew = this.getNextArgument(arguments, "-branchLocation");
                continue;
            }
            if (nextArg.equals("-branchArg")) {
                this.m_rmidArgOld = this.getNextArgument(arguments, "-branchArg");
                this.m_rmidArgNew = this.getNextArgument(arguments, "-branchArg");
                continue;
            }
            throw new AdminCommandException("Unknown argument : " + nextArg);
        }
        if (this.m_isUpdate) {
            this.updateTransactionLogs();
        } else {
            this.analyzeTransactionLogs();
        }
    }

    private String getNextArgument(List args, String description) throws AdminCommandException {
        if (args == null || args.isEmpty()) {
            if (description != null) {
                throw new AdminCommandException("Missing argument for : " + description, 11);
            }
            return null;
        }
        return (String)args.remove(0);
    }

    PrintStream getPrintStream() {
        return this.m_printStream;
    }

    public void analyzeTransactionLogs() throws AdminCommandException {
        boolean isDBLog = this.isDBLog();
        this.getPrintStream().println("Summary list for " + (isDBLog ? "database store, location = " : "file store, location = ") + this.m_location);
        Store store = this.getStore(isDBLog);
        Iterator transactions = this.getTransactionsFromStore(store);
        while (transactions.hasNext()) {
            GlobalTransaction tx = (GlobalTransaction)transactions.next();
            this.getPrintStream().println("\n\t " + tx.toString());
        }
    }

    private boolean isDBLog() throws AdminCommandException {
        boolean isDBLog;
        String missingInfo;
        String string = this.m_logType == null ? "-logType" : (missingInfo = "" + this.m_location == null ? "-location" : "");
        if (!missingInfo.equals("")) {
            throw new AdminCommandException("Missing arguments for -analyzeTransactionLogs : " + missingInfo);
        }
        boolean bl = isDBLog = this.m_logType.startsWith("d") || this.m_logType.startsWith("D");
        if (isDBLog) {
            String string2 = this.m_username == null ? "-username" : (missingInfo = "" + this.m_password == null ? "-password" : "");
            if (!missingInfo.equals("")) {
                throw new AdminCommandException("Missing arguments for -analyzeTransactionLogs database store : " + missingInfo);
            }
        }
        return isDBLog;
    }

    public void updateTransactionLogs() throws AdminCommandException {
        boolean isDBLog = this.isDBLog();
        if (isDBLog) {
            this.updateDBStoreTransactionLogs();
            return;
        }
        this.getPrintStream().println("Updating transactions for " + (isDBLog ? "database store, location = " : "file store, location = ") + this.m_location);
        if (this.m_instanceIdOld != null && !isDBLog) {
            throw new AdminCommandException("Update of instanceId does not apply to file store, only database store");
        }
        Store store = this.getStore(isDBLog);
        Iterator transactions = this.getTransactionsFromStore(store);
        while (transactions.hasNext()) {
            GlobalTransaction tx = (GlobalTransaction)transactions.next();
            boolean txRequiresUpdate = this.isTxInstanceToBeUpdated(isDBLog, store, tx, this.m_instanceIdOld, this.m_instanceIdNew);
            for (int i = 0; i < tx.numberOfBranches(); ++i) {
                String rmFactoryArg;
                boolean rmidLocationRequiresUpdate = false;
                boolean rmidArgRequiresUpdate = false;
                Branch branch = tx.getBranch(i);
                RMFactoryJndiLocation rmFactoryJndiLocation = branch.getRmId().getRMFactoryJndiLocation();
                if (rmFactoryJndiLocation == null) {
                    throw new AdminCommandException("RM location is null for branch : " + branch);
                }
                if (rmFactoryJndiLocation.getJndiLocation().equals(this.m_rmidLocationOld)) {
                    rmidLocationRequiresUpdate = true;
                }
                if ((rmFactoryArg = branch.getRmId().getRMFactoryArg()) != null && rmFactoryArg.equals(this.m_rmidArgOld)) {
                    rmidArgRequiresUpdate = true;
                }
                if (!rmidLocationRequiresUpdate && !rmidArgRequiresUpdate) continue;
                txRequiresUpdate = true;
                try {
                    UpdateRMId rmid = new UpdateRMId(rmidLocationRequiresUpdate, this.m_rmidLocationOld, this.m_rmidLocationNew, rmidArgRequiresUpdate, this.m_rmidArgOld, this.m_rmidArgNew);
                    branch.setRMId(rmid);
                    continue;
                }
                catch (Exception exception) {
                    AdminCommandException adminException = new AdminCommandException("Error updating rmid for transaction " + tx);
                    adminException.initCause(exception);
                    throw adminException;
                }
            }
            if (!txRequiresUpdate) continue;
            int state = tx.getTransactionState();
            try {
                String txString = tx.toString();
                store.noteForget(tx);
                store.noteTransaction(tx, state);
                this.getPrintStream().println("\t updated : " + txString);
            }
            catch (Store.StoreException storeException) {
                AdminCommandException adminCommandException = new AdminCommandException("Exception while updating log for transaction : " + tx);
                adminCommandException.initCause(storeException);
                throw adminCommandException;
            }
        }
    }

    public void updateDBStoreTransactionLogs() throws AdminCommandException {
        Connection connection;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            connection = DriverManager.getConnection(this.m_location, this.m_username, this.m_password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            AdminCommandException adminCommandException = new AdminCommandException("SQLException while obtaining connection to update database store");
            adminCommandException.initCause(e);
            throw adminCommandException;
        }
        try {
            if (this.m_instanceIdOld != null) {
                connection.prepareStatement("update OC4J_TX set INSTANCE = '" + this.m_instanceIdNew + "' where INSTANCE = '" + this.m_instanceIdOld + "'").execute();
                connection.prepareStatement("update OC4J_RESOURCES set INSTANCE = '" + this.m_instanceIdNew + "' where INSTANCE = '" + this.m_instanceIdOld + "'").execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            AdminCommandException adminCommandException = new AdminCommandException("SQLException while updating instanceId of database store");
            adminCommandException.initCause(e);
            throw adminCommandException;
        }
        try {
            if (this.m_rmidLocationOld != null) {
                connection.prepareStatement("update OC4J_TX_BRANCH set JNDINAME = '" + this.m_rmidLocationNew + "' where JNDINAME = '" + this.m_rmidLocationOld + "'").execute();
                connection.prepareStatement("update OC4J_RESOURCES set JNDINAME = '" + this.m_rmidLocationNew + "' where JNDINAME = '" + this.m_rmidLocationOld + "'").execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            AdminCommandException adminCommandException = new AdminCommandException("SQLException while updating branchLocation of database store");
            adminCommandException.initCause(e);
            throw adminCommandException;
        }
        try {
            if (this.m_rmidArgOld != null) {
                connection.prepareStatement("update OC4J_TX_BRANCH set ARG = '" + this.m_rmidArgNew + "' where ARG = '" + this.m_rmidArgOld + "'").execute();
                connection.prepareStatement("update OC4J_RESOURCES set ARG = '" + this.m_rmidArgNew + "' where ARG = '" + this.m_rmidArgOld + "'").execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            AdminCommandException adminCommandException = new AdminCommandException("SQLException while updating branchArg of database store");
            adminCommandException.initCause(e);
            throw adminCommandException;
        }
    }

    private boolean isTxInstanceToBeUpdated(boolean DBLog, Store store, GlobalTransaction tx, String instanceIdOld, String instanceIdNew) throws AdminCommandException {
        if (DBLog) {
            try {
                store.recover(tx.getXid());
            }
            catch (Store.StoreException storeException) {
                AdminCommandException adminCommandException = new AdminCommandException("Exception while retrieving record from database store for transaction : " + tx);
                adminCommandException.initCause(storeException);
                throw adminCommandException;
            }
            if (instanceIdOld != null && store.serverId().equals(instanceIdOld)) {
                ((DatabaseStore)store).setServerId(instanceIdNew);
                return true;
            }
        }
        return false;
    }

    private Store getStore(boolean DBLog) throws AdminCommandException {
        Store store;
        try {
            store = DBLog ? new DatabaseStore(this.m_location, this.m_username, this.m_password) : new MultiFileStore(this.m_location);
        }
        catch (Exception exception) {
            AdminCommandException adminException = new AdminCommandException("Error creating store");
            adminException.initCause(exception);
            throw adminException;
        }
        return store;
    }

    private Iterator getTransactionsFromStore(Store store) throws AdminCommandException {
        Iterator transactions;
        try {
            transactions = store.recover().iterator();
        }
        catch (Store.StoreException storeException) {
            AdminCommandException adminException = new AdminCommandException("Error getting transaction list from store");
            adminException.initCause(storeException);
            throw adminException;
        }
        return transactions;
    }

    private class UpdateRMFactoryJndiLocation
    implements RMFactoryJndiLocation {
        String m_jndiLocation;

        UpdateRMFactoryJndiLocation(String jndiLocation) {
            this.m_jndiLocation = jndiLocation;
        }

        public String getJndiLocation() {
            return this.m_jndiLocation;
        }

        public String toString() {
            return this.m_jndiLocation;
        }
    }

    private class UpdateRMId
    implements RMId {
        private boolean m_rmidLocationRequiresUpdate;
        private String m_rmidLocationOld;
        private String m_rmidLocationNew;
        private boolean m_rmidArgRequiresUpdate;
        private String m_rmidArgOld;
        private String m_rmidArgNew;

        public UpdateRMId(boolean rmidLocationRequiresUpdate, String rmidLocationOld, String rmidLocationNew, boolean rmidArgRequiresUpdate, String rmidArgOld, String rmidArgNew) {
            this.m_rmidLocationRequiresUpdate = rmidLocationRequiresUpdate;
            this.m_rmidLocationOld = rmidLocationOld;
            this.m_rmidLocationNew = rmidLocationNew;
            this.m_rmidArgRequiresUpdate = rmidArgRequiresUpdate;
            this.m_rmidArgOld = rmidArgOld;
            this.m_rmidArgNew = rmidArgNew;
        }

        public RMFactoryJndiLocation getRMFactoryJndiLocation() {
            return this.m_rmidLocationRequiresUpdate ? new UpdateRMFactoryJndiLocation(this.m_rmidLocationNew) : new UpdateRMFactoryJndiLocation(this.m_rmidLocationOld);
        }

        public String getRMFactoryArg() {
            return this.m_rmidArgRequiresUpdate ? this.m_rmidArgNew : this.m_rmidArgOld;
        }

        public String toString() {
            String rmArg = "";
            if (this.getRMFactoryArg() != null) {
                rmArg = "," + this.getRMFactoryArg();
            }
            return "RMId(" + this.getRMFactoryJndiLocation().toString() + " " + rmArg + ")";
        }
    }
}

