/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ias.container.logging.ContainerServiceMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class ContainerServiceMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.ias.container", ContainerServiceMessageBundle.class.getName());

    public static void warningException(Exception e) {
        if (ContainerServiceMessages.isLoggable(Level.WARNING)) {
            ContainerServiceMessages.logException(m_logger, Level.WARNING, "J2EE OJR-01001", new Object[0], e);
        }
    }

    public static void warningMaximumConccurentTimer(Exception e) {
        if (ContainerServiceMessages.isLoggable(Level.WARNING)) {
            ContainerServiceMessages.logException(m_logger, Level.WARNING, "J2EE OJR-01002", new Object[0], e);
        }
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void logException(Logger logger, Level level, String message, Object[] params, Throwable t) {
        LogRecord lr = new LogRecord(level, message);
        lr.setParameters(params);
        lr.setThrown(t);
        lr.setLoggerName(logger.getName());
        lr.setResourceBundleName(logger.getResourceBundleName());
        lr.setResourceBundle(logger.getResourceBundle());
        logger.log(lr);
    }
}

