/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBTimerMessages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.EJBTimerImpl;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerCallbacks;
import oracle.ias.container.timer.TimerService;
import oracle.j2ee.ejb.timer.EJBTimer;
import oracle.j2ee.ejb.timer.EJBTimerService;

public class EJBTimerServiceImpl
implements EJBTimerService,
TimerCallbacks {
    private static TimerService _timerService = TimerService.instance();
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(EJBTimerServiceImpl.class);
    public static final String CLSNAMEDELIM = "|";
    private final boolean IS_BEAN_CREATED = true;
    private String _clsName = null;
    private Object _pk = null;
    private boolean _local = false;
    private AbstractEJBContext _ctx = null;
    private boolean _saveCreator = false;

    private EJBTimerServiceImpl(AbstractEJBContext ctx, Object pk) {
        if (ctx == null) {
            RuntimeException anException = new RuntimeException("EJBTimerServiceImpl() - Bean without a context!!");
            EJBTimerMessages.warningException(anException);
            throw anException;
        }
        this._ctx = ctx;
        this._pk = pk;
        this._local = this._ctx.localHome != null;
        this._clsName = EJBTimerServiceImpl.extractClassName(this._ctx.getBeanDescriptor());
    }

    private static String extractClassName(BeanDescriptor descriptor) {
        String appName = descriptor.getPackage().getContainer().getApplication().getName();
        String jarName = descriptor.getPackage().getName();
        String beanName = descriptor.getName();
        return appName + CLSNAMEDELIM + jarName + CLSNAMEDELIM + beanName;
    }

    private int getBeanType() {
        return this._ctx.getBeanDescriptor().getBeanType();
    }

    public static EJBTimerService create() {
        System.out.println("This cannot be invoked by EJBs");
        return new EJBTimerServiceImpl(null, null);
    }

    public static EJBTimerService create(AbstractEJBContext ctx) {
        return new EJBTimerServiceImpl(ctx, null);
    }

    public static EJBTimerService create(AbstractEJBContext ctx, Object pk) {
        return new EJBTimerServiceImpl(ctx, pk);
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        this.checkCallPermission();
        if (this._ctx.getBeanDescriptor().isEntity()) {
            return EJBTimerServiceImpl.getEntityBeanTimers(this._clsName, this._pk);
        }
        return EJBTimerServiceImpl.getEJBTimers(this.getBeanType(), this._clsName);
    }

    private static Collection getEJBTimers(int beanType, String className) {
        m_logger.finest("EJBTimerServiceImpl -- getEJBTimers: ENTER");
        Collection col = _timerService.getTimers();
        ArrayList<EJBTimerImpl> list = new ArrayList<EJBTimerImpl>();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            Timer t = (Timer)iterator.next();
            if (!t.isBeanCreated() || t.getBeanType() != beanType || !t.getTimerEntry().getFullClassName().equals(className)) continue;
            list.add(new EJBTimerImpl(t));
        }
        return list;
    }

    public void removeEntityBeanTimers() {
        Collection timers = EJBTimerServiceImpl.getEntityBeanTimers(this._clsName, this._pk);
        Iterator iterator = timers.iterator();
        while (iterator.hasNext()) {
            ((EJBTimerImpl)iterator.next()).cancel();
        }
    }

    private static Collection getEJBTimers(Object home) {
        BeanDescriptor descriptor = home instanceof MessageDrivenHome ? ((MessageDrivenHome)home).getMessageDrivenBeanDescriptor() : ((AbstractEJBHome)home).getBeanDescriptor();
        return EJBTimerServiceImpl.getEJBTimers(descriptor.getBeanType(), EJBTimerServiceImpl.extractClassName(descriptor));
    }

    private static Collection getEntityBeanTimers(String className, Object pk) throws IllegalStateException, EJBException {
        m_logger.finest("EJBTimerServiceImpl -- getEntityBeanTimers: ENTER");
        Collection col = _timerService.getTimers();
        ArrayList<EJBTimerImpl> list = new ArrayList<EJBTimerImpl>();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            Timer t = (Timer)iterator.next();
            if (!t.isBeanCreated() || t.getBeanType() != 0 || !t.getTimerEntry().getFullClassName().equals(className) || !t.getPK().equals(pk)) continue;
            list.add(new EJBTimerImpl(t));
        }
        return list;
    }

    public static void removeBeanTimers(Object home) {
        m_logger.finest("EJBTimerServiceImpl -- removeBeanTimers: ENTER");
        Collection col = EJBTimerServiceImpl.getEJBTimers(home);
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            EJBTimerImpl t = (EJBTimerImpl)iterator.next();
            try {
                t.cancel();
            }
            catch (NoSuchObjectLocalException e) {
                // empty catch block
            }
            m_logger.finest("EJBTimerServiceImpl -- removeBeanTimers: Cancelled timer");
        }
    }

    public static void passivateBeanTimers(Object home) {
        m_logger.finest("EJBTimerServiceImpl -- passivateBeanTimers: ENTER");
        Collection col = EJBTimerServiceImpl.getEJBTimers(home);
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            EJBTimerImpl t = (EJBTimerImpl)iterator.next();
            t.passivate();
            m_logger.finest("EJBTimerServiceImpl -- passivateBeanTimers: Passivated timer");
        }
    }

    public static void activateBeanTimers(Object home) {
        m_logger.finest("EJBTimerServiceImpl -- activateBeanTimers: ENTER");
        Collection col = EJBTimerServiceImpl.getEJBTimers(home);
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            EJBTimerImpl t = (EJBTimerImpl)iterator.next();
            t.activate();
            m_logger.finest("EJBTimerServiceImpl -- activateBeanTimers: Activated timer");
        }
    }

    public EJBTimer createTimer(long duration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(duration, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(long initialDuration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(initialDuration, intervalDuration, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(Date expiration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(expiration, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(Date initialExpiration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(initialExpiration, intervalDuration, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public javax.ejb.Timer createTimer(long l, Serializable serializable) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(l, this._clsName, serializable);
    }

    public javax.ejb.Timer createTimer(long initialDuration, long intervalDuration, Serializable serializable) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(initialDuration, intervalDuration, this._clsName, serializable);
    }

    public javax.ejb.Timer createTimer(Date date, Serializable serializable) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(date, this._clsName, serializable);
    }

    public javax.ejb.Timer createTimer(Date date, long intervalDuration, Serializable serializable) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(date, intervalDuration, this._clsName, serializable);
    }

    public EJBTimer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String year, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(String cronline, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        Timer timer = _timerService._createTimer(cronline, className, info, (TimerCallbacks)this);
        return this.buildEJBTimer(timer);
    }

    public EJBTimer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this.createTimer(minute, hour, dayOfMonth, month, dayOfWeek, this._clsName, info);
    }

    public EJBTimer createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this.createTimer(minute, hour, dayOfMonth, month, dayOfWeek, this._clsName, info);
    }

    public EJBTimer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this.createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, this._clsName, info);
    }

    public EJBTimer createTimer(Serializable info, String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String year) throws IllegalArgumentException, IllegalStateException {
        return this.createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, this._clsName, info);
    }

    public EJBTimer createTimer(String cronline, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this.createTimer(cronline, this._clsName, info);
    }

    private void checkCallPermission() throws IllegalStateException {
        if (!this._ctx.getBeanDescriptor().isMessageDriven() && this._ctx.getEvermindHome().inEjbCreate || this._ctx.actionTaken == 6 || this._ctx.actionTaken == 2) {
            IllegalStateException anException = new IllegalStateException("Cannot call TimerInterface methods from ejbCreate!!");
            EJBTimerMessages.warningException(this._ctx.getBeanDescriptor(), anException);
            throw anException;
        }
    }

    public void saveSecurityContext() {
        this._saveCreator = true;
    }

    public void doNotSaveSecurityContext() {
        this._saveCreator = false;
    }

    public boolean saveCreator() {
        return this._saveCreator;
    }

    public boolean internalHasPK() {
        return this._pk != null;
    }

    private EJBTimer buildEJBTimer(Timer timer) {
        timer.registerForTxn();
        return new EJBTimerImpl(timer);
    }

    public void postInitTimer(Timer timer) {
        timer.setBeanInfo(this._pk, true, this._local, this.getBeanType(), this._saveCreator, this._saveCreator ? ThreadState.getCurrentState().user : null);
    }
}

