/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import oracle.ias.container.scheduler.ExecutorEvent;
import oracle.ias.container.scheduler.ExecutorService;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerService;

public class TimerEvent
extends ExecutorEvent {
    protected long time;
    protected Timer timer;

    public TimerEvent(long time, Timer timer) {
        super(TimerService.k_timerServiceId);
        this.time = time;
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public TimerEntry getTimerEntry() {
        return this.timer.getTimerEntry();
    }

    public long getTime() {
        return this.time;
    }

    protected void setExecutionTime(long l) {
        this.timer.getTimerEntry().lastExecuted = this.time = l;
    }

    public int setState(int state, boolean publish) {
        int prev = this._state;
        this._state = state;
        if (publish) {
            TimerService.instance().publish(this);
            switch (state) {
                case 3: {
                    ExecutorService.instance().incRunningTasks();
                    break;
                }
                case 4: {
                    ExecutorService.instance().decRunningTasks();
                }
            }
        }
        return prev;
    }
}

