/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.Application;
import com.evermind.server.ApplicationComponentCallBackIf;
import com.evermind.server.ApplicationServer;
import com.evermind.server.connector.deployment.AdminObjectInstance;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.util.TaskManager;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.ConnectorMessages;
import oracle.j2ee.connector.JCAMBeanFactory;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.management.callbackinterfaces.ManageableResourceAdapter;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterCallBackIf;
import oracle.oc4j.admin.management.mbeans.ResourceAdapter;

public class DeployedAdapter
implements ApplicationComponentCallBackIf,
ManageableResourceAdapter {
    private ConnectorArchive m_oc4jDescriptorConfig;
    private ConnectorModule m_oc4jDeploymentConfig;

    public DeployedAdapter(ConnectorModule oc4jDeploymentConfig) {
        this.m_oc4jDeploymentConfig = oc4jDeploymentConfig;
        this.m_oc4jDescriptorConfig = new ConnectorArchive(oc4jDeploymentConfig.getName());
    }

    public DeployedAdapter(ConnectorModule oc4jDeploymentConfig, ConnectorArchive oc4jDescriptorConfig) {
        this.m_oc4jDeploymentConfig = oc4jDeploymentConfig;
        this.m_oc4jDescriptorConfig = oc4jDescriptorConfig;
    }

    public void start(Application application, TaskManager taskManager, Notifier notifier) throws InstantiationException {
        if (this.m_oc4jDescriptorConfig.isMaintainStatistics() && this.m_oc4jDescriptorConfig.getNoun() == null && ApplicationServer.DMS_GATE) {
            NounIntf parent = application.getApplicationNoun();
            this.m_oc4jDescriptorConfig.setDmsNoun(ApplicationServer.nounFactory().create(parent, this.getDeployedName(), "oc4j_jca_resource"));
        }
        this.m_oc4jDescriptorConfig.setApplication(application);
        this.m_oc4jDescriptorConfig.setTaskmanager(taskManager);
        this.registerResourceAdapterMBean();
        try {
            if (this.m_oc4jDescriptorConfig.getResourceAdapterDescriptor() != null) {
                this.m_oc4jDescriptorConfig.startResourceAdapter(application, notifier);
            }
            this.m_oc4jDescriptorConfig.startOutboundConnectionFactories(application, taskManager, notifier);
            this.startAdminObjects(application, notifier);
            this.m_oc4jDescriptorConfig.registerJCAResourceMBean();
            this.m_oc4jDescriptorConfig.registerWorkManagerResourceMBean();
            this.m_oc4jDescriptorConfig.registerSharedConnectionPoolMBeans();
            this.m_oc4jDescriptorConfig.setStartTime(System.currentTimeMillis());
            this.m_oc4jDescriptorConfig.setComponentState(1);
        }
        catch (InstantiationException e) {
            this.m_oc4jDescriptorConfig.setComponentState(4);
            throw e;
        }
    }

    public void start() throws Exception {
        this.m_oc4jDescriptorConfig.setComponentState(0);
        if (this.m_oc4jDescriptorConfig.getApplication() == null) {
            throw new InstantiationException("Resource adapter cannot be started if it has not been started previously.");
        }
        this.start(this.m_oc4jDescriptorConfig.getApplication(), this.m_oc4jDescriptorConfig.getTaskManager(), null);
        this.getResourceAdapterWrapper().reactivateAllEndpoints();
    }

    public void stop(boolean destroy) {
        this.m_oc4jDescriptorConfig.setComponentState(2);
        if (this.getResourceAdapterWrapper() != null) {
            this.getResourceAdapterWrapper().deactivateAllEndpoints();
        }
        this.m_oc4jDescriptorConfig.stop(destroy);
        this.m_oc4jDescriptorConfig.setComponentState(3);
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        return this.m_oc4jDescriptorConfig.getResourceAdapter();
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.m_oc4jDescriptorConfig.getResourceAdapterWrapper();
    }

    public ConnectorArchive getOc4jDescriptorConfig() {
        return this.m_oc4jDescriptorConfig;
    }

    public ConnectorModule getOc4jDeploymentConfig() {
        return this.m_oc4jDeploymentConfig;
    }

    public boolean isDatasourceAdapter() {
        return this.m_oc4jDescriptorConfig.isDataSourceArchive();
    }

    public String getName() {
        return this.m_oc4jDescriptorConfig.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentStop(List componentList) {
        if (this.m_oc4jDescriptorConfig.getComponentState() == 3 || this.m_oc4jDescriptorConfig.getComponentState() == 2) {
            return;
        }
        try {
            this.stop(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List list = componentList;
        synchronized (list) {
            componentList.remove(this);
        }
    }

    public int getComponentState() {
        return this.m_oc4jDescriptorConfig.getComponentState();
    }

    public String getDeployedName() {
        return this.m_oc4jDeploymentConfig.getName();
    }

    public ResourceAdapterCallBackIf getConfiguration() {
        return this.m_oc4jDescriptorConfig;
    }

    private void startAdminObjects(Application _application, Notifier _notifier) {
        List adminObjects = this.m_oc4jDeploymentConfig.getAdminObjectInstances();
        if (adminObjects == null) {
            return;
        }
        Iterator iter = adminObjects.iterator();
        while (iter.hasNext()) {
            AdminObjectInstance adminObj = (AdminObjectInstance)iter.next();
            try {
                this.m_oc4jDescriptorConfig.createAdminObjectInstance(adminObj, _application);
            }
            catch (InstantiationException e) {
                String[] params;
                String jndiLocation = adminObj.getLocation();
                if (_application == _application.getServer().getDefaultApplication()) {
                    ConnectorMessages.warningBadAdminLocationStandalone(jndiLocation, e);
                    if (_notifier == null) continue;
                    params = new String[]{jndiLocation};
                    _notifier.sendNotification("WARNING_CANNOT_SET_ADMIN_OBJECT_FOR_RESOURCE_ADAPTER", params);
                    continue;
                }
                ConnectorMessages.warningBadAdminLocation(jndiLocation, _application, e);
                if (_notifier == null) continue;
                params = new String[]{jndiLocation, _application.getName()};
                _notifier.sendNotification("WARNING_CANNOT_SET_ADMIN_OBJECT_FOR_RESOURCE_ADAPTER_IN", params);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceAdapterMBean() {
        ConnectorArchive connectorArchive = this.m_oc4jDescriptorConfig;
        synchronized (connectorArchive) {
            if (this.m_oc4jDeploymentConfig == null || this.m_oc4jDescriptorConfig.getApplication() == null) {
                return;
            }
            if (this.m_oc4jDescriptorConfig.isMaintainMBeans() && this.m_oc4jDescriptorConfig.getResourceAdapterMBean() == null) {
                this.m_oc4jDescriptorConfig.setResourceAdapterMBean(new ResourceAdapter(this, this.m_oc4jDescriptorConfig.getDisplayName(), this.getDeployedName(), this.m_oc4jDescriptorConfig.getApplication().getName()));
                JCAMBeanFactory.registerMBean(this.m_oc4jDescriptorConfig.getResourceAdapterMBean());
            }
        }
    }

    ClassLoader getClassLoader() {
        return this.m_oc4jDescriptorConfig.getClassLoader();
    }

    public File[] getCodeSources() {
        return this.m_oc4jDescriptorConfig.getCodeSources();
    }

    public boolean checkForActiveEndpoints(List dependentAppNames) {
        return this.m_oc4jDescriptorConfig.checkForActiveEndpoints(dependentAppNames);
    }
}

