/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.ConnectionContext;
import com.evermind.server.connector.ConnectionHandleContext;
import com.evermind.server.connector.ContainerAuthenticationData;
import com.evermind.server.deployment.ResourceReference;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.Transaction;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.j2ee.connector.ExtendedConnectionManager;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;

public class OracleConnectionManager
implements ConnectionManager,
LazyEnlistableConnectionManager,
ExtendedConnectionManager,
LazyAssociatableConnectionManager,
Cloneable {
    private static Logger m_logger = JCATraceLogger.getLogger(OracleConnectionManager.class);
    private static Permission constructPermission = OC4JSecurity.getRuntimePermission("connector.OracleConnectionManager");
    private boolean m_shareableConnections = true;
    private boolean m_allowReassociationForUnshareableConnections = true;
    private boolean m_containerAuthentication = true;
    private ApplicationConnectionManager m_acm;
    private boolean m_wrapSubObjects = false;
    private transient Map m_proxySuperClassMap = null;
    private transient Set m_noProxyResultMethods = null;
    private static Set m_defaultWrappableObjectTypes = new HashSet();

    public OracleConnectionManager(ApplicationConnectionManager acm) {
        OC4JSecurity.checkPermission(constructPermission);
        this.m_acm = acm;
        this.setWrappableSubObjectTypes(m_defaultWrappableObjectTypes);
    }

    public OracleConnectionManager(ApplicationConnectionManager acm, boolean containerAuthentication, boolean shareableConnections) {
        this(acm);
        this.setConnectionsShareable(shareableConnections);
        this.m_containerAuthentication = containerAuthentication;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",ApplicationConnectionManager=" + acm + ",containerAuthentication=" + containerAuthentication + ",shareableConnections=" + shareableConnections);
        }
    }

    public void setConnectionsShareable(boolean shareableConnections) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",shareableConnections=" + shareableConnections);
        }
        this.m_shareableConnections = shareableConnections;
    }

    public boolean areConnectionsShareable() {
        return this.m_shareableConnections;
    }

    public void setAllowReassociationForUnshareableConnections(boolean allowReassociationForUnshareableConnections) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",allowReassociationForUnshareableConnections=" + allowReassociationForUnshareableConnections);
        }
        this.m_allowReassociationForUnshareableConnections = allowReassociationForUnshareableConnections;
    }

    public void setContainerAuthentication(boolean value) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",containerAuthentication=" + value);
        }
        this.m_containerAuthentication = value;
    }

    public boolean isContainerAuthentication() {
        return this.m_containerAuthentication;
    }

    public Object getBindObject() throws InstantiationException {
        Object cxf = null;
        ManagedConnectionFactory mcf = this.m_acm.getMcf();
        try {
            cxf = mcf.createConnectionFactory((ConnectionManager)this);
        }
        catch (ResourceException e) {
            throw new InstantiationException("Error creating a Connection Factory from class '" + mcf.getClass().getName() + "'. Reason: " + (Object)((Object)e));
        }
        return cxf;
    }

    public Object allocateConnection(final ManagedConnectionFactory managedConnectionFactory, final ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws ResourceException {
                return OracleConnectionManager.this.unprivileged_allocateConnection(managedConnectionFactory, connectionRequestInfo);
            }
        };
        try {
            return OC4JSecurity.doPrivileged(action);
        }
        catch (ResourceException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object unprivileged_allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",managedConnectionFactory=" + managedConnectionFactory);
        }
        long dmsToken = 0L;
        PhaseEventIntf waitTimeEvent = null;
        PhaseEventIntf poolWaitTimeEvent = null;
        if (ApplicationServer.DMS_GATE) {
            waitTimeEvent = this.m_acm.getWaitTimeEvent();
            if (waitTimeEvent != null) {
                dmsToken = waitTimeEvent.start();
            }
            if ((poolWaitTimeEvent = this.m_acm.getSharedPoolWaitTimeEvent()) != null) {
                poolWaitTimeEvent.start(dmsToken);
            }
        }
        Object connection = null;
        try {
            connection = this.m_acm.allocateConnection(managedConnectionFactory, connectionRequestInfo, this);
        }
        catch (ResourceException e) {
            if (waitTimeEvent != null) {
                waitTimeEvent.abort(dmsToken);
            }
            if (poolWaitTimeEvent != null) {
                poolWaitTimeEvent.abort(dmsToken);
            }
            throw e;
        }
        if (waitTimeEvent != null) {
            waitTimeEvent.stop(dmsToken);
        }
        if (poolWaitTimeEvent != null) {
            poolWaitTimeEvent.stop(dmsToken);
        }
        return connection;
    }

    public Object clone() {
        return new OracleConnectionManager(this.m_acm, this.m_containerAuthentication, this.m_shareableConnections);
    }

    Transaction getTransaction() {
        return this.m_acm.getTransaction();
    }

    public void lazyEnlist(ManagedConnection managedConnection) throws ResourceException {
        this.m_acm.lazyEnlist(managedConnection);
    }

    public void checkAssociation(Object handle, ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ConnectionContext connectionContext = this.m_acm.getConnectionContext(managedConnection);
        if (connectionContext == null || this.getTransaction() != connectionContext.getXaTransaction()) {
            connectionContext = this.reassociateIfRequired(handle, connectionContext, managedConnectionFactory, connectionRequestInfo);
        }
    }

    protected ConnectionContext reassociateIfRequired(Object handle, ConnectionContext connectionContext, ManagedConnectionFactory mcf, ConnectionRequestInfo requestInfo) throws ResourceException {
        if (connectionContext != null && connectionContext.isInLocalTx()) {
            return connectionContext;
        }
        if (!this.canConnectionsBeReassociated()) {
            return connectionContext;
        }
        ContainerAuthenticationData authData = this.m_acm.getContainerAuthenticationData(mcf);
        ConnectionContext newContext = this.getCtxFromTxAssociation(this.getTransaction(), mcf, authData, requestInfo, handle);
        if (newContext == null) {
            if (this.keepCurrentContext(connectionContext, handle)) {
                return connectionContext;
            }
            newContext = this.m_acm.getConnectionFromPool(mcf, requestInfo, authData, this.areConnectionsShareable());
            newContext.setSupportsFastSuspend(true);
        }
        if (this.needToReassociate(connectionContext, newContext, handle)) {
            this.reassociateConnection(newContext, handle, connectionContext);
            connectionContext = newContext;
        }
        return connectionContext;
    }

    public boolean canConnectionsBeReassociated() {
        return this.m_shareableConnections || this.m_acm.areXAResourcesEmulated() || this.m_allowReassociationForUnshareableConnections;
    }

    private void reassociateConnection(ConnectionContext newContext, Object handle, ConnectionContext oldContext) throws ResourceException {
        ManagedConnection managedConnection = newContext.getManagedConnection();
        managedConnection.associateConnection(handle);
        ConnectionHandleContext handleContext = null;
        Throwable creationStackTrace = null;
        AbstractProxy proxy = null;
        handleContext = oldContext != null ? oldContext.endAssociation(handle) : this.m_acm.getDisassociatedHandleContext(handle);
        if (handleContext != null) {
            creationStackTrace = handleContext.getCreationStacktrace();
            proxy = handleContext.getProxy();
        }
        newContext.beginAssociation(handle, proxy, creationStackTrace);
    }

    private boolean needToReassociate(ConnectionContext connectionContext, ConnectionContext newConnectionContext, Object handle) {
        boolean needToReassociate;
        boolean bl = needToReassociate = connectionContext == null || newConnectionContext != connectionContext;
        if (!needToReassociate) {
            needToReassociate = !connectionContext.isAssociated(handle);
        }
        return needToReassociate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepCurrentContext(ConnectionContext currentConnectionContext, Object handle) {
        if (currentConnectionContext != null) {
            ConnectionContext connectionContext = currentConnectionContext;
            synchronized (connectionContext) {
                return currentConnectionContext.isAssociated(handle) && !currentConnectionContext.isAssociatedWithTransaction() && !currentConnectionContext.isShared();
            }
        }
        return false;
    }

    private ConnectionContext getCtxFromTxAssociation(Transaction tx, ManagedConnectionFactory mcf, ContainerAuthenticationData authData, ConnectionRequestInfo connectionRequestInfo, Object handle) throws ResourceException {
        ConnectionContext newContext = this.m_shareableConnections ? this.m_acm.getConnectionFromShareablePool(mcf, authData, connectionRequestInfo) : this.m_acm.getConnectionFromUnshareablePool(tx, handle);
        return newContext;
    }

    public void setBoundJNDILocation(Context context, ResourceReference reference) {
        this.m_acm.boundJNDILocations.put(context, reference);
    }

    public void associateConnection(Object handle, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.reassociateIfRequired(handle, null, managedConnectionFactory, connectionRequestInfo);
    }

    public boolean wrapSubObjects() {
        return this.m_wrapSubObjects;
    }

    public void setWrapSubObjects(boolean wrapSubObjects) {
        this.m_wrapSubObjects = wrapSubObjects;
    }

    public Set getNoProxyResultMethods() {
        return this.m_noProxyResultMethods;
    }

    public void setNoProxyResultMethods(Set noProxyResultMethods) {
        this.m_noProxyResultMethods = noProxyResultMethods;
    }

    public Map getProxySuperClassMap() {
        return this.m_proxySuperClassMap;
    }

    public void setWrappableSubObjectTypes(Set wrappableSubObjectTypes) {
        if (wrappableSubObjectTypes != null) {
            this.m_proxySuperClassMap = new HashMap();
            Class connectorProxyClassType = this.m_acm.getProxySuperClassType();
            Iterator iterator = wrappableSubObjectTypes.iterator();
            while (iterator.hasNext()) {
                this.m_proxySuperClassMap.put(iterator.next(), connectorProxyClassType);
            }
        }
    }

    static {
        m_defaultWrappableObjectTypes.add(Connection.class);
        m_defaultWrappableObjectTypes.add(Interaction.class);
    }
}

