/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.deployment;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.deployment.AnnotationParsingMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class AnnotationParsingMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.deployment.annotation", AnnotationParsingMessageBundle.class.getName());

    public static void fineBeginParsingAnnotations(String moduleName) {
        if (AnnotationParsingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE DEP-01001", new Object[]{moduleName});
        }
    }

    public static void finestInspectingClass(String clsName) {
        if (AnnotationParsingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE DEP-01002", new Object[]{clsName});
        }
    }

    public static void finerFoundAnnotatedClass(String clsName) {
        if (AnnotationParsingMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE DEP-01003", new Object[]{clsName});
        }
    }

    public static void fineParsingAnnotatedClass(String clsName, String annot) {
        if (AnnotationParsingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE DEP-01004", new Object[]{clsName, annot});
        }
    }

    public static void fineParsingAnnotatedClass(String clsName) {
        if (AnnotationParsingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE DEP-01005", new Object[]{clsName});
        }
    }

    public static void finestParsingClassLevelAnnotation(String annotName) {
        if (AnnotationParsingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE DEP-01006", new Object[]{annotName});
        }
    }

    public static void finestParsingFieldLevelAnnotation(String annotName, String field) {
        if (AnnotationParsingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE DEP-01007", new Object[]{annotName, field});
        }
    }

    public static void finestParsingMethodLevelAnnotation(String annotName, String method) {
        if (AnnotationParsingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE DEP-01008", new Object[]{annotName, method});
        }
    }

    public static void infoIgnoredAnnotationAttribute(String attribute, String annotation, String declaringClass) {
        if (AnnotationParsingMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE DEP-01009", new Object[]{attribute, annotation, declaringClass});
        }
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

