/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.jndi;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import oracle.j2ee.jndi.JNDIBinding;
import oracle.j2ee.jndi.JNDITreeParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JNDITreeParserImpl
implements JNDITreeParser {
    private static final String CONTEXT_CLASS_NAME = "javax.naming.Context";
    private static final String JDBC_DATA_TYPE = "jdbc";
    private static final String JMS_DATA_TYPE = "jms";
    private static final String MSG_EXCEPTION_IN_INIT = "Exception encountered during initialization of JNDITreeParser";
    private static final Logger m_logger = Logger.getLogger("oracle.j2ee.util", null);
    private String m_xmlBindings = null;
    private DocumentBuilder m_docBuilder = null;
    private HashMap m_mapOfApplicationNamesToBindings = new HashMap();

    protected JNDITreeParserImpl(DocumentBuilder builder) {
        this.m_docBuilder = builder;
    }

    public boolean init(String xmlBindings) {
        boolean result = false;
        this.m_xmlBindings = xmlBindings;
        InputSource inputSource = new InputSource(new StringReader(this.m_xmlBindings));
        try {
            Document document = this.m_docBuilder.parse(inputSource);
            this.buildObjectModelFromDocument(document);
            result = true;
        }
        catch (SAXException e) {
            m_logger.log(Level.WARNING, MSG_EXCEPTION_IN_INIT, e);
            result = false;
        }
        catch (IOException e) {
            m_logger.log(Level.WARNING, MSG_EXCEPTION_IN_INIT, e);
            result = false;
        }
        return result;
    }

    public Set getAllApplicationNames() {
        this.verifyParserState();
        Set unmodifiableSet = Collections.unmodifiableSet(this.m_mapOfApplicationNamesToBindings.keySet());
        return unmodifiableSet;
    }

    public Collection getBindings(String applicationName) {
        this.verifyParserState();
        if (this.m_mapOfApplicationNamesToBindings.containsKey(applicationName)) {
            List unmodifiableList = Collections.unmodifiableList((List)this.m_mapOfApplicationNamesToBindings.get(applicationName));
            return unmodifiableList;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection queryOnType(String applicationName, String typeName) {
        this.verifyParserState();
        LinkedList listOfBindings = new LinkedList();
        Collection applicationBindings = this.getBindings(applicationName);
        this.recursiveQueryOnType(applicationBindings, typeName, listOfBindings, "");
        return Collections.unmodifiableList(listOfBindings);
    }

    public Collection queryDataSources(String applicationName) {
        this.verifyParserState();
        return this.queryApplicationForType(applicationName, JDBC_DATA_TYPE);
    }

    public Collection queryJMSResources(String applicationName) {
        this.verifyParserState();
        return this.queryApplicationForType(applicationName, JMS_DATA_TYPE);
    }

    public boolean isBindingPresent(String bindingName) {
        this.verifyParserState();
        boolean boolToReturn = false;
        Set setOfApplicationNames = this.getAllApplicationNames();
        Iterator iterator = setOfApplicationNames.iterator();
        while (iterator.hasNext()) {
            String appName = (String)iterator.next();
            if (!this.isBindingPresent(appName, bindingName)) continue;
            boolToReturn = true;
            break;
        }
        return boolToReturn;
    }

    public boolean isBindingPresent(String applicationName, String bindingName) {
        this.verifyParserState();
        boolean boolToReturn = false;
        Collection bindings = this.getBindings(applicationName);
        boolToReturn = this.recursiveSearchForBinding(bindingName, bindings);
        return boolToReturn;
    }

    private void verifyParserState() {
        if (this.m_xmlBindings == null || this.m_mapOfApplicationNamesToBindings.size() == 0) {
            throw new IllegalStateException("This method cannot be called before init()");
        }
    }

    private void recursiveQueryOnType(Collection applicationBindings, String typeName, List listOfBindings, String path) {
        Iterator iterator = applicationBindings.iterator();
        while (iterator.hasNext()) {
            JNDIBinding binding = (JNDIBinding)iterator.next();
            String fullPathToBinding = path.length() == 0 ? binding.getName() : path + "/" + binding.getName();
            if (binding.getType().equals(typeName)) {
                listOfBindings.add(fullPathToBinding);
            }
            if (!binding.getType().equals(CONTEXT_CLASS_NAME)) continue;
            this.recursiveQueryOnType(binding.getSubBindings(), typeName, listOfBindings, fullPathToBinding);
        }
    }

    private boolean recursiveSearchForBinding(String bindingName, Collection bindings) {
        int indexOfSlash = bindingName.indexOf("/");
        if (indexOfSlash == -1) {
            return this.searchForBinding(bindingName, bindings);
        }
        String contextName = bindingName.substring(0, indexOfSlash);
        String restOfName = bindingName.substring(indexOfSlash + 1);
        Iterator iterator = bindings.iterator();
        while (iterator.hasNext()) {
            JNDIBinding binding = (JNDIBinding)iterator.next();
            if (!binding.getName().equals(contextName)) continue;
            return this.recursiveSearchForBinding(restOfName, binding.getSubBindings());
        }
        return false;
    }

    private boolean searchForBinding(String bindingName, Collection bindings) {
        boolean boolToReturn = false;
        Iterator iterator = bindings.iterator();
        while (iterator.hasNext()) {
            JNDIBinding binding = (JNDIBinding)iterator.next();
            if (!binding.getName().equals(bindingName)) continue;
            boolToReturn = true;
            break;
        }
        return boolToReturn;
    }

    private void buildObjectModelFromDocument(Document document) {
        Element rootElement = document.getDocumentElement();
        NodeList listOfApplications = rootElement.getElementsByTagName("application");
        for (int i = 0; i < listOfApplications.getLength(); ++i) {
            Element element = (Element)listOfApplications.item(i);
            this.parseJNDIBindings(element);
        }
    }

    private void parseJNDIBindings(Element applicationElement) {
        LinkedList<JNDIBinding> listOfBindings = new LinkedList<JNDIBinding>();
        NodeList bindings = applicationElement.getElementsByTagName("jndi-binding");
        for (int i = 0; i < bindings.getLength(); ++i) {
            Element binding = (Element)bindings.item(i);
            if (!binding.getParentNode().equals(applicationElement)) continue;
            JNDIBinding newBinding = this.buildRecursiveBinding(binding);
            listOfBindings.add(newBinding);
        }
        this.m_mapOfApplicationNamesToBindings.put(applicationElement.getAttribute("name"), listOfBindings);
    }

    private JNDIBinding buildRecursiveBinding(Element binding) {
        JNDIBindingImpl newBinding;
        String name = binding.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
        String type = binding.getElementsByTagName("class-name").item(0).getFirstChild().getNodeValue();
        String objectInfo = null;
        if (!type.equals(CONTEXT_CLASS_NAME)) {
            objectInfo = binding.getElementsByTagName("object-info").item(0).getFirstChild().getNodeValue();
        }
        if ((newBinding = new JNDIBindingImpl(name, type, objectInfo)).getType().equals(CONTEXT_CLASS_NAME)) {
            NodeList listOfBindings = binding.getElementsByTagName("jndi-binding");
            for (int i = 0; i < listOfBindings.getLength(); ++i) {
                Element subNode = (Element)listOfBindings.item(i);
                if (!subNode.getParentNode().equals(binding)) continue;
                JNDIBinding subBinding = this.buildRecursiveBinding(subNode);
                newBinding.addBinding(subBinding);
            }
        }
        return newBinding;
    }

    private Collection queryApplicationForType(String applicationName, String dataType) {
        Collection bindingsToReturn = new LinkedList();
        Collection applicationBindings = this.getBindings(applicationName);
        if (applicationBindings != null) {
            Iterator iterator = applicationBindings.iterator();
            boolean foundDataSourceContext = false;
            while (iterator.hasNext() && !foundDataSourceContext) {
                JNDIBinding binding = (JNDIBinding)iterator.next();
                if (!binding.getName().equals(dataType)) continue;
                bindingsToReturn = binding.getSubBindings();
                foundDataSourceContext = true;
            }
        }
        return Collections.unmodifiableCollection(bindingsToReturn);
    }

    private static class JNDIBindingImpl
    implements JNDIBinding {
        private String m_name = null;
        private String m_type = null;
        private String m_objectInfo = null;
        private Collection m_bindings = new LinkedList();

        private JNDIBindingImpl(String name, String type, String objectInfo) {
            this.m_name = name;
            this.m_type = type;
            this.m_objectInfo = objectInfo;
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_type;
        }

        public String getObjectInfo() {
            return this.m_objectInfo;
        }

        public Collection getSubBindings() {
            return this.m_bindings;
        }

        private void addBinding(JNDIBinding subBinding) {
            this.m_bindings.add(subBinding);
        }
    }
}

