/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.transaction;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionManagerAdmin;
import com.evermind.util.DBProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.XAState;
import oracle.j2ee.transaction.TransactionMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.jdbc.xa.OracleXAException;

public class TransactionMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.transaction", TransactionMessageBundle.class.getName());
    private static Logger m_loggerStackTrace = Logger.getLogger("oracle.j2ee.transaction.exceptions", TransactionMessageBundle.class.getName());
    static boolean m_isDescriptionAndActionDisplayed = false;

    private static String logAndReturnMessage(Level level, String key, Object[] params) {
        if (m_logger.isLoggable(level)) {
            m_logger.log(level, key, params);
        }
        return TransactionMessages.getStringForKeyAndParams(key, params);
    }

    public static String getStringForKeyAndParams(String key, Object[] params) {
        return MessageFormat.format(m_logger.getResourceBundle().getString(key), params);
    }

    public static String logAndReturnMessage(Level level, String key, String param, String param2) {
        return TransactionMessages.logAndReturnMessage(level, key, new Object[]{param, param2});
    }

    public static String logAndReturnMessage(Level level, String key, String param) {
        return TransactionMessages.logAndReturnMessage(level, key, new Object[]{param});
    }

    public static String logAndReturnMessage(Level level, String key) {
        return TransactionMessages.logAndReturnMessage(level, key, new Object[0]);
    }

    public static void fineExitingBeginMethodWithTx(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00001", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void warningBeginCouldNotStartTx() {
        m_logger.log(Level.WARNING, "J2EE JTA-00002", Thread.currentThread().getName());
        TransactionMessages.displayDescriptionAndActionForWarning("The transaction-manager.xml could not be created for some reason.", "See log for details explaining why the transation could not be created");
    }

    public static void infoAdminRollback(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE JTA-00005", tx.getTxInfo());
        }
    }

    public static void fineRollbackCalled(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00006", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineCommitCalled(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00007", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineSetTimeout(int timeout) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00008", new Object[]{timeout + "", Thread.currentThread().getName()});
        }
    }

    public static void fineSetRollbackOnly(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00009", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void severeUnableToStoreConfigChanges(String msg) {
        String string = TransactionMessages.logAndReturnMessage(Level.SEVERE, "J2EE JTA-00003", msg);
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(string, "The coordinator changes in transaction-manager.xml could not be persisted during closedown for some reason.", "See log for details explaining why the configuration could not be persisted.  Generally this will be the result of some logging IOException while waiting for in-doubt transactions to be completed");
    }

    public static void infoWaitingForIndoubtToComplete(int length, String lengthPlurality, String listOfIndoubts) {
        if (m_logger.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE JTA-00004", new Object[]{"" + length, lengthPlurality, listOfIndoubts});
        }
    }

    public static void fineResume(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00010", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineSuspend(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00011", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineInflowForget(Xid xid) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00012", new Object[]{xid, Thread.currentThread().getName()});
        }
    }

    public static void fineEnd(ApplicationServerTransaction tx, int flag) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00013", new Object[]{tx.getTxInfo(), flag + "", Thread.currentThread().getName()});
        }
    }

    public static void finePrepare(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00014", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineBeforeCompletion(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00015", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineInflowCommit(ApplicationServerTransaction tx, boolean onePhase) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00016", new Object[]{tx.getTxInfo(), onePhase + "", Thread.currentThread().getName()});
        }
    }

    public static void fineInflowRollback(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00017", new Object[]{tx.getTxInfo(), Thread.currentThread().getName()});
        }
    }

    public static void fineHeuristicRollback(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00018", tx.getTxInfo());
        }
    }

    public static void fineHeuristicCommit(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00019", tx.getTxInfo());
        }
    }

    public static String warningInvalidInflowedXid(String msg) {
        TransactionMessages.displayDescriptionAndActionForWarning("The Xid inflowed from a parent OC4J or external EIS is invalid in some way.", "Consult the OC4J and/or EIS logs for Xid  (eg for null transaction id, branch qualifier, or formatid) as appropriate");
        return TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00119", msg);
    }

    public static String getTraceMsgFreeResources(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Free Resources called for transaction: {0} on Thread: {1}", tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgGetTransaction(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            String txInfo = tx == null ? null : tx.getTxInfo();
            msg = MessageFormat.format("getTransaction returning transaction: {0} on Thread: {1}", txInfo, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgGetTransaction(Xid xid, ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            String txInfo = tx == null ? null : tx.getTxInfo();
            msg = MessageFormat.format("getTransaction returning Transaction: {0} for Xid: {1} on Thread: {2}", txInfo, xid, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgCleanupForProtocolError(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("cleanupForProtocolError called for transaction: {0} on Thread: {1}", tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgCreateCoordinator(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Creating coordinator for transaction: {0} on Thread: {1}", tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgInfectThread(Xid xid, int timeout, Synchronization sync) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("infectThread called with Xid: {0}, timeout: {1}, synchronization: {2} on Thread: {3}", xid.getGlobalTransactionId() == null ? null : xid, timeout + "", sync, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgImportTransaction(Xid xid, int timeout, Synchronization sync, ParentReference ref) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("importTransaction called with Xid: {0}, timeout: {1}, synchronization: {2}, parent reference: {3} on Thread: {4}", xid.getGlobalTransactionId() == null ? null : xid, timeout + "", sync, ref, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgCreateSubTransaction(ApplicationServerTransaction tx, int timeout, Synchronization sync, ParentReference ref) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Created subordinate transaction: {0}, timeout: {1}, synchronization: {2}, parent reference: {3} on Thread: {4}", tx.getTxInfo(), timeout + "", sync, ref, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgMatchedInflowedTransaction(Xid xid, ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Matched inflowed xid to transaction:  Xid: {0}, Transaction: {1}, on Thread: {2}", xid, tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgReturningMatchedTransaction(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            String txInfo = tx == null ? null : tx.getTxInfo();
            msg = MessageFormat.format("Returning Matched Subordinate Transaction: {0}, on Thread: {1}", txInfo, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgEndInfection(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Ending Thread Infection for Transaction: {0}, on Thread: {1}", tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgAddInDoubt(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Added in-doubt Transaction: {0}, on Thread: {1}", tx.getTxInfo(), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgForget(GlobalTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("Forget called on Transaction: {0}, on Thread: {1}", tx, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgRecover(int flag, ArrayList xids) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            StringBuffer xidString = new StringBuffer();
            for (int i = 0; i < xids.size(); ++i) {
                xidString.append("--");
                xidString.append(xids.get(i).toString());
                xidString.append("--");
            }
            msg = MessageFormat.format("Recover called on transaction manager with flag: {0}.  Returning xids: {1}", flag + "", xidString.toString());
        }
        return msg;
    }

    public static String getTraceMsgAddUnrecoverableXid(Xid xid) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = "Adding unrecoverable Xid: " + xid;
        }
        return msg;
    }

    public static String getTraceMsgAddRecoveredTransaction(GlobalTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = "Adding transaction to recovery manager.  Transaction: " + tx.toString();
        }
        return msg;
    }

    public static String getTraceMsgProcessSendRequest(ApplicationServerTransaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("processSendRequest called with transaction scope: {0}, on Thread: {1}", tx, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgProcessReceiveRequest(Object ctx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            String context = ctx == null ? "null" : "not null";
            msg = MessageFormat.format("processReceiveRequest called: Transaction context is {0}, on Thread: {1}", context, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgProcessSendReply(Transaction tx) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("processSendReply called with transaction scope: {0}, on Thread: {1}", tx, Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgReturnContext(Object replyContext) {
        String msg = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            msg = MessageFormat.format("processSendReply returning tx context: {0}, on Thread: {1}", replyContext, Thread.currentThread().getName());
        }
        return msg;
    }

    public static void fineTxCreated(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00101", tx.getTxInfo());
        }
    }

    public static void fineAttemptToEnlistSinglePhaseResource(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00102", tx.getTxInfo());
        }
    }

    public static void fineAttemptToEnlistSinglePhaseResourceSuccessful(ApplicationServerTransaction tx) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00103", tx.getTxInfo());
        }
    }

    public static void warningEnlistResourceFailed(String msg, XAException rootException) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00104", new Object[]{msg, rootException == null ? "" : rootException.getMessage()});
        }
        if (m_logger.isLoggable(Level.FINER)) {
            msg = TransactionMessages.appendXAResourceInfo(rootException, msg);
            m_logger.log(Level.FINER, "J2EE JTA-00104", new Object[]{msg, rootException});
        } else if (m_loggerStackTrace.isLoggable(Level.FINER)) {
            msg = TransactionMessages.appendXAResourceInfo(rootException, msg);
        }
        m_loggerStackTrace.log(Level.FINER, "J2EE JTA-00104", new Object[]{msg, rootException});
        TransactionMessages.displayDescriptionAndActionForWarning("The XAResource could not be enlisted for some reason.", "See both transaction and resource logs for details explaining why the XAResource could not be enlisted");
    }

    private static String appendXAResourceInfo(XAException rootException, String msg) {
        Throwable t;
        if (rootException instanceof OracleXAException) {
            msg = msg + "\n OracleError = " + ((OracleXAException)rootException).getOracleError() + "\n OracleSQLError = " + ((OracleXAException)rootException).getOracleSQLError() + "\n XAError = " + ((OracleXAException)rootException).getXAError() + " : " + TransactionMessages.stringForErrorCode(((OracleXAException)rootException).getXAError());
        } else if (rootException != null && (t = rootException.getCause()) != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            msg = msg + "  caused by [\n" + baos.toString() + "] ";
        }
        return msg;
    }

    public static void fineRollingBack(ApplicationServerTransaction tx, String msg) {
        m_logger.log(Level.FINE, "J2EE JTA-00106", new Object[]{tx, msg});
    }

    public static void warningXAExceptionDuringEnd(Exception ex) {
        m_logger.log(Level.WARNING, "J2EE JTA-00111", ex);
        TransactionMessages.displayDescriptionAndActionForWarning("The XAResource could not be ended for some reason.", "See both transaction and resource logs for details explaining why the XAResource could not be ended");
    }

    public static String warningErrorInResourceDuringRollback(String msg) {
        String string = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00107", msg);
        TransactionMessages.displayDescriptionAndActionForWarning("The XAResource could not be rolledback for some reason.", "See both transaction and resource logs for details explaining why the XAResource could not be rolledback");
        return string;
    }

    public static String warningOperationCalledOnInactiveTransaction(ApplicationServerTransaction tx, String txState) {
        String msg = "";
        if (m_logger.isLoggable(Level.WARNING)) {
            msg = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00108", tx.getTxInfo(), txState);
        }
        TransactionMessages.displayDescriptionAndActionForWarning("The transaction was not in a active state when a transaction api call was made o nit.", "Search transaction logs for actions (such as administrative intervention) made on this transaction that may have taken it out of the active state");
        return msg;
    }

    public static String warningTransactionMarkedForRollback(String msg) {
        String string = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00109", msg);
        TransactionMessages.displayDescriptionAndActionForWarning("enlistResource or registerSynchronization was called on a transation set for rollback.", "Consult logs and application to determine what setRollbackOnly on the transaction whether it be timeout or application design");
        return string;
    }

    public static void fineForcingRollingbackDueTo(String msg) {
        m_logger.log(Level.FINE, "J2EE JTA-00110", msg);
    }

    public static void warningErrorRollingbackDueTo(String msg) {
        m_logger.log(Level.WARNING, "J2EE JTA-00112", msg);
        TransactionMessages.displayDescriptionAndActionForWarning("Error during rollback.", "Consult logs ");
    }

    public static void warningCouldNotReconstructTxFromStoreOnProto(String msg, Xid xid) {
        m_logger.log(Level.WARNING, "J2EE JTA-00113", new Object[]{msg, xid});
        TransactionMessages.displayDescriptionAndActionForWarning("Error during recovery of transaction which failed due to a protocol violation.", "Consult logs for issues occuring during the retrieval of the transaction record from the file or database logging store");
    }

    public static void fineSetTxState(ApplicationServerTransaction tx, String state) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00114", new Object[]{tx.getTxInfo(), state});
        }
    }

    public static void warningExceptionDuringAfterCompletionNotifications(Throwable throwable) {
        m_logger.log(Level.WARNING, "J2EE JTA-00115", new Object[]{throwable == null ? "" : throwable.getMessage()});
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JTA-00115", new Object[]{throwable});
        } else if (m_loggerStackTrace.isLoggable(Level.FINER)) {
            m_loggerStackTrace.log(Level.FINER, "J2EE JTA-00115", new Object[]{throwable});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error during afterCompletion call of one of the Synchronization objects registeredwith the transaction.", "Consult both the transaction related logs and the logs of the component(s) which own the registered Synchronizationobject(s) (for example EJB subsystem)");
    }

    public static void warningExceptionDuringProtocolErrorNotifications(Throwable throwable) {
        m_logger.log(Level.WARNING, "J2EE JTA-00121", new Object[]{throwable == null ? "" : throwable.getMessage()});
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JTA-00121", new Object[]{throwable});
        } else if (m_loggerStackTrace.isLoggable(Level.FINER)) {
            m_loggerStackTrace.log(Level.FINER, "J2EE JTA-00121", new Object[]{throwable});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error during protocol notifications which may lead to resources not being cleanedup.", "Consult both the transaction related logs and the logs of the component(s) which own the registered ProtocolErrorNotifications (Synchronization)object(s) (for example EJB subsystem)");
    }

    public static void fineDelistResourceModeIs(String msg) {
        m_logger.log(Level.FINE, "J2EE JTA-00116", msg);
    }

    public static void warningErrorInBeforeCompletion(String msg) {
        m_logger.log(Level.WARNING, "J2EE JTA-00117", msg);
        TransactionMessages.displayDescriptionAndActionForWarning("Error during beforeCompletion call of one of the Synchronization objects registeredwith the transaction.", "Consult both the transaction related logs and the logs of the component(s) which own the registered Synchronizationobject(s) (for example EJB subsystem)");
    }

    public static void warningRollbackDueToCoordinatorCreationExceptionFailed(Throwable throwable) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00118", new Object[]{throwable});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error during 2pc processing", "Consult logs for initialization errors such as improper configuration in transaction-manager.xml");
    }

    public static void fineEnlistResource(ApplicationServerTransaction tx, XAResource resource, XAResource unwrappedRersource, String factory, byte[] bqual) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00120", new Object[]{resource, unwrappedRersource, tx.getTxInfo(), bqual, factory, Thread.currentThread().getName()});
        }
    }

    public static void fineSetIsolationLevel(ApplicationServerTransaction tx, int isolationLevel) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00122", new Object[]{tx.getTxInfo(), TransactionMessages.stringForIsolationLevel(isolationLevel), Thread.currentThread().getName()});
        }
    }

    public static void configSettingTransactionTimeoutTo(long txTimeout) {
        m_logger.log(Level.CONFIG, "J2EE JTA-00301", "" + txTimeout);
    }

    public static void configNoTxTimeoutValueSpecified(long txTimeout) {
        m_logger.log(Level.CONFIG, "J2EE JTA-00302", "" + txTimeout);
    }

    public static void configInvalidTxTimeoutValueSpecified(long invalidTxTimeout, long txTimeout) {
        if (m_logger.isLoggable(Level.CONFIG)) {
            m_logger.log(Level.CONFIG, "J2EE JTA-00303", new Object[]{"" + invalidTxTimeout, "" + txTimeout});
        }
    }

    public static void configSettingMaxConcurrentTo(String maxConcurrent) {
        m_logger.log(Level.CONFIG, "J2EE JTA-00304", maxConcurrent);
    }

    public static void configValidGettingMaxConcurrent(String maxConcurrent) {
        m_logger.log(Level.CONFIG, "J2EE JTA-00305", maxConcurrent);
    }

    public static void configInvalidRetryCount(int invalidRetryCount, int existingRetryCount) {
        if (m_logger.isLoggable(Level.CONFIG)) {
            m_logger.log(Level.CONFIG, "J2EE JTA-00306", new Object[]{"" + invalidRetryCount, "" + existingRetryCount});
        }
    }

    public static void severeCoordinatoreCantProceed(Xid xid) {
        String string = TransactionMessages.logAndReturnMessage(Level.SEVERE, "J2EE JTA-00401", xid.toString());
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(string, "Error during two-phase commit processing", "Consult logs for XAException during two-phase completion, it is likely completionof branches was retried, but success was still not possible and that the transactionwill have been given to the recovery manager");
    }

    public static void warningCoordinatorAttemptingRB(Xid xid) {
        m_logger.log(Level.WARNING, "J2EE JTA-00402", xid.toString());
        TransactionMessages.displayDescriptionAndActionForWarning("Error during two-phase completion either during the prepare phase or while committing the first resource resulting in a rollback", "Consult logs for reason why failure occurred, for example an XAException");
    }

    public static void severeCouldNotFindRecoveryMgr(GlobalTransaction tx, Branch branch) {
        String string = TransactionMessages.logAndReturnMessage(Level.SEVERE, "J2EE JTA-00404", new Object[]{tx.toString(), branch.toString()});
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(string, "Error initialized or setting the recovery manager", "Consult server logs as well as transaction logs as there is likely a fatal issue requiring restart");
    }

    public static void warningCouldNotForgetBranch(Branch branch, GlobalTransaction tx) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00405", new Object[]{branch, tx});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error while forgetting branch that was heuristically completed", "Consult logs for issues regarding the XA forget call.  It is also possible the heuristic was forgotten outside of OC4J in which case this can be ignored");
    }

    public static void warningTPCExeptionDuringHandleTransferOfControlException(RMId rmid, TPCException tpce) {
        if (m_logger.isLoggable(Level.WARNING)) {
            String additionMessageInfo = rmid != null && rmid.getRMFactoryJndiLocation() != null && rmid.getRMFactoryJndiLocation().getJndiLocation() != null ? rmid.getRMFactoryJndiLocation().getJndiLocation() : "";
            TransactionMessages.warning("TPCException while acquiring resource " + additionMessageInfo + " " + tpce);
        }
    }

    public static void infoSendingRmfailToRM(GlobalTransaction tx, Branch branch) {
        if (m_logger.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE JTA-00406", new Object[]{tx.toString(), branch.toString()});
        }
    }

    public static String getTraceMsgInvokeResource(Logger logger, Level level, XAResource res, Xid xid, String mthd) {
        String msg = null;
        if (logger.isLoggable(level)) {
            msg = MessageFormat.format("Coordinator Invoking {0} on resource: {1} - Xid: {2} - Thread: {3}", mthd, res, NormalXid.toString(xid), Thread.currentThread().getName());
        }
        return msg;
    }

    public static String getTraceMsgResourceException(Logger logger, Level level, Branch branch, int action, XAException xae) {
        String msg = null;
        if (logger.isLoggable(level)) {
            msg = MessageFormat.format("Coordinator caught XAException thrown from resource during Action: {0}. Exception Msg: {1} - Error Code: {2} - Branch: {3} - Thread: {4}", action + "", xae.getMessage(), xae.errorCode + "", branch, Thread.currentThread().getName());
        }
        return msg;
    }

    public static void configNoLogPathSpecifiedUsingDefault(String defaultPath) {
        m_logger.log(Level.CONFIG, "J2EE JTA-00601", defaultPath);
    }

    public static void warningUnableToCloseInputForFile(File file, Xid xid) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00602", new Object[]{file, xid});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error in the file-based transaction logging store.", "Consult logs for file system issues.  Increase log level as necessary");
    }

    public static void warningUnableToProcessTxDueToIOEx(Exception ex) {
        m_logger.log(Level.WARNING, "J2EE JTA-00603", new Object[]{ex});
        TransactionMessages.displayDescriptionAndActionForWarning("Error in the file-based transaction logging store.", "Consult logs for file system issues.  Increase log level as necessary");
    }

    public static void fineEmptyOrCorruptFile(Exception ex) {
        m_logger.log(Level.FINE, "J2EE JTA-00604", new Object[]{ex});
    }

    public static void warningIgnoringUnexpectedFileInTxLogDir(File file) {
        m_logger.log(Level.WARNING, "J2EE JTA-00605", new Object[]{file.getAbsolutePath()});
        TransactionMessages.displayDescriptionAndActionForWarning("An unexpected file was encountered during processing of the file-base transaction logging store store.  This may well be expected depending on the file system and it's configuration, for example inthe case of mounted file systems", "Consult logs for file system issues.  Increase log level as necessary. Note the name of the file in the exception as it generally relates to a temp or mirror file of an actual file that exists and is processed normally");
    }

    public static void warningIOExceptionDuringArchival(IOException ex) {
        m_logger.log(Level.WARNING, "J2EE JTA-00607", new Object[]{ex});
        TransactionMessages.displayDescriptionAndActionForWarning("Error during archival of files.  File handles may not have been released correctly", "Consult logs  for file system issues.  Increase log level as necessary. Generally this will be followed by other issues such as degradation in performance and or exceeding the max open files of the file system process.");
    }

    public static void warningMaxInPoolExceeded(int maxInPool) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-0060", "" + maxInPool);
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error ", "Consult logs ");
    }

    public static String warningNonOracleXAResource(XAResource xares) {
        String string = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00701", xares.toString());
        TransactionMessages.displayDescriptionAndActionForWarning("Error in application as only OracleXAResources may be used in the in-db coordinator", "Consult logs and application transaction design for non-OracleXAResources or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        return string;
    }

    public static String warningNonXAResourceWrapper(XAResource xares) {
        String string = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00702", xares.toString());
        TransactionMessages.displayDescriptionAndActionForWarning("Error in application as only OracleXAResources may be used in the in-db coordinator", "Consult logs and application transaction design for non-OracleXAResources or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        return string;
    }

    public static String warningXAResourceIsNull() {
        String string = TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00703");
        TransactionMessages.displayDescriptionAndActionForWarning("Error in application or system as only nonNull OracleXAResources may be used in the in-db coordinator", "Consult logs and application transaction design for non-OracleXAResources or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        return string;
    }

    public static void fineDBLinkEquals(String dblink) {
        m_logger.log(Level.FINE, "J2EE JTA-00704", dblink);
    }

    public static String warningNoDSFoundForJNDI(String jndiLocation) {
        TransactionMessages.displayDescriptionAndActionForWarning("Error in in-db configuration as datasource specified as in-db coordinator is not bound in JNDI", "Consult transaction-manager.xml and data-sources.xml configuration and verify the datasource specified as the in-db coordinator is bound in JNDI correctly or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        return TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00705", jndiLocation);
    }

    public static String fineOracleTwoPhaseCommitDriverDataSourceEquals(Object ds) {
        return TransactionMessages.logAndReturnMessage(Level.FINE, "J2EE JTA-00706", ds.toString());
    }

    public static void fineAttemptingToCreateConnForJNDIAndUser(String jndi, String user) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE JTA-00707", new Object[]{jndi, user});
        }
    }

    public static String warningSQLExceptionDuringThinTwoPhase(int primaryError, int secondaryError) {
        TransactionMessages.displayDescriptionAndActionForWarning("Error during the two-phase processing the in the in-db coordinator's stored procedure", "Consult JDBC logs and increse log level as appropriate or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        return TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00708", new Object[]{"" + primaryError, "" + secondaryError});
    }

    public static void fineAddedResourceForDBLink(String dblink) {
        m_logger.log(Level.FINE, "J2EE JTA-00709", dblink);
    }

    public static void warningXAExceptionDuringRollbackCleanup(Exception xaex) {
        m_logger.log(Level.WARNING, "J2EE JTA-00710", new Object[]{xaex});
        TransactionMessages.displayDescriptionAndActionForWarning("Error occurred during the two-phase commit processing in the in-db coordinator and the resulting rollback cleanup failed as well.", "Consult logs particularly JDBC and database logs or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
    }

    public static void warningSQLExDuringInDBCoordCreation(Exception xaex) {
        m_logger.log(Level.WARNING, "J2EE JTA-00711", new Object[]{xaex});
        TransactionMessages.displayDescriptionAndActionForWarning("Error creating the connection or statements for two-phase processing in the in-db coordinator.", "Consult server logs or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
    }

    public static void warningXAExDuringWrapperCleanup(XAResource xares, Exception xaex) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00712", new Object[]{xares, xaex});
            TransactionMessages.displayDescriptionAndActionForWarning("Error during cleanup notifications after successful two-phase commit in in-db coordinator which may lead to OC4J resource issues.", "Consult logs or preferrably use the more performant middle-tier coordinator as the in-db coordinator is deprecated.");
        }
    }

    public static void fineDBLinkInArgs(String dblink) {
        m_logger.log(Level.FINE, "J2EE JTA-00713", dblink);
    }

    public static void fineXid(Xid xid) {
        m_logger.log(Level.FINE, "J2EE JTA-00714", xid);
    }

    public static void fineAddedIntoDBLinks(String dblink) {
        m_logger.log(Level.FINE, "J2EE JTA-00715", dblink);
    }

    public static void warningUnableToReconstructBranches(GlobalTransaction tx, Exception e) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00801", new Object[]{tx, e});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error constructing branch for recovery which may be a result of failed deployment of resources due to configuration, inadequeate priviledges, etc..", "Consult all resource logs.");
    }

    public static void warningUnableToResolveAddingBackToQueue(GlobalTransaction tx, Exception e) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JTA-00802", new Object[]{tx, e});
        }
        TransactionMessages.displayDescriptionAndActionForWarning("Error resolving recovering resource", "Consult logs for errors, unavailability, etc. of recovering resource");
    }

    public static void severeUnableToResolve(GlobalTransaction tx, Exception e) {
        String string = TransactionMessages.logAndReturnMessage(Level.SEVERE, "J2EE JTA-00803", new Object[]{tx, e});
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(string, "Error during recovery of this transaction.  This is a severe error as recovery will not be reattempted", "Consult logs for severity and increase log level as necessary");
    }

    public static void severeProtoAttemptingToResolve(GlobalTransaction tx, ProtocolError e) {
        String string = TransactionMessages.logAndReturnMessage(Level.SEVERE, "J2EE JTA-00804", new Object[]{tx, e});
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(string, "ProtocolError during processing", "Consult logs and check for any issue in participating resourcemanagers.  ");
    }

    public static String warningRecoveryScanFailed(String jndi, Exception xae) {
        TransactionMessages.displayDescriptionAndActionForWarning("Error during reovery scan usually caused by permission failure", "Consult logs and configuration for proper credentials");
        return TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00805", new Object[]{jndi, xae});
    }

    public static void fineNoAppropriateProtocolHandler() {
        m_logger.log(Level.FINE, "J2EE JTA-00806");
    }

    public static void warningXAException(int action, XAException xaexception, int errorcode, Branch branch, String thread) {
        TransactionMessages.logAndReturnMessage(Level.WARNING, "J2EE JTA-00901", new Object[]{XAState.actionToString(action), xaexception + TransactionMessages.appendXAResourceInfo(xaexception, xaexception.toString()), TransactionMessages.stringForErrorCode(errorcode), branch, thread});
    }

    public static void finer(String msg) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JTA-99999", msg);
        }
    }

    public static void config(String msg) {
        if (m_logger.isLoggable(Level.CONFIG)) {
            m_logger.log(Level.CONFIG, "J2EE JTA-99999", msg);
        }
    }

    public static void warning(String msg) {
        m_logger.log(Level.WARNING, "J2EE JTA-99999", msg);
    }

    public static void severe(String msg) {
        m_logger.log(Level.SEVERE, "J2EE JTA-99999", msg);
        TransactionMessages.displayDescriptionAndActionForSevereAndFireEvent(msg, "Severe Error", "Consult logs");
    }

    public static void severeNoAlert(String msg) {
        m_logger.log(Level.SEVERE, "J2EE JTA-99999", msg);
    }

    public static void finest(String msg) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE JTA-99999", msg);
        }
    }

    public static boolean isLevelFinest() {
        return m_logger.isLoggable(Level.FINEST);
    }

    public static String stringForIsolationLevel(int isolationLevel) {
        switch (isolationLevel) {
            case 0: {
                return "XA_RBROLTRANSACTION_NONELBACK";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "UNKNOWN";
    }

    public static String stringForErrorCode(int errorCode) {
        switch (errorCode) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 4: {
                return "XA_RETRY";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
        }
        return "UNKNOWN";
    }

    private static void displayDescriptionAndActionForWarning(String description, String action) {
        if (m_isDescriptionAndActionDisplayed) {
            m_logger.log(Level.FINER, "J2EE JTA-99999", "Description : " + description);
            m_logger.log(Level.FINER, "J2EE JTA-99999", "Action : " + action);
        }
    }

    private static void displayDescriptionAndActionForSevereAndFireEvent(String message, String description, String action) {
        if (m_isDescriptionAndActionDisplayed) {
            m_logger.log(Level.FINER, "J2EE JTA-99999", "Description : " + description);
            m_logger.log(Level.FINER, "J2EE JTA-99999", "Action : " + action);
        }
        try {
            ApplicationServer appServer = ApplicationServer.getInstance();
            ApplicationServerTransactionManager transactionManager = null;
            if (appServer != null) {
                transactionManager = (ApplicationServerTransactionManager)appServer.getTransactionManager();
            }
            if (appServer != null && transactionManager != null && transactionManager.isAdminAvailable()) {
                ApplicationServerTransactionManagerAdmin tmAdmin = new ApplicationServerTransactionManagerAdmin(transactionManager);
                tmAdmin.fireEvent("jtaSevereMessageEvent", 0L, message);
            } else {
                TransactionMessages.severeNoAlert("Unable to fire Severe Message Alert : " + message + " as transaction manager is not accessible");
            }
        }
        catch (MalformedObjectNameException throwable) {
            TransactionMessages.severeNoAlert("Unable to fire Severe Message Alert : " + message + " due to " + throwable);
        }
    }

    static {
        if (DBProperties.getTransactionDebug()) {
            m_logger.setLevel(Level.FINER);
        }
    }
}

