/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server.deployment.oc4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlUtil {
    private static final NodeList EMPTY_NODE_LIST = new EmptyNodeList();

    XmlUtil() {
    }

    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        return s.substring(0, i);
    }

    public static String getLocalPart(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public static String getAttributeOrNull(Element e, String name) {
        Attr a = e.getAttributeNode(name);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public static String getAttributeNSOrNull(Element e, String name, String nsURI) {
        Attr a = e.getAttributeNodeNS(nsURI, name);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public static boolean matchesTagNS(Element e, String tag, String nsURI) {
        return e.getLocalName().equals(tag) && e.getNamespaceURI().equals(nsURI);
    }

    public static boolean matchesTagNS(Element e, QName name) {
        return e.getLocalName().equals(name.getLocalPart()) && e.getNamespaceURI().equals(name.getNamespaceURI());
    }

    public static List parseTokenList(String tokenList) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(tokenList, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static String getTextForNode(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n instanceof Text) {
                sb.append(n.getNodeValue());
                continue;
            }
            if (n instanceof EntityReference) {
                String s = XmlUtil.getTextForNode(n);
                if (s == null) {
                    return null;
                }
                sb.append(s);
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    public static Node selectSingleNode(Element element, String xpath) {
        try {
            return ((XMLElement)element).selectSingleNode(xpath);
        }
        catch (XSLException e) {
            return null;
        }
    }

    public static NodeList selectNodes(Element element, String xpath) {
        try {
            return ((XMLElement)element).selectNodes(xpath);
        }
        catch (XSLException e) {
            return EMPTY_NODE_LIST;
        }
    }

    public static void print(Element element, String indent, PrintWriter printer) throws IOException {
        ((XMLElement)element).print(printer);
    }

    public static Element getFirstChildElement(Node parent) {
        Node node = null;
        if (parent != null) {
            for (node = parent.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
        }
        return (Element)node;
    }

    public static Element getNextSiblingElement(Element el) {
        Node node;
        for (node = el.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChildElementWithName(Element parent, String name) {
        Node node = null;
        if (parent != null) {
            for (node = parent.getFirstChild(); !(node == null || node.getNodeType() == 1 && name.equals(node.getNodeName())); node = node.getNextSibling()) {
            }
        }
        return (Element)node;
    }

    public static Element getNextSiblingElementWithName(Element sibling, String name) {
        Node node;
        for (node = sibling.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getLocalName().equals(name)); node = node.getNextSibling()) {
        }
        return node == null ? null : (Element)node;
    }

    public static final QName parseQName(String string) {
        QName qname = null;
        if (string != null) {
            string = string.trim();
            int namespaceBegin = string.indexOf(123);
            int namespaceEnd = string.lastIndexOf(125);
            String namespacePart = "";
            if (namespaceBegin == 0 && namespaceEnd > namespaceBegin) {
                namespacePart = string.substring(namespaceBegin + 1, namespaceEnd);
            }
            String localPart = "";
            if (namespaceEnd >= 0 && namespaceEnd + 1 < string.length()) {
                localPart = string.substring(namespaceEnd + 1);
            }
            qname = new QName(namespacePart, localPart);
        }
        return qname;
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        public Node item(int index) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    }
}

