/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageLocalizationHelper {
    private Locale locale_ = null;
    private ResourceBundle resourceBundle_ = null;

    public MessageLocalizationHelper(String resourceBundleLocation, Locale loc) {
        this.locale_ = loc;
        this.resourceBundle_ = ResourceBundle.getBundle(resourceBundleLocation, loc);
    }

    public MessageLocalizationHelper(ResourceBundle resourceBundle, Locale loc) {
        this.locale_ = loc;
        this.resourceBundle_ = resourceBundle;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public final String getLocalizedMessage(String name) {
        return this.resourceBundle_.getString(name);
    }

    public final String getLocalizedMessage(String name, String param) {
        String[] params = new String[]{param};
        return this.getLocalizedMessage(name, params);
    }

    public final String getLocalizedMessage(String name, String param1, String param2) {
        String[] params = new String[]{param1, param2};
        return this.getLocalizedMessage(name, params);
    }

    public final String getLocalizedMessage(String name, String param1, String param2, String param3) {
        String[] params = new String[]{param1, param2, param3};
        return this.getLocalizedMessage(name, params);
    }

    public final String getLocalizedMessage(String name, String[] params) {
        String message = this.resourceBundle_.getString(name);
        return MessageFormat.format(message, params);
    }
}

