/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.oc4j.admin.internal.OpmnCompOc4jGroupCallBack;
import oracle.oc4j.admin.internal.OpmnContentDescriptionHelper;
import oracle.oc4j.admin.internal.OpmnProcOc4jCallBack;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpmnXmlHelper {
    static String xmlns_ = null;
    static String[] envNames = new String[]{"id", "value", "append", "process-conversion"};
    static String[] envDescs = new String[4];
    static CompositeType compositeType = null;

    static void setXmlns(String value) {
        xmlns_ = value;
    }

    static String getXmlns() {
        return xmlns_;
    }

    static Locale getLocale() {
        return JMXStateFactory.getJMXState().getLocale();
    }

    static String getLocalizedOpmnDesc(String key) {
        return OpmnContentDescriptionHelper.getLocalizedDescription(key, OpmnXmlHelper.getLocale());
    }

    static String getLocalizedOpmnDesc(String key1, String key2) {
        return OpmnContentDescriptionHelper.getLocalizedDescription(key1, key2, OpmnXmlHelper.getLocale());
    }

    static String getLocalizedOpmnDesc(String key1, String key2, String key3) {
        return OpmnContentDescriptionHelper.getLocalizedDescription(key1, key2, key3, OpmnXmlHelper.getLocale());
    }

    static Element[] getChildElements(Element element, String tagName) {
        ArrayList<Node> elems = new ArrayList<Node>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals(tagName)) continue;
            elems.add(node);
        }
        Element[] result = new Element[elems.size()];
        elems.toArray(result);
        return result;
    }

    static Element[] getChildElements(Element element, String tagName, String attrName, String attrValue) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node;
            if (!(nodes.item(i) instanceof Element) || !(node = (Element)nodes.item(i)).getNodeName().equals(tagName) || !attrValue.equals(node.getAttribute(attrName))) continue;
            elems.add(node);
        }
        Element[] result = new Element[elems.size()];
        elems.toArray(result);
        return result;
    }

    static Element getChildElement(Element parent, String tagName, String attrName, String attrValue) {
        return OpmnXmlHelper.getChildElement(parent, tagName, attrName, attrValue, false, null);
    }

    static Element getChildElement(Element parent, String tagName, String attrName, String attrValue, boolean insert, String[] nodesAfter) {
        Element[] childElems = attrName == null || attrValue == null ? OpmnXmlHelper.getChildElements(parent, tagName) : OpmnXmlHelper.getChildElements(parent, tagName, attrName, attrValue);
        Element childElem = null;
        if (childElems.length > 0) {
            childElem = childElems[0];
        } else if (insert) {
            childElem = OpmnXmlHelper.insertChildElement(parent, tagName, attrName, attrValue, nodesAfter);
        }
        return childElem;
    }

    static Element insertChildElement(Element parent, String tagName, String attrName, String attrValue, String[] nodesAfter) {
        Element refElem;
        Element childElem = parent.getOwnerDocument().createElementNS(xmlns_, tagName);
        if (attrName != null && attrValue != null) {
            childElem.setAttribute(attrName, attrValue);
        }
        if ((refElem = OpmnXmlHelper.searchRefElement(parent, nodesAfter)) == null) {
            parent.appendChild(childElem);
        } else {
            parent.insertBefore(childElem, refElem);
        }
        return childElem;
    }

    static Element searchRefElement(Element parent, String[] nodesAfter) {
        if (nodesAfter == null || nodesAfter.length == 0) {
            return null;
        }
        Element result = null;
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            int idx = OpmnXmlHelper.searchStringArray(node.getNodeName(), nodesAfter);
            if (idx < 0) continue;
            result = node;
            break;
        }
        return result;
    }

    static String[] getNodesAfter(String[] allnodes, int idx, String extra) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = idx + 1; i < allnodes.length; ++i) {
            list.add(allnodes[i]);
        }
        if (extra != null) {
            list.add(extra);
        }
        return list.toArray(new String[list.size()]);
    }

    static Element getFirstChildElement(Element element, String tagName, boolean isMissingOk, String fileName) throws ConfigMBeanException {
        Element[] nodes = OpmnXmlHelper.getChildElements(element, tagName);
        if (nodes.length <= 0) {
            if (isMissingOk) {
                return null;
            }
            throw ConfigMBeanExceptionHelper.getException(22, tagName, fileName);
        }
        return nodes[0];
    }

    static Element[] getDescendantElements(Element parent, String tagName, String attrName, String attrValue) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nodes = parent.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getNodeName().equals(tagName) || !attrValue.equals(node.getAttribute(attrName))) continue;
            elems.add(node);
        }
        Element[] result = new Element[elems.size()];
        elems.toArray(result);
        return result;
    }

    static CompositeData getElementAttrs(Element element) {
        return OpmnXmlHelper.getElementAttrs(element, null);
    }

    static CompositeData getElementAttrs(Element element, String[] skipAttrs) {
        CompositeDataSupport result = null;
        String nodeName = element.getNodeName();
        NamedNodeMap attrs = element.getAttributes();
        if (attrs.getLength() <= 0) {
            return null;
        }
        if (skipAttrs != null && skipAttrs.length == 0) {
            skipAttrs = null;
        }
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList<String> itemDescs = new ArrayList<String>();
        ArrayList<SimpleType<String>> itemTypes = new ArrayList<SimpleType<String>>();
        ArrayList<String> itemValues = new ArrayList<String>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node item = attrs.item(i);
            String attrName = item.getNodeName();
            if (OpmnXmlHelper.searchStringArray(attrName, skipAttrs) >= 0) continue;
            itemNames.add(attrName);
            itemDescs.add(OpmnXmlHelper.getLocalizedOpmnDesc(nodeName + ".attr", attrName));
            itemTypes.add(SimpleType.STRING);
            itemValues.add(item.getNodeValue());
        }
        if (itemNames.size() <= 0) {
            return null;
        }
        String[] itemNameArr = new String[itemNames.size()];
        itemNames.toArray(itemNameArr);
        String[] itemDescArr = new String[itemDescs.size()];
        itemDescs.toArray(itemDescArr);
        OpenType[] itemTypeArr = new OpenType[itemTypes.size()];
        itemTypes.toArray(itemTypeArr);
        Object[] itemValueArr = new Object[itemValues.size()];
        itemValues.toArray(itemValueArr);
        try {
            CompositeType compositeType = new CompositeType(nodeName + ".AttrsType", OpmnXmlHelper.getLocalizedOpmnDesc("xmlnodeattrs"), itemNameArr, itemDescArr, itemTypeArr);
            result = new CompositeDataSupport(compositeType, itemNameArr, itemValueArr);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    static CompositeData getChildElementAttrs(Element element, String[] childTags) {
        CompositeDataSupport result = null;
        String elemName = element.getNodeName();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<CompositeData> dataList = new ArrayList<CompositeData>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String nodeName = node.getNodeName();
            if (OpmnXmlHelper.searchStringArray(nodeName, childTags) < 0) continue;
            CompositeData nodeAttrs = OpmnXmlHelper.getElementAttrs((Element)node);
            nameList.add(nodeName);
            dataList.add(nodeAttrs);
        }
        String[] itemNames = new String[nameList.size()];
        String[] itemDescs = new String[nameList.size()];
        OpenType[] itemTypes = new OpenType[nameList.size()];
        Object[] itemValues = new Object[nameList.size()];
        for (int i = 0; i < nameList.size(); ++i) {
            itemNames[i] = (String)nameList.get(i);
            itemDescs[i] = OpmnXmlHelper.getLocalizedOpmnDesc(elemName + ".node", itemNames[i]);
            itemValues[i] = dataList.get(i);
            itemTypes[i] = ((CompositeData)itemValues[i]).getCompositeType();
        }
        try {
            CompositeType compositeType = new CompositeType(elemName + ".SubNodesAttrsType", OpmnXmlHelper.getLocalizedOpmnDesc("xmlnodeattrs"), itemNames, itemDescs, itemTypes);
            result = new CompositeDataSupport(compositeType, itemNames, itemValues);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    static String getElementAttr(Element element, String attrName, String[] validAttrNames) throws ConfigMBeanException {
        String nodeName = element.getNodeName();
        int attrIdx = OpmnXmlHelper.validateAttrName(attrName, validAttrNames, nodeName);
        return element.getAttribute(attrName);
    }

    static void setElementAttr(Element element, String attrName, String attrValue, String[] validAttrNames, String[][] validAttrValues) throws ConfigMBeanException {
        String nodeName = element.getNodeName();
        int attrIdx = OpmnXmlHelper.validateAttrName(attrName, validAttrNames, nodeName);
        OpmnXmlHelper.validateAttrValue(attrValue, validAttrValues[attrIdx], attrName, nodeName);
        element.setAttribute(attrName, attrValue);
    }

    static void setElementAttrs(Element element, CompositeData data, String[] validAttrNames, String[][] validAttrValues) throws ConfigMBeanException {
        int i;
        String nodeName = element.getNodeName();
        CompositeType dataType = data.getCompositeType();
        Object[] nameObjs = dataType.keySet().toArray();
        String[] names = new String[nameObjs.length];
        String[] types = new String[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = nameObjs[i2].toString();
            types[i2] = dataType.getType(names[i2]).getClassName();
        }
        Object[] values = data.getAll(names);
        if (validAttrValues == null) {
            validAttrValues = new String[validAttrNames.length][];
        }
        for (i = 0; i < names.length; ++i) {
            int attrIdx = OpmnXmlHelper.validateAttrName(names[i], validAttrNames, nodeName);
            if (!types[i].startsWith("java.lang.")) {
                throw ConfigMBeanExceptionHelper.getException(14, types[i], OpmnXmlHelper.getLocale());
            }
            if (values[i] == null) continue;
            OpmnXmlHelper.validateAttrValue(values[i].toString(), validAttrValues[attrIdx], names[i], nodeName);
        }
        for (i = 0; i < names.length; ++i) {
            if (values[i] == null) {
                element.removeAttribute(names[i]);
                continue;
            }
            element.setAttribute(names[i], values[i].toString());
        }
    }

    static void removeElementAttr(Element element, String attrName, String[] validAttrNames) throws ConfigMBeanException {
        String nodeName = element.getNodeName();
        int attrIdx = OpmnXmlHelper.validateAttrName(attrName, validAttrNames, nodeName);
        element.removeAttribute(attrName);
    }

    static void removeSubElement(Element element, String subName, String[] validNames) throws ConfigMBeanException {
        int attrIdx = OpmnXmlHelper.validateNodeName(subName, validNames);
        Element[] nodes = OpmnXmlHelper.getChildElements(element, subName);
        for (int i = 0; i < nodes.length; ++i) {
            element.removeChild(nodes[i]);
        }
    }

    static CompositeData getParameters(Element element, String prefix) {
        Element moduleElem = OpmnXmlHelper.getChildElement(element, "module-data", null, null);
        if (moduleElem == null) {
            return null;
        }
        Element[] nodes = OpmnXmlHelper.getChildElements(moduleElem, "category");
        if (nodes.length <= 0) {
            return null;
        }
        String[] catNames = new String[nodes.length];
        String[] catDescs = new String[nodes.length];
        OpenType[] catTypes = new OpenType[nodes.length];
        Object[] catValues = new CompositeData[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            catNames[i] = nodes[i].getAttribute("id");
            catValues[i] = OpmnXmlHelper.getCategoryParameters(nodes[i], prefix);
            catTypes[i] = catValues[i].getCompositeType();
            catDescs[i] = OpmnXmlHelper.getLocalizedOpmnDesc(prefix, catNames[i]);
        }
        CompositeDataSupport result = null;
        try {
            CompositeType compositeType = new CompositeType("OpmnModuleParamType", OpmnXmlHelper.getLocalizedOpmnDesc("moduleparams"), catNames, catDescs, catTypes);
            result = new CompositeDataSupport(compositeType, catNames, catValues);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    static CompositeData getCategoryParameters(Element element, String prefix) {
        String cat = element.getAttribute("id");
        NodeList nodeList = element.getElementsByTagName("data");
        if (nodeList.getLength() <= 0) {
            return null;
        }
        String[] paramNames = new String[nodeList.getLength()];
        String[] paramDescs = new String[nodeList.getLength()];
        OpenType[] paramTypes = new OpenType[nodeList.getLength()];
        Object[] paramValues = new Object[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elem = (Element)nodeList.item(i);
            paramNames[i] = elem.getAttribute("id");
            paramValues[i] = elem.getAttribute("value");
            paramTypes[i] = SimpleType.STRING;
            paramDescs[i] = OpmnXmlHelper.getLocalizedOpmnDesc(prefix, cat, paramNames[i]);
        }
        CompositeDataSupport result = null;
        try {
            CompositeType compositeType = new CompositeType("OpmnModuleCatParamType", OpmnXmlHelper.getLocalizedOpmnDesc("moduleparams"), paramNames, paramDescs, paramTypes);
            result = new CompositeDataSupport(compositeType, paramNames, paramValues);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    static String getParameter(Element element, String category, String paramName, String[] validCats, String[][] validParamNames, String prefix) throws ConfigMBeanException {
        OpmnXmlHelper.validataParamCategoryAndName(category, paramName, validCats, validParamNames, prefix);
        Element moduleElem = OpmnXmlHelper.getChildElement(element, "module-data", null, null);
        if (moduleElem == null) {
            return null;
        }
        Element catElem = OpmnXmlHelper.getChildElement(moduleElem, "category", "id", category);
        if (catElem == null) {
            return null;
        }
        Element paramElem = OpmnXmlHelper.getChildElement(catElem, "data", "id", paramName);
        if (paramElem == null) {
            return null;
        }
        String result = paramElem.getAttribute("value").trim();
        return "".equals(result) ? null : result;
    }

    static void setParameter(Element element, String category, String paramName, String paramValue, String[] validCats, String[][] validParamNames, String prefix, String[] orderedSubTags) throws ConfigMBeanException {
        OpmnXmlHelper.validataParamCategoryAndName(category, paramName, validCats, validParamNames, prefix);
        if (!OpmnXmlHelper.validateXMLValue(paramValue)) {
            throw ConfigMBeanExceptionHelper.getException(19, (Object[])new String[]{paramValue, paramName, category, prefix}, OpmnXmlHelper.getLocale());
        }
        int idx = OpmnXmlHelper.searchStringArray("module-data", orderedSubTags);
        String[] nodesAfter = OpmnXmlHelper.getNodesAfter(orderedSubTags, idx, null);
        Element moduleElem = OpmnXmlHelper.getChildElement(element, "module-data", null, null, true, nodesAfter);
        Element catElem = OpmnXmlHelper.getChildElement(moduleElem, "category", "id", category, true, null);
        Element paramElem = OpmnXmlHelper.getChildElement(catElem, "data", "id", paramName, true, null);
        paramElem.setAttribute("value", paramValue);
    }

    static void removeParameter(Element element, String category, String paramName, String[] validCats, String[][] validParamNames, String prefix) throws ConfigMBeanException {
        OpmnXmlHelper.validataParamCategoryAndName(category, paramName, validCats, validParamNames, prefix);
        Element moduleElem = OpmnXmlHelper.getChildElement(element, "module-data", null, null);
        if (moduleElem == null) {
            return;
        }
        Element catElem = OpmnXmlHelper.getChildElement(moduleElem, "category", "id", category);
        if (catElem == null) {
            return;
        }
        Element paramElem = OpmnXmlHelper.getChildElement(catElem, "data", "id", paramName);
        if (paramElem == null) {
            return;
        }
        catElem.removeChild(paramElem);
        if (catElem.getChildNodes().getLength() == 0) {
            moduleElem.removeChild(catElem);
            if (moduleElem.getChildNodes().getLength() == 0) {
                element.removeChild(moduleElem);
            }
        }
    }

    private static void validataParamCategoryAndName(String category, String paramName, String[] validCats, String[][] validParamNames, String prefix) throws ConfigMBeanException {
        int catIdx = OpmnXmlHelper.validateParamCategory(category, validCats, prefix);
        OpmnXmlHelper.validateParamName(paramName, validParamNames != null && validParamNames.length > catIdx ? validParamNames[catIdx] : null, category, prefix);
    }

    private static int validateParamCategory(String category, String[] validCats, String prefix) throws ConfigMBeanException {
        if (validCats == null) {
            if (!OpmnXmlHelper.validateName(category)) {
                throw ConfigMBeanExceptionHelper.getException(17, category, prefix, OpmnXmlHelper.getLocale());
            }
            return Integer.MAX_VALUE;
        }
        int paramIdx = OpmnXmlHelper.searchStringArray(category, validCats);
        if (paramIdx < 0) {
            throw ConfigMBeanExceptionHelper.getException(17, category, prefix, OpmnXmlHelper.getLocale());
        }
        return paramIdx;
    }

    private static void validateParamName(String paramName, String[] validNames, String category, String prefix) throws ConfigMBeanException {
        if (validNames == null) {
            if (OpmnXmlHelper.validateName(paramName)) {
                return;
            }
            throw ConfigMBeanExceptionHelper.getException(18, (Object[])new String[]{paramName, category, prefix}, OpmnXmlHelper.getLocale());
        }
        int nameIdx = OpmnXmlHelper.searchStringArray(paramName, validNames);
        if (nameIdx < 0) {
            throw ConfigMBeanExceptionHelper.getException(18, (Object[])new String[]{paramName, category, prefix}, OpmnXmlHelper.getLocale());
        }
    }

    static CompositeData[] getEnvironments(Element element) {
        Element envElem = OpmnXmlHelper.getChildElement(element, "environment", null, null);
        if (envElem == null) {
            return null;
        }
        Element[] nodes = OpmnXmlHelper.getChildElements(envElem, "variable");
        if (nodes.length == 0) {
            return null;
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        for (int i = 0; i < nodes.length; ++i) {
            String id = nodes[i].getAttribute(envNames[0]);
            String value = nodes[i].getAttribute(envNames[1]);
            boolean append = "true".equals(nodes[i].getAttribute(envNames[2]));
            boolean conv = !"false".equals(nodes[i].getAttribute(envNames[3]));
            Object[] envData = (Object[])map.get(id);
            if (envData == null) {
                envData = new Object[]{id, new ArrayList(), new Boolean(append), new Boolean(conv)};
                map.put(id, envData);
            }
            ((ArrayList)envData[1]).add(value);
        }
        Object[] variables = map.values().toArray();
        CompositeData[] datas = new CompositeData[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            try {
                Object[] values = (Object[])variables[i];
                String[] varValues = new String[((ArrayList)values[1]).size()];
                values[1] = ((ArrayList)values[1]).toArray(varValues);
                datas[i] = new CompositeDataSupport(compositeType, envNames, values);
                continue;
            }
            catch (OpenDataException ode) {
                ode.printStackTrace();
            }
        }
        return datas;
    }

    static CompositeData getEnvironment(Element element, String envName) throws ConfigMBeanException {
        OpmnXmlHelper.validateIndentifier(envName);
        CompositeData[] vars = OpmnXmlHelper.getEnvironments(element);
        if (vars == null || vars.length == 0) {
            return null;
        }
        for (int i = 0; i < vars.length; ++i) {
            try {
                if (!envName.equals(vars[i].get("id"))) continue;
                return vars[i];
            }
            catch (InvalidKeyException ike) {
                ike.printStackTrace();
            }
        }
        return null;
    }

    static void validateIndentifier(String envName) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(envName)) {
            throw ConfigMBeanExceptionHelper.getException(12, envName, OpmnXmlHelper.getLocale());
        }
    }

    private static void validateEnvValues(String[] envValues) throws ConfigMBeanException {
        if (envValues == null || envValues.length <= 0) {
            throw ConfigMBeanExceptionHelper.getException(15, "null", OpmnXmlHelper.getLocale());
        }
        String problemValue = null;
        for (int i = 0; i < envValues.length; ++i) {
            if (OpmnXmlHelper.validateXMLValue(envValues[i])) continue;
            problemValue = envValues[i];
            break;
        }
        if (problemValue != null) {
            throw ConfigMBeanExceptionHelper.getException(15, problemValue, OpmnXmlHelper.getLocale());
        }
    }

    static void addEnvironemnt(Element element, String envName, String[] envValues, boolean append, boolean conversion, String[] orderedSubTags) throws ConfigMBeanException {
        OpmnXmlHelper.validateIndentifier(envName);
        OpmnXmlHelper.validateEnvValues(envValues);
        OpmnXmlHelper.removeEnvironment(element, envName);
        int idx = OpmnXmlHelper.searchStringArray("environment", orderedSubTags);
        String[] nodesAfter = OpmnXmlHelper.getNodesAfter(orderedSubTags, idx, null);
        Element envElem = OpmnXmlHelper.getChildElement(element, "environment", null, null, true, nodesAfter);
        Document doc = element.getOwnerDocument();
        for (int i = 0; i < envValues.length; ++i) {
            Element childElem = doc.createElementNS(xmlns_, "variable");
            childElem.setAttribute("id", envName);
            childElem.setAttribute("value", envValues[i]);
            if (i == 0) {
                childElem.setAttribute("append", Boolean.toString(append));
            } else {
                childElem.setAttribute("append", "true");
            }
            if (!conversion) {
                childElem.setAttribute("process-conversion", "false");
            }
            envElem.appendChild(childElem);
        }
    }

    static void appendEnvironement(Element element, String envName, String envValue, boolean append, boolean conversion, String[] orderedSubTags) throws ConfigMBeanException {
        OpmnXmlHelper.validateIndentifier(envName);
        OpmnXmlHelper.validateEnvValues(new String[]{envValue});
        int idx = OpmnXmlHelper.searchStringArray("environment", orderedSubTags);
        String[] nodesAfter = OpmnXmlHelper.getNodesAfter(orderedSubTags, idx, null);
        Element envElem = OpmnXmlHelper.getChildElement(element, "environment", null, null, true, nodesAfter);
        Element[] varElems = OpmnXmlHelper.getChildElements(envElem, "variable", "id", envName);
        Document doc = element.getOwnerDocument();
        Element childElem = doc.createElementNS(xmlns_, "variable");
        childElem.setAttribute("id", envName);
        childElem.setAttribute("value", envValue);
        if (varElems.length > 0) {
            childElem.setAttribute("append", "true");
            if ("false".equals(varElems[0].getAttribute("process-conversion"))) {
                childElem.setAttribute("process-conversion", "false");
            }
        } else {
            childElem.setAttribute("append", Boolean.toString(append));
            if (!conversion) {
                childElem.setAttribute("process-conversion", "false");
            }
        }
        envElem.appendChild(childElem);
    }

    static void removeEnvironment(Element element, String envName) throws ConfigMBeanException {
        OpmnXmlHelper.validateIndentifier(envName);
        Element envElem = OpmnXmlHelper.getChildElement(element, "environment", null, null);
        if (envElem == null) {
            return;
        }
        Element[] varElems = OpmnXmlHelper.getChildElements(envElem, "variable", "id", envName);
        for (int i = 0; i < varElems.length; ++i) {
            envElem.removeChild(varElems[i]);
        }
        if (envElem.getChildNodes().getLength() == 0) {
            element.removeChild(envElem);
        }
    }

    static int getTimeoutRetry(Element element, String key, String attrName, int defValue) {
        Element[] elems = OpmnXmlHelper.getChildElements(element, key);
        if (elems.length == 0) {
            return defValue;
        }
        String timeoutStr = elems[0].getAttribute(attrName);
        try {
            return Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    static void setTimeoutRetry(Element element, String key, String attrName, int value, int minValue, String[] orderedTags) throws ConfigMBeanException {
        if (value < minValue) {
            throw ConfigMBeanExceptionHelper.getException(15, Integer.toString(value), OpmnXmlHelper.getLocale());
        }
        int idx = OpmnXmlHelper.validateNodeName(key, orderedTags);
        String[] nodesAfter = OpmnXmlHelper.getNodesAfter(orderedTags, idx, null);
        Element elem = OpmnXmlHelper.getChildElement(element, key, null, null, true, nodesAfter);
        elem.setAttribute(attrName, Integer.toString(value));
    }

    static CompositeData getPortInfos(Element element) {
        Element[] elems = OpmnXmlHelper.getChildElements(element, "port");
        if (elems.length <= 0) {
            return null;
        }
        String[] portNames = new String[elems.length];
        String[] portDescs = new String[elems.length];
        OpenType[] portTypes = new OpenType[elems.length];
        Object[] portValues = new CompositeData[elems.length];
        String[] skipAttrs = new String[]{"id"};
        for (int i = 0; i < elems.length; ++i) {
            portNames[i] = elems[i].getAttribute("id");
            portValues[i] = OpmnXmlHelper.getElementAttrs(elems[i], skipAttrs);
            portTypes[i] = portValues[i].getCompositeType();
            portDescs[i] = OpmnXmlHelper.getLocalizedOpmnDesc("port", portNames[i]);
        }
        CompositeDataSupport result = null;
        try {
            CompositeType compositeType = new CompositeType("PortInfoType", OpmnXmlHelper.getLocalizedOpmnDesc("portinfo"), portNames, portDescs, portTypes);
            result = new CompositeDataSupport(compositeType, portNames, portValues);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    static OpmnProcOc4jCallBack addVanillaOc4jElement(OpmnCompOc4jGroupCallBack group, String oc4jName) throws ConfigMBeanException {
        Element parent = group.getXmlElement();
        Element oc4jElem = parent.getOwnerDocument().createElementNS(xmlns_, "process-type");
        oc4jElem.setAttribute("id", oc4jName);
        oc4jElem.setAttribute("module-id", "OC4J");
        oc4jElem.setAttribute("status", "enabled");
        OpmnProcOc4jCallBack oc4j = new OpmnProcOc4jCallBack(group, oc4jElem);
        oc4j.setParameter("start-parameters", "java-options", "-server -Djava.security.policy=$ORACLE_HOME/j2ee/home/config/java2.policy -Djava.awt.headless=true -Dhttp.webdir.enable=false");
        oc4j.setParameter("stop-parameters", "java-options", "-Djava.security.policy=$ORACLE_HOME/j2ee/home/config/java2.policy -Djava.awt.headless=true -Dhttp.webdir.enable=false");
        oc4j.setStartTimeout(600);
        oc4j.setStartRetry(2);
        oc4j.setStopTimeout(120);
        oc4j.setRestartTimeout(720);
        oc4j.setRestartRetry(2);
        oc4j.setPort("default-web-site", "12501-12600", "ajp");
        oc4j.setPort("rmi", "12401-12500", null);
        oc4j.setPort("rmis", "12701-12800", null);
        oc4j.setPort("jms", "12601-12700", null);
        oc4j.setProcessSet(group.getname(), 1);
        parent.appendChild(oc4jElem);
        return oc4j;
    }

    static OpmnProcOc4jCallBack addTemplateOc4jElement(OpmnCompOc4jGroupCallBack group, String oc4jName, String fileName) throws ConfigMBeanException {
        Element parent = group.getXmlElement();
        XMLDocument srcDoc = OpmnXmlHelper.getTemplateHomeOpmn(group, fileName);
        NodeList list = srcDoc.getElementsByTagName("process-type");
        Element oc4jHomeElem = (Element)list.item(0);
        oc4jHomeElem.setAttribute("id", oc4jName);
        XMLElement importedElem = (XMLElement)parent.getOwnerDocument().importNode(oc4jHomeElem, true);
        OpmnProcOc4jCallBack oc4j = new OpmnProcOc4jCallBack(group, (Element)importedElem);
        parent.appendChild((Node)importedElem);
        return oc4j;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static XMLDocument getTemplateHomeOpmn(OpmnCompOc4jGroupCallBack group, String fileName) throws ConfigMBeanException {
        FileInputStream fileInput = null;
        XMLDocument srcDoc = null;
        try {
            try {
                fileInput = new FileInputStream(fileName);
                group.getParent().parser_.parse((InputStream)fileInput);
                srcDoc = group.getParent().parser_.getDocument();
            }
            catch (Exception e) {
                throw new ConfigMBeanException(e);
            }
            Object var6_4 = null;
            if (fileInput == null) return srcDoc;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInput == null) throw throwable;
            try {
                fileInput.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fileInput.close();
        return srcDoc;
    }

    static OpmnProcOc4jCallBack cloneOc4jHomeElement(OpmnCompOc4jGroupCallBack group, String oc4jName) throws ConfigMBeanException {
        Element parent = group.getXmlElement();
        Element oc4jHomeElem = OpmnXmlHelper.getOc4jElement(parent, "home");
        if (oc4jHomeElem == null) {
            throw ConfigMBeanExceptionHelper.getException(56, oc4jName);
        }
        Element oc4jElem = (Element)oc4jHomeElem.cloneNode(true);
        oc4jElem.setAttribute("id", oc4jName);
        parent.appendChild(oc4jElem);
        OpmnProcOc4jCallBack oc4j = new OpmnProcOc4jCallBack(group, oc4jElem);
        return oc4j;
    }

    static OpmnProcOc4jCallBack cloneDefaultOc4jElement(OpmnCompOc4jGroupCallBack group, String oc4jName) throws ConfigMBeanException {
        Element parent = group.getXmlElement();
        Element oc4jHomeElem = OpmnXmlHelper.getOc4jElement(parent, "default_oc4j");
        if (oc4jHomeElem == null) {
            throw ConfigMBeanExceptionHelper.getException(56, oc4jName);
        }
        Element oc4jElem = (Element)oc4jHomeElem.cloneNode(true);
        oc4jElem.setAttribute("id", oc4jName);
        parent.appendChild(oc4jElem);
        OpmnProcOc4jCallBack oc4j = new OpmnProcOc4jCallBack(group, oc4jElem);
        return oc4j;
    }

    static Element getOc4jElement(Element groupElement, String oc4jName) {
        Element iasnode = (Element)groupElement.getParentNode();
        Element[] oc4jElems = OpmnXmlHelper.getDescendantElements(iasnode, "process-type", "module-id", "OC4J");
        Element oc4jElem = null;
        for (int i = 0; i < oc4jElems.length; ++i) {
            String oc4jId = oc4jElems[i].getAttribute("id");
            if (!oc4jId.equals(oc4jName)) continue;
            oc4jElem = oc4jElems[i];
            break;
        }
        return oc4jElem;
    }

    static boolean validateName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$' && c < '\u007f' && c >= ' ' || c == '-') continue;
            result = false;
            break;
        }
        return result;
    }

    static int validateAttrName(String attrName, String[] validNames, String nodeName) throws ConfigMBeanException {
        int attrIdx = OpmnXmlHelper.searchStringArray(attrName, validNames);
        if (attrIdx < 0) {
            throw ConfigMBeanExceptionHelper.getException(23, attrName, nodeName, OpmnXmlHelper.getLocale());
        }
        return attrIdx;
    }

    static boolean validateXMLValue(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '<' && c != '>') continue;
            return false;
        }
        return true;
    }

    static void validateAttrValue(String attrValue, String[] validValues, String attrName, String nodeName) throws ConfigMBeanException {
        if (validValues == null) {
            if (!OpmnXmlHelper.validateXMLValue(attrValue)) {
                throw ConfigMBeanExceptionHelper.getException(24, (Object[])new String[]{attrValue, attrName, nodeName}, OpmnXmlHelper.getLocale());
            }
            return;
        }
        int valueIdx = OpmnXmlHelper.searchStringArray(attrValue, validValues);
        if (valueIdx < 0) {
            throw ConfigMBeanExceptionHelper.getException(24, (Object[])new String[]{attrValue, attrName, nodeName}, OpmnXmlHelper.getLocale());
        }
    }

    static int validateNodeName(String name, String[] validNames) throws ConfigMBeanException {
        int subNodeIdx = OpmnXmlHelper.searchStringArray(name, validNames);
        if (subNodeIdx < 0) {
            throw ConfigMBeanExceptionHelper.getException(13, name, OpmnXmlHelper.toString(validNames), OpmnXmlHelper.getLocale());
        }
        return subNodeIdx;
    }

    static int searchStringArray(String key, String[] validKeys) {
        if (key == null || key.length() == 0 || validKeys == null) {
            return -1;
        }
        if (validKeys.length == 0) {
            return 0;
        }
        for (int i = 0; i < validKeys.length; ++i) {
            if (!key.equals(validKeys[i])) continue;
            return i;
        }
        return -1;
    }

    public static String toString(String[] strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            buf.append(", ").append(strs[i]);
        }
        return buf.toString();
    }

    static {
        String[] envNames = new String[]{"id", "value", "append", "process-conversion"};
        String[] envDescs = new String[4];
        for (int i = 0; i < 4; ++i) {
            envDescs[i] = OpmnXmlHelper.getLocalizedOpmnDesc("env", envNames[i]);
        }
        OpenType[] envTypes = new OpenType[4];
        try {
            envTypes[0] = SimpleType.STRING;
            envTypes[1] = new ArrayType(1, SimpleType.STRING);
            envTypes[2] = SimpleType.BOOLEAN;
            envTypes[3] = SimpleType.BOOLEAN;
            compositeType = new CompositeType("EnvVarType", OpmnXmlHelper.getLocalizedOpmnDesc("envvariable"), envNames, envDescs, envTypes);
        }
        catch (OpenDataException ode) {
            ode.printStackTrace();
        }
    }
}

