/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationServer;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.internal.WebApplicationBase;

public class WebApplicationBinder
extends WebApplicationBase {
    private static Logger logger_ = TraceLogger.getLogger(WebApplicationBinder.class);
    private static final String SHARED = "shared";
    private static final String LOAD_ON_STARTUP = "loadOnStartup";
    private static final String ACCESS_LOG = "accessLog";

    public void bindWebApp(String appName, String siteName) throws DeployerException {
        this.bindWebApp(appName, siteName, (HashMap)null);
    }

    public void bindWebApp(String appName, String siteName, HashMap optionalParams) throws DeployerException {
        Collection webApps = this.getWebApps(appName);
        if (webApps == null || webApps.isEmpty()) {
            return;
        }
        Iterator iterator = webApps.iterator();
        while (iterator.hasNext()) {
            WebModule mod = (WebModule)iterator.next();
            String webName = mod.getName();
            String root = mod.getContextRoot();
            boolean accessLog = mod.getAccessLog();
            if (optionalParams == null) {
                optionalParams = new HashMap<String, String>();
            }
            optionalParams.put(ACCESS_LOG, new Boolean(accessLog).toString());
            this.bindWebApp(appName, webName, siteName, root, optionalParams);
        }
    }

    public void bindWebApp(String appName, String webName, String siteName) throws DeployerException {
        Collection webApps = this.getWebApps(appName);
        if (webApps == null || webApps.isEmpty()) {
            return;
        }
        Iterator iterator = webApps.iterator();
        while (iterator.hasNext()) {
            WebModule mod = (WebModule)iterator.next();
            String name = mod.getName();
            boolean accessLog = mod.getAccessLog();
            HashMap<String, String> optionalParams = new HashMap<String, String>();
            optionalParams.put(ACCESS_LOG, new Boolean(accessLog).toString());
            if (!name.equals(webName)) continue;
            this.bindWebApp(appName, webName, siteName, mod.getContextRoot(), optionalParams);
            return;
        }
    }

    public void bindWebApp(String appName, String webName, String siteName, String root) throws DeployerException {
        this.bindWebApp(appName, webName, siteName, root, null);
    }

    public void bindWebApp(String appName, String webName, String siteName, String root, HashMap optionalParams) throws DeployerException {
        HttpSite site;
        Application application = this.getApplication(appName);
        HttpServer httpServer = ApplicationServer.getInstance().getHttpServer();
        if (httpServer == null) {
            throw new DeployerException("The Http server is unavailable to bind web applications.");
        }
        Notifier notifier = Notifier.getNotifier();
        if (notifier != null) {
            try {
                String[] params = new String[]{webName, appName, siteName, root};
                notifier.sendNotification("BINDING_WEBMODULE_TO_SITE", params);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            site = this.getSite(siteName, httpServer);
        }
        catch (Exception e) {
            throw new DeployerException("Site " + siteName + " is not found", e);
        }
        if (site == null) {
            String errMsg;
            block21: {
                errMsg = "Unknown site: " + siteName + "\n";
                errMsg = errMsg + "Active sites are:\n";
                try {
                    List sites = httpServer.getSites();
                    for (int i = 0; i < sites.size(); ++i) {
                        errMsg = errMsg + ((HttpSite)sites.get(i)).getName() + "\n";
                    }
                }
                catch (Exception e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block21;
                    logger_.log(Level.SEVERE, "Unable to get active sites: " + e.getMessage(), e);
                }
            }
            throw new DeployerException(errMsg);
        }
        try {
            ApplicationConfig _config;
            WebModule web;
            String rootCtx = root;
            if (rootCtx == null) {
                rootCtx = this.getContextRoot(appName, webName);
            }
            if (rootCtx == null || rootCtx.trim().equals("")) {
                rootCtx = "/";
            }
            if (!rootCtx.startsWith("/")) {
                rootCtx = "/" + rootCtx;
            }
            if (!rootCtx.equals("/") && rootCtx.endsWith("/")) {
                rootCtx = rootCtx.substring(0, rootCtx.length() - 1);
            }
            if ((web = (_config = application.getConfig()).getWebApplication(webName)) == null) {
                throw new DeployerException("Web module " + webName + " does not exist in application " + appName);
            }
            HttpApplicationReference reference = new HttpApplicationReference(appName, webName);
            reference.setRoot(rootCtx);
            reference.setPreload();
            if (optionalParams != null) {
                Iterator iterator = optionalParams.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String paramKey = (String)entry.getKey();
                    String paramValue = (String)entry.getValue();
                    if (paramKey.equals(SHARED)) {
                        reference.setShared("true".equalsIgnoreCase(paramValue));
                        continue;
                    }
                    if (paramKey.equals(LOAD_ON_STARTUP)) {
                        if (!"false".equalsIgnoreCase(paramValue)) continue;
                        reference.unsetPreload();
                        continue;
                    }
                    if (!paramKey.equals(ACCESS_LOG)) continue;
                    reference.setAccessLog("true".equalsIgnoreCase(paramValue));
                }
            }
            site.addHttpApplication(reference, rootCtx);
            HttpSiteConfig config = site.getConfig();
            config.addApplication(reference);
            config.store();
        }
        catch (Exception e) {
            DeployerException de = new DeployerException(e.getMessage());
            de.setStackTrace(e.getStackTrace());
            throw de;
        }
    }
}

