/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.model;

import com.evermind.server.ApplicationServer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class DefaultModelMBeanImpl
extends RequiredModelMBean {
    private ModelMBeanProvider tgt_ = null;
    private PersistentMBean persistenceTgt_ = null;
    private long listenerCount_;
    private MBeanServer mbeanServer_ = null;
    private static Map basicTypesClasses_ = null;
    private static final String resourceBundleLocation_ = "oracle.oc4j.admin.jmx.model.Messages";
    private static Logger logger_ = null;
    private MessageLocalizationHelper msgHelper_ = null;
    public static final int MBEAN_STOPSTART = 1;
    public static final int MBEAN_RESTART = 2;
    public static final int APPLICATION_STOPSTART = 3;
    public static final int APPLICATION_RESTART = 4;
    public static final int OC4J_RESTART = 5;
    private int mbeanLevelReStartRequired_ = -1;
    private ObjectName encompassingApplicationComponent_ = null;
    private ObjectName thisComponent_ = null;
    private Map operationsToCheckForRestart_ = null;
    private Map attributesToCheckForRestart_ = null;
    private Map oc4jRestartAttributeRuntimeValues_ = null;
    private Map applicationRestartAttributeRuntimeValues_ = null;
    private Map componentRestartAttributeRuntimeValues_ = null;
    private Set oc4jRestartOperationInvoked_ = null;
    private Set applicationRestartOperationInvoked_ = null;
    private Set componentRestartOperationInvoked_ = null;
    private NotificationListener applicationLevelListener_ = null;
    private NotificationFilter applicationLevelFilter_ = null;
    public static final int Never = 1;
    public static final int OnUnregister = 2;
    public static final int OnTimer = 3;
    public static final int NoMoreOftenThan = 4;
    public static final int OnUpdate = 5;
    public static final int Always = 6;
    private PersistenceMetaData mbeanLevelPersistence_ = null;
    private boolean requirePersitence_ = false;
    private boolean disablePersistenceTemporarily_ = false;
    private boolean dirtyFlag_ = false;
    private boolean onRegisterDirtyFlag_ = false;
    private long lastUpdated_ = 0L;
    private Map operationsToCheckForPersistence_ = null;
    private Map attributesToCheckForPersistence_ = null;
    private boolean registered_ = false;

    public DefaultModelMBeanImpl(ModelMBeanInfo info, ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException {
        super(DefaultModelMBeanImpl.checkDescriptor(info));
        logger_ = Logger.getLogger("oracle.j2ee.jmx", resourceBundleLocation_);
        if (logger_ == null) {
            logger_ = Logger.getAnonymousLogger();
        }
        this.msgHelper_ = new MessageLocalizationHelper(resourceBundleLocation_, Locale.getDefault());
        this.listenerCount_ = 0L;
        this.tgt_ = tgt;
        if (this.tgt_ instanceof PersistentMBean) {
            this.persistenceTgt_ = (PersistentMBean)((Object)this.tgt_);
        }
        this.tgt_.registerModelMBeanNotificationBroadcaster(this);
        this.introspectStateRequirements(info);
        if (this.mbeanLevelReStartRequired_ != -1 || this.attributesToCheckForRestart_ != null && !this.attributesToCheckForRestart_.isEmpty()) {
            this.oc4jRestartAttributeRuntimeValues_ = new HashMap();
            this.applicationRestartAttributeRuntimeValues_ = new HashMap();
            this.componentRestartAttributeRuntimeValues_ = new HashMap();
        }
        if (this.mbeanLevelReStartRequired_ != -1 || this.operationsToCheckForRestart_ != null && !this.operationsToCheckForRestart_.isEmpty()) {
            this.oc4jRestartOperationInvoked_ = new HashSet();
            this.applicationRestartOperationInvoked_ = new HashSet();
            this.componentRestartOperationInvoked_ = new HashSet();
        }
        try {
            this.setManagedResource(tgt, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public Object getAttribute(String attrName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            try {
                Class<?> cl = this.tgt_.getClass();
                Method m = cl.getMethod("get" + attrName, null);
                Object res = m.invoke((Object)this.tgt_, null);
                if (!ApplicationServer.DMS_GATE && "statisticsProvider".equals(attrName)) {
                    return Boolean.FALSE;
                }
                return res;
            }
            catch (NoSuchMethodException e) {
                if (this.isIs(attrName)) {
                    try {
                        Class<?> cl = this.tgt_.getClass();
                        Method m = cl.getMethod("is" + attrName, null);
                        return m.invoke((Object)this.tgt_, null);
                    }
                    catch (NoSuchMethodException ne) {
                        throw new AttributeNotFoundException("Missing is method for attribute: " + attrName + " in class: " + this.tgt_.getClass());
                    }
                }
                throw new AttributeNotFoundException("Missing getter method for attribute: " + attrName + " in class: " + this.tgt_.getClass());
            }
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, t.getMessage());
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t, t.getMessage());
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, t.getMessage());
            }
            throw new RuntimeMBeanException(null, "Throwable instance reported with message: " + t.getMessage());
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            throw new ReflectionException(e, e.getMessage());
        }
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object oldValue = null;
        try {
            oldValue = this.getAttribute(attr.getName());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Class<?> cl = this.tgt_.getClass();
            Class[] param = new Class[1];
            Object[] paramVal = new Object[]{attr.getValue()};
            MBeanAttributeInfo attrMetaData = this.getAttributeMetaData(attr.getName());
            String attrType = attrMetaData.getType();
            ClassLoader tgtLoader = this.tgt_.getClass().getClassLoader();
            param[0] = basicTypesClasses_.get(attrType) == null ? Class.forName(attrType, true, tgtLoader) : (Class)basicTypesClasses_.get(attrType);
            Method m = cl.getMethod("set" + attr.getName(), param);
            m.invoke((Object)this.tgt_, paramVal);
        }
        catch (NoSuchMethodException e) {
            throw new AttributeNotFoundException("Missing set method for attribute: " + attr.getName() + " in class: " + this.tgt_.getClass());
        }
        catch (InvocationTargetException e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, t.getMessage());
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t, t.getMessage());
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, t.getMessage());
            }
            throw new RuntimeMBeanException(null, "Throwable instance reported with message: " + t.getMessage());
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            throw new ReflectionException(e, e.getMessage());
        }
        if (!this.registered_) {
            return;
        }
        if (oldValue == null || !oldValue.equals(attr.getValue())) {
            this.sendAttributeChangeNotification(new Attribute(attr.getName(), oldValue), attr);
        }
        int attResPol = -1;
        Integer attrRestartPolicy = (Integer)this.attributesToCheckForRestart_.get(attr.getName());
        attResPol = attrRestartPolicy != null ? attrRestartPolicy : this.mbeanLevelReStartRequired_;
        if (attResPol > 0) {
            if (attResPol == 5 && this.oc4jRestartAttributeRuntimeValues_.get(attr.getName()) == null) {
                this.oc4jRestartAttributeRuntimeValues_.put(attr.getName(), oldValue);
            } else if (attResPol == 4 && this.applicationRestartAttributeRuntimeValues_.get(attr.getName()) == null) {
                this.applicationRestartAttributeRuntimeValues_.put(attr.getName(), oldValue);
            } else if (attResPol == 2 && this.componentRestartAttributeRuntimeValues_.get(attr.getName()) == null) {
                this.componentRestartAttributeRuntimeValues_.put(attr.getName(), oldValue);
            }
        }
        if (!this.disablePersistenceTemporarily_) {
            PersistenceMetaData attrPersistMetaData = (PersistenceMetaData)this.attributesToCheckForPersistence_.get(attr.getName());
            if (attrPersistMetaData != null && attrPersistMetaData.getPolicy() > 1) {
                this.persist(attrPersistMetaData);
            } else if (this.mbeanLevelPersistence_ != null && this.mbeanLevelPersistence_.getPolicy() > 1) {
                this.persist(this.mbeanLevelPersistence_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(AttributeList attrs) {
        Object tmp;
        if (!this.requirePersitence_) {
            return super.setAttributes(attrs);
        }
        PersistenceMetaData persistMetaData = this.mbeanLevelPersistence_ != null ? this.mbeanLevelPersistence_ : new PersistenceMetaData(1);
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            tmp = (PersistenceMetaData)this.attributesToCheckForPersistence_.get(((Attribute)i.next()).getName());
            if (tmp == null || ((PersistenceMetaData)tmp).getPolicy() <= persistMetaData.getPolicy()) continue;
            persistMetaData = tmp;
        }
        if (persistMetaData.getPolicy() <= 2) {
            return super.setAttributes(attrs);
        }
        this.disablePersistenceTemporarily_ = true;
        try {
            AttributeList result = super.setAttributes(attrs);
            if (!this.registered_) {
                tmp = result;
                return tmp;
            }
            this.disablePersistenceTemporarily_ = false;
            try {
                this.persist(persistMetaData);
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e, "Error while persisting state for MBean: " + this.tgt_);
            }
            AttributeList attributeList = result;
            return attributeList;
        }
        finally {
            this.disablePersistenceTemporarily_ = false;
        }
    }

    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        Object ret = null;
        boolean savedDirtyFlag_ = this.dirtyFlag_;
        PersistenceMetaData operPersistMetaData = (PersistenceMetaData)this.operationsToCheckForPersistence_.get(opName);
        if (operPersistMetaData != null && operPersistMetaData.getPolicy() > 1 || this.mbeanLevelPersistence_ != null && this.mbeanLevelPersistence_.getPolicy() > 1) {
            this.dirtyFlag_ = true;
        }
        try {
            ret = super.invoke(opName, opArgs, sig);
        }
        catch (MBeanException mbe) {
            Exception nested = mbe.getTargetException();
            if (nested != null && nested instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)nested, nested.getMessage());
            }
            throw mbe;
        }
        finally {
            this.dirtyFlag_ = savedDirtyFlag_;
        }
        if (!this.registered_) {
            return ret;
        }
        if ("getMBeanInfo".equals(opName)) {
            if (this.mbeanLevelReStartRequired_ != -1 || !this.attributesToCheckForRestart_.isEmpty() || !this.operationsToCheckForRestart_.isEmpty()) {
                ModelMBeanInfo minfo = (ModelMBeanInfo)ret;
                Descriptor mbeanDesc = minfo.getMBeanDescriptor();
                if (this.oc4jRestartAttributeRuntimeValues_ != null && !this.oc4jRestartAttributeRuntimeValues_.isEmpty()) {
                    mbeanDesc.setField("oc4jRestartAttributesRuntimeValue", this.oc4jRestartAttributeRuntimeValues_);
                }
                if (this.applicationRestartAttributeRuntimeValues_ != null && !this.applicationRestartAttributeRuntimeValues_.isEmpty()) {
                    mbeanDesc.setField("applicationRestartAttributesRuntimeValue", this.applicationRestartAttributeRuntimeValues_);
                }
                if (this.componentRestartAttributeRuntimeValues_ != null && !this.componentRestartAttributeRuntimeValues_.isEmpty()) {
                    mbeanDesc.setField("componentRestartAttributesRuntimeValue", this.componentRestartAttributeRuntimeValues_);
                }
                if (this.oc4jRestartOperationInvoked_ != null && !this.oc4jRestartOperationInvoked_.isEmpty()) {
                    mbeanDesc.setField("oc4jRestartOperationsInvoked", this.oc4jRestartOperationInvoked_);
                }
                if (this.applicationRestartOperationInvoked_ != null && !this.applicationRestartOperationInvoked_.isEmpty()) {
                    mbeanDesc.setField("applicationRestartOperationsInvoked", this.applicationRestartOperationInvoked_);
                }
                if (this.componentRestartOperationInvoked_ != null && !this.componentRestartOperationInvoked_.isEmpty()) {
                    mbeanDesc.setField("componentRestartOperationsInvoked", this.componentRestartOperationInvoked_);
                }
                minfo.setMBeanDescriptor(mbeanDesc);
            }
            return ret;
        }
        if (operPersistMetaData != null && operPersistMetaData.getPolicy() > 1) {
            this.persist(operPersistMetaData);
        } else if (this.mbeanLevelPersistence_ != null && this.mbeanLevelPersistence_.getPolicy() > 1) {
            this.persist(this.mbeanLevelPersistence_);
        }
        int operResPol = -1;
        Integer operRestartPolicy = (Integer)this.operationsToCheckForRestart_.get(opName);
        operResPol = operRestartPolicy != null ? operRestartPolicy : this.mbeanLevelReStartRequired_;
        if (operResPol > 0) {
            if (operResPol == 5) {
                this.oc4jRestartOperationInvoked_.add(opName);
            } else if (operResPol == 4) {
                this.applicationRestartOperationInvoked_.add(opName);
            } else if (operResPol == 2) {
                this.componentRestartOperationInvoked_.add(opName);
            }
        }
        return ret;
    }

    private void persist(PersistenceMetaData persistMetaData) throws MBeanException, RuntimeOperationsException {
        if (persistMetaData.getPolicy() == 5 || persistMetaData.getPolicy() == 6) {
            try {
                this.store();
            }
            catch (InstanceNotFoundException e) {
                throw new JMXRuntimeException((Throwable)e);
            }
            return;
        }
        if (persistMetaData.getPolicy() == 4 || persistMetaData.getPolicy() == 3) {
            long timeExpiredSinceLastUpdate = System.currentTimeMillis() - this.lastUpdated_;
            if (timeExpiredSinceLastUpdate >= (long)(persistMetaData.getPeriod() * 1000)) {
                try {
                    this.store();
                }
                catch (InstanceNotFoundException e) {
                    throw new JMXRuntimeException((Throwable)e);
                }
            } else {
                this.dirtyFlag_ = true;
            }
            return;
        }
        if (persistMetaData.getPolicy() == 2) {
            this.onRegisterDirtyFlag_ = true;
        }
    }

    private static ModelMBeanInfo checkDescriptor(ModelMBeanInfo mminf) {
        try {
            Descriptor desc = mminf.getMBeanDescriptor();
            try {
                Object obj = desc.getFieldValue("currencyTimeLimit");
                if (obj == null) {
                    desc.setField("currencyTimeLimit", new Integer(-1));
                    mminf.setMBeanDescriptor(desc);
                }
            }
            catch (RuntimeOperationsException e) {
                desc.setField("currencyTimeLimit", new Integer(-1));
                mminf.setMBeanDescriptor(desc);
            }
            return mminf;
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private PersistenceMetaData extractPersistencePolicy(Descriptor desc) {
        int policyVal;
        String policy = null;
        try {
            policy = (String)desc.getFieldValue("extendedPersistPolicy");
        }
        catch (RuntimeOperationsException e) {
            // empty catch block
        }
        if (policy == null) {
            policy = (String)desc.getFieldValue("persistPolicy");
        }
        if ((policyVal = this.persistPolicyToInt(policy)) == 3 || policyVal == 4) {
            String period = (String)desc.getFieldValue("persistPeriod");
            int periodVal = -1;
            try {
                periodVal = Integer.parseInt(period);
            }
            catch (NumberFormatException e) {
                throw new JMXRuntimeException((Throwable)e, "Illegal value for Model MBean Descriptor PersistPeriod: " + period);
            }
            return new PersistenceMetaData(policyVal, periodVal);
        }
        return new PersistenceMetaData(policyVal);
    }

    private void introspectStateRequirements(ModelMBeanInfo mminf) throws MBeanException {
        this.attributesToCheckForRestart_ = new Hashtable();
        this.operationsToCheckForRestart_ = new Hashtable();
        this.attributesToCheckForPersistence_ = new Hashtable();
        this.operationsToCheckForPersistence_ = new Hashtable();
        Descriptor desc = mminf.getMBeanDescriptor();
        try {
            String requireRestart = (String)desc.getFieldValue("requireRestart");
            if (requireRestart != null) {
                this.mbeanLevelReStartRequired_ = this.startStateToInt(requireRestart);
                if (logger_.isLoggable(Level.FINEST)) {
                    logger_.finest("MBean --> " + requireRestart + " tgt: " + this.tgt_);
                }
            }
            if (desc.getFieldValue("persistPolicy") != null || desc.getFieldValue("extendedPersistPolicy") != null) {
                this.mbeanLevelPersistence_ = this.extractPersistencePolicy(desc);
                if (this.mbeanLevelPersistence_ != null && this.mbeanLevelPersistence_.getPolicy() > 1 && logger_.isLoggable(Level.FINEST)) {
                    logger_.finest("MBean --> " + this.mbeanLevelPersistence_ + " tgt: " + this.tgt_);
                }
            }
        }
        catch (RuntimeOperationsException e) {
            // empty catch block
        }
        MBeanAttributeInfo[] attrInfo = mminf.getAttributes();
        for (int i = 0; i < attrInfo.length; ++i) {
            Descriptor desci = ((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor();
            try {
                PersistenceMetaData metaData;
                String requireRestart = (String)desci.getFieldValue("requireRestart");
                if (requireRestart != null) {
                    this.attributesToCheckForRestart_.put(attrInfo[i].getName(), new Integer(this.startStateToInt(requireRestart)));
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest("Attr: " + attrInfo[i].getName() + " --> " + requireRestart + " tgt: " + this.tgt_);
                    }
                }
                if (desci.getFieldValue("persistPolicy") == null && desci.getFieldValue("extendedPersistPolicy") == null || (metaData = this.extractPersistencePolicy(desci)).getPolicy() <= 1) continue;
                this.attributesToCheckForPersistence_.put(attrInfo[i].getName(), metaData);
                if (!logger_.isLoggable(Level.FINEST)) continue;
                logger_.finest("Attr: " + attrInfo[i].getName() + " --> " + metaData + " tgt: " + this.tgt_);
                continue;
            }
            catch (RuntimeOperationsException e) {
                // empty catch block
            }
        }
        MBeanOperationInfo[] operInfo = mminf.getOperations();
        for (int j = 0; j < operInfo.length; ++j) {
            Descriptor desco = ((ModelMBeanOperationInfo)operInfo[j]).getDescriptor();
            try {
                PersistenceMetaData metaData;
                String requireRestart = (String)desco.getFieldValue("requireRestart");
                if (requireRestart != null) {
                    this.operationsToCheckForRestart_.put(operInfo[j].getName(), new Integer(this.startStateToInt(requireRestart)));
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest("Oper: " + operInfo[j].getName() + " --> " + requireRestart + " tgt: " + this.tgt_);
                    }
                }
                if (desco.getFieldValue("persistPolicy") == null && desco.getFieldValue("extendedPersistPolicy") == null || (metaData = this.extractPersistencePolicy(desco)).getPolicy() <= 1) continue;
                this.operationsToCheckForPersistence_.put(operInfo[j].getName(), metaData);
                if (!logger_.isLoggable(Level.FINEST)) continue;
                logger_.finest("Oper: " + operInfo[j].getName() + " --> " + metaData + " tgt: " + this.tgt_);
                continue;
            }
            catch (RuntimeOperationsException e) {
                // empty catch block
            }
        }
        if (this.mbeanLevelPersistence_ != null && this.mbeanLevelPersistence_.getPolicy() > 1 || !this.attributesToCheckForPersistence_.isEmpty() || !this.operationsToCheckForPersistence_.isEmpty()) {
            this.requirePersitence_ = true;
        }
    }

    private int startStateToInt(String value) {
        if ("mbeanStopStart".equals(value)) {
            return 1;
        }
        if ("mbeanRestart".equals(value)) {
            return 2;
        }
        if ("applicationStopStart".equals(value)) {
            return 3;
        }
        if ("applicationRestart".equals(value)) {
            return 4;
        }
        if ("oc4jRestart".equals(value)) {
            return 5;
        }
        throw new JMXRuntimeException("Invalid meta-data value for Model MBean Descriptor field requireRestart. Value is: " + value + " for MBean: " + this.tgt_);
    }

    private int persistPolicyToInt(String value) {
        if ("Never".equals(value) || "never".equals(value)) {
            return 1;
        }
        if ("OnTimer".equals(value) || "onTimer".equals(value)) {
            return 3;
        }
        if ("OnUpdate".equals(value) || "onUpdate".equals(value)) {
            return 5;
        }
        if ("NoMoreOftenThan".equals(value) || "noMoreOftenThan".equals(value)) {
            return 4;
        }
        if ("Always".equals(value) || "always".equals(value)) {
            return 6;
        }
        if ("OnUnregister".equals(value)) {
            return 2;
        }
        throw new JMXRuntimeException("Invalid meta-data value for Model MBean Descriptor field persistPolicy. Value is: " + value + " for MBean: " + this.tgt_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postDeregister() {
        try {
            this.tgt_.postDeregister();
            super.postDeregister();
            Object var2_1 = null;
            this.registered_ = false;
            this.tgt_ = null;
            this.persistenceTgt_ = null;
            this.mbeanServer_ = null;
            this.encompassingApplicationComponent_ = null;
            this.operationsToCheckForRestart_ = null;
            this.attributesToCheckForRestart_ = null;
            this.oc4jRestartAttributeRuntimeValues_ = null;
            this.applicationRestartAttributeRuntimeValues_ = null;
            this.componentRestartAttributeRuntimeValues_ = null;
            this.oc4jRestartOperationInvoked_ = null;
            this.applicationRestartOperationInvoked_ = null;
            this.componentRestartOperationInvoked_ = null;
            this.applicationLevelListener_ = null;
            this.applicationLevelFilter_ = null;
            this.mbeanLevelPersistence_ = null;
            this.operationsToCheckForPersistence_ = null;
            this.attributesToCheckForPersistence_ = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.registered_ = false;
            this.tgt_ = null;
            this.persistenceTgt_ = null;
            this.mbeanServer_ = null;
            this.encompassingApplicationComponent_ = null;
            this.operationsToCheckForRestart_ = null;
            this.attributesToCheckForRestart_ = null;
            this.oc4jRestartAttributeRuntimeValues_ = null;
            this.applicationRestartAttributeRuntimeValues_ = null;
            this.componentRestartAttributeRuntimeValues_ = null;
            this.oc4jRestartOperationInvoked_ = null;
            this.applicationRestartOperationInvoked_ = null;
            this.componentRestartOperationInvoked_ = null;
            this.applicationLevelListener_ = null;
            this.applicationLevelFilter_ = null;
            this.mbeanLevelPersistence_ = null;
            this.operationsToCheckForPersistence_ = null;
            this.attributesToCheckForPersistence_ = null;
            throw throwable;
        }
    }

    public final void postRegister(Boolean registrationDone) {
        this.registered_ = true;
        if (this.componentRestartAttributeRuntimeValues_ != null || this.componentRestartOperationInvoked_ != null) {
            RuntimeStateResetListener lsn = new RuntimeStateResetListener(this.componentRestartOperationInvoked_, this.componentRestartAttributeRuntimeValues_);
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("j2ee.state.stopped");
            try {
                this.addNotificationListener(lsn, filter, null);
            }
            catch (Exception ine) {
                logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", ine.toString()), ine);
            }
        }
        if ((this.applicationRestartAttributeRuntimeValues_ != null || this.applicationRestartOperationInvoked_ != null) && this.encompassingApplicationComponent_ != null) {
            this.applicationLevelListener_ = new RuntimeStateResetListener(this.applicationRestartOperationInvoked_, this.applicationRestartAttributeRuntimeValues_);
            this.applicationLevelFilter_ = new NotificationFilterSupport();
            ((NotificationFilterSupport)this.applicationLevelFilter_).enableType("j2ee.state.stopped");
            try {
                this.mbeanServer_.addNotificationListener(this.encompassingApplicationComponent_, this.applicationLevelListener_, this.applicationLevelFilter_, null);
            }
            catch (Exception ine) {
                this.applicationLevelListener_ = null;
                this.applicationLevelFilter_ = null;
            }
        }
        this.tgt_.postRegister(registrationDone);
        super.postRegister(registrationDone);
    }

    public final void preDeregister() throws Exception {
        try {
            if (this.applicationLevelListener_ != null && this.encompassingApplicationComponent_ != null) {
                this.mbeanServer_.removeNotificationListener(this.encompassingApplicationComponent_, this.applicationLevelListener_, this.applicationLevelFilter_, null);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
        this.tgt_.preDeregister();
        if (this.dirtyFlag_ || this.onRegisterDirtyFlag_) {
            this.store();
        }
        super.preDeregister();
        this.onRegisterDirtyFlag_ = false;
    }

    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        String domain = name.getDomain();
        MBeanServer mbsrv = server;
        if (!"ias".equals(domain)) {
            mbsrv = Oc4jMBeanServerFactory.getMBeanServer(domain, server);
        }
        ObjectName newName = this.tgt_.preRegister(mbsrv, name);
        this.mbeanServer_ = server;
        this.setInternalObjectNames(newName);
        return super.preRegister(server, newName);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        super.addNotificationListener(listener, filter, handback);
        ++this.listenerCount_;
        this.tgt_.addNotificationListenerCallBack(listener, filter, handback, this.listenerCount_);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        super.removeNotificationListener(listener);
        --this.listenerCount_;
        this.tgt_.removeNotificationListenerCallBack(listener, null, null, this.listenerCount_);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener, filter, handback);
        --this.listenerCount_;
        this.tgt_.removeNotificationListenerCallBack(listener, filter, handback, this.listenerCount_);
    }

    private boolean isIs(String attributeName) {
        try {
            MBeanInfo info = this.getMBeanInfo();
            MBeanAttributeInfo[] attrInfo = info.getAttributes();
            for (int i = 0; i < attrInfo.length; ++i) {
                if (!attrInfo[i].getName().equals(attributeName)) continue;
                return attrInfo[i].isIs();
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private MBeanAttributeInfo getAttributeMetaData(String attributeName) {
        MBeanInfo info = this.getMBeanInfo();
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        for (int i = 0; i < attrInfo.length; ++i) {
            if (!attrInfo[i].getName().equals(attributeName)) continue;
            return attrInfo[i];
        }
        return null;
    }

    private void setInternalObjectNames(ObjectName name) {
        this.thisComponent_ = name;
        String applicationName = name.getKeyProperty("J2EEApplication");
        String serverName = "standalone";
        String domain = name.getDomain();
        if (applicationName == null && !"oc4j".equals(domain)) {
            applicationName = domain;
            domain = "oc4j";
        }
        if (applicationName != null) {
            try {
                this.encompassingApplicationComponent_ = new ObjectName(domain + ":j2eeType=J2EEApplication,name=" + applicationName + ",J2EEServer=" + serverName);
            }
            catch (MalformedObjectNameException e) {
                logger_.log(Level.WARNING, this.msgHelper_.getLocalizedMessage("caught_exception", e.toString()), e);
            }
        }
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        if (this.persistenceTgt_ != null) {
            this.persistenceTgt_.load();
        }
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        if (this.persistenceTgt_ != null) {
            this.persistenceTgt_.store();
            this.lastUpdated_ = System.currentTimeMillis();
            this.dirtyFlag_ = false;
        }
    }

    static {
        basicTypesClasses_ = new HashMap();
        basicTypesClasses_.put(Boolean.TYPE.getName(), Boolean.TYPE);
        basicTypesClasses_.put(Character.TYPE.getName(), Character.TYPE);
        basicTypesClasses_.put(Byte.TYPE.getName(), Byte.TYPE);
        basicTypesClasses_.put(Short.TYPE.getName(), Short.TYPE);
        basicTypesClasses_.put(Integer.TYPE.getName(), Integer.TYPE);
        basicTypesClasses_.put(Long.TYPE.getName(), Long.TYPE);
        basicTypesClasses_.put(Float.TYPE.getName(), Float.TYPE);
        basicTypesClasses_.put(Double.TYPE.getName(), Double.TYPE);
        basicTypesClasses_.put("Z", Boolean.TYPE);
        basicTypesClasses_.put("C", Character.TYPE);
        basicTypesClasses_.put("B", Byte.TYPE);
        basicTypesClasses_.put("S", Short.TYPE);
        basicTypesClasses_.put("I", Integer.TYPE);
        basicTypesClasses_.put("L", Long.TYPE);
        basicTypesClasses_.put("F", Float.TYPE);
        basicTypesClasses_.put("D", Double.TYPE);
    }

    class RuntimeStateResetListener
    implements NotificationListener {
        private Set operations_ = null;
        private Map attributes_ = null;

        public RuntimeStateResetListener(Set operations, Map attributes) {
            this.operations_ = operations;
            this.attributes_ = attributes;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (this.operations_ != null) {
                this.operations_.clear();
            }
            if (this.attributes_ != null) {
                this.attributes_.clear();
            }
        }
    }

    final class PersistenceMetaData {
        private int policy_ = -1;
        private int period_ = 0;

        PersistenceMetaData(int policy) {
            this.policy_ = policy;
        }

        PersistenceMetaData(int policy, int period) {
            this.policy_ = policy;
            this.period_ = period;
        }

        int getPolicy() {
            return this.policy_;
        }

        int getPeriod() {
            return this.period_;
        }

        public String toString() {
            return "Policy: " + this.policy_ + "\nPeriod in seconds: " + this.period_;
        }
    }
}

