/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.ObjectName;
import oracle.classloader.ClassLoaderFilter;
import oracle.classloader.ClassLoaderFilters;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.QueryProcessor;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.VersionNumber;
import oracle.oc4j.admin.management.mbeans.ClassLoader;
import oracle.oc4j.admin.management.mbeans.ClassLoadingMBean;
import oracle.oc4j.admin.management.mbeans.ClassLoadingMBeanBase;
import oracle.oc4j.admin.management.mbeans.CodeSource;

public class ClassLoading
extends ClassLoadingMBeanBase
implements ClassLoadingMBean {
    private static final ClassLoading singleton = new ClassLoading();

    public static ClassLoading getInstance() {
        return singleton;
    }

    private ClassLoading() {
        super("ClassLoading", "singleton", null);
    }

    public ClassLoading(Locale loc) {
        super("ClassLoading", loc);
    }

    protected void initMetaData() {
        super.initMetaData();
        this.initReadOnlyAttribute("rootLoader", "javax.management.ObjectName");
        this.initReadOnlyAttribute("oc4jLoader", "javax.management.ObjectName");
        this.initReadOnlyAttribute("apiLoader", "javax.management.ObjectName");
        this.initReadOnlyAttribute("allCodeSources", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("allExtensionDeclarations", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("sharedLoaders", "[Ljavax.management.ObjectName;");
        this.initReadOnlyOperation("findLoader", new String[]{"loaderName", "loaderVersion"}, new String[]{"java.lang.String", "java.lang.String"}, "javax.management.ObjectName");
        this.initReadOnlyOperation("executeQuery", new String[]{"query"}, new String[]{"java.lang.String"}, "java.lang.Object");
        this.initReadOnlyOperation("executeQuery", new String[]{"queryClassName", "queryArguments"}, new String[]{"java.lang.String", "[Ljava.lang.String;"}, "java.lang.Object");
        this.initReadOnlyOperation("executeQuery", new String[]{"queryClassName", "queryClassData", "queryArguments"}, new String[]{"java.lang.String", "[B", "[Ljava.lang.String;"}, "java.lang.Object");
    }

    public ObjectName getrootLoader() {
        PolicyClassLoader loader = ClassLoaderQuery.getRootLoader();
        return ClassLoader.getObjectNameFor(loader, true);
    }

    public ObjectName getoc4jLoader() {
        PolicyClassLoader loader = ClassLoaderQuery.getMainLoader();
        return ClassLoader.getObjectNameFor(loader, true);
    }

    public ObjectName getapiLoader() {
        PolicyClassLoader loader = ClassLoaderQuery.getAPILoader();
        return ClassLoader.getObjectNameFor(loader, true);
    }

    public ObjectName[] getallCodeSources() {
        List all = ClassLoaderQuery.getAllCodeSources();
        int count = all.size();
        ObjectName[] result = new ObjectName[count];
        for (int i = 0; i < count; ++i) {
            SharedCodeSource source = (SharedCodeSource)all.get(i);
            result[i] = CodeSource.getObjectNameFor(source, true);
        }
        return result;
    }

    public String[] getallExtensionDeclarations() {
        ArrayList<String> list = new ArrayList<String>();
        Map map = ClassLoaderQuery.getAllExtensionDeclarations();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ExtensionDeclaration[] declarations = (ExtensionDeclaration[])iterator.next();
            for (int i = 0; i < declarations.length; ++i) {
                ExtensionDeclaration declaration = declarations[i];
                if (declaration == null) continue;
                list.add(declaration.toString(true));
            }
        }
        return (String[])ArrayUtils.toArray((Class)String.class, list, (boolean)true);
    }

    public ObjectName[] getsharedLoaders() {
        List loaders = ClassLoaderQuery.getAllLoaders((ClassLoaderFilter)ClassLoaderFilters.SHARED);
        return ClassLoader.getObjectNamesFor(loaders, true);
    }

    public ObjectName findLoader(String loaderName, String loaderVersion) {
        VersionNumber version = new VersionNumber(loaderVersion);
        PolicyClassLoader loader = ClassLoaderQuery.findLoader((String)loaderName, (VersionNumber)version, (VersionNumber)version);
        if (loader != null) {
            return ClassLoader.getObjectNameFor(loader, true);
        }
        return null;
    }

    public Object executeQuery(String query) {
        return QueryProcessor.executeQuery((String)query);
    }

    public Object executeQuery(String queryClassName, String[] queryArguments) {
        return QueryProcessor.executeQuery((String)queryClassName, (String[])queryArguments);
    }

    public synchronized Object executeQuery(String queryClassName, byte[] queryClassData, String[] queryArguments) {
        return QueryProcessor.executeQuery((String)queryClassName, (byte[])queryClassData, (String[])queryArguments);
    }
}

