/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.ApplicationServer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.j2ee.connector.ConnectorMessages;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.J2eeLoggingXmlHelper;
import oracle.oc4j.admin.management.mbeans.J2EELoggingMBean;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2EELogging
extends J2EEManagedObjectBase
implements J2EELoggingMBean {
    private static Logger oracleRootLogger = null;
    private static String oracleRootLoggerName = "oracle";
    private final String mbeanObjectName = ":j2eeType=J2EELogging,name=" + oracleRootLoggerName + ",J2EEServer=" + "standalone";
    private NotificationListener m_dataSourceMessageListener = null;
    private NotificationListener m_connectorMessageListener = null;
    private J2eeLoggingXmlHelper xmlHelper_ = null;

    public J2EELogging() {
        super("oc4j");
        this.setBaseObjectName(this.mbeanObjectName);
        this.init();
        String xmlfile = null;
        try {
            xmlfile = ApplicationServer.getInstance().getConfig().getJ2EELoggingConfigurationPath();
            this.xmlHelper_ = new J2eeLoggingXmlHelper(xmlfile);
        }
        catch (Throwable e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, "j2ee-logging.xml not available: " + xmlfile, e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, "j2ee-logging.xml not available: " + xmlfile, e);
        }
    }

    public J2EELogging(String domainName) {
        super(domainName);
        this.setBaseObjectName(this.mbeanObjectName);
        this.init();
    }

    public J2EELogging(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        oracleRootLogger = Logger.getLogger(oracleRootLoggerName);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("level", "java.lang.String", this.getLocalizedMessage("j2eelogging_level_description"), true, true, false));
        MBeanParameterInfo[] parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_logger_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLoggerLevel", this.getLocalizedMessage("j2eelogging_get_logger_level"), parametersInfo, "java.lang.String", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLoggerNames", this.getLocalizedMessage("j2eelogging_get_logger_names"), null, "java.util.List", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("expression", "java.lang.String", this.getLocalizedMessage("j2eelogging_expression"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLoggerNames", this.getLocalizedMessage("j2eelogging_get_logger_names_with_expression"), parametersInfo, "java.util.List", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_logger_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getParentLoggerName", this.getLocalizedMessage("j2eelogging_get_parent_logger_name"), parametersInfo, "java.lang.String", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_logger_name")), new MBeanParameterInfo("levelName", "java.lang.String", this.getLocalizedMessage("j2eelogging_new_level"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setLoggerLevel", this.getLocalizedMessage("j2eelogging_set_logger_level"), parametersInfo, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getHandlerNames", this.getLocalizedMessage("j2eelogging_get_handler_names"), null, "java.util.List", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("handlerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getHandlerProperties", this.getLocalizedMessage("j2eelogging_get_handler_properties"), parametersInfo, "java.util.properties", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("handlerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_name")), new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_property_name")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_property_value"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setHandlerProperty", this.getLocalizedMessage("j2eelogging_set_handler_property"), parametersInfo, "void", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("handlerName", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_name")), new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("j2eelogging_handler_property_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeHandlerProperty", this.getLocalizedMessage("j2eelogging_remove_handler_property"), parametersInfo, "void", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("j2eelogging_property_name")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("j2eelogging_property_value"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setPropertyForAllHandlers", this.getLocalizedMessage("j2eelogging_set_property_for_all_handlers"), parametersInfo, "void", 1));
        parametersInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("j2eelogging_property_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removePropertyFromAllHandlers", this.getLocalizedMessage("j2eelogging_remove_property_for_all_handlers"), parametersInfo, "void", 1));
        String[] notifTypes = new String[]{"logging.level.changed"};
        this.addModelMBeanNotificationInfo(new ModelMBeanNotificationInfo(notifTypes, "javax.management.Notification", this.getLocalizedMessage("j2eelogging_notif_desc")));
    }

    private void loggingLevelChangedEvent(String notifType, String userData) {
        try {
            Notification notification = new Notification(notifType, (Object)this.getObjectName(), 0L, this.getLocalizedMessage("j2eelogging_level_changed"));
            notification.setUserData(userData);
            this.fireEvent(notification);
        }
        catch (MalformedObjectNameException e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
    }

    public final String getDescription() {
        return this.getLocalizedMessage("j2eelogging_mbean_desc");
    }

    public String getLoggerLevel(String loggerName) {
        String loggerLevel = null;
        try {
            Logger logger = Logger.getLogger(loggerName);
            if (logger != null) {
                Level level = logger.getLevel();
                loggerLevel = level != null ? level.getName() : "";
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
        return loggerLevel;
    }

    public List getLoggerNames() {
        ArrayList<String> loggerNames = new ArrayList<String>();
        try {
            Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
            if (e != null) {
                while (e.hasMoreElements()) {
                    String logName = e.nextElement();
                    if (logName == null || !logName.startsWith("oracle") && !logName.equals("") || TraceLogger.isTraceLogger(logName)) continue;
                    loggerNames.add(logName);
                }
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
        return loggerNames;
    }

    public List getLoggerNames(String expression) {
        ArrayList<String> loggerNames = new ArrayList<String>();
        try {
            Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
            if (e != null) {
                if (expression == null || expression.equals("")) {
                    while (e.hasMoreElements()) {
                        String logName = e.nextElement();
                        if (logName == null || !logName.startsWith("oracle") && !logName.equals("") || TraceLogger.isTraceLogger(logName)) continue;
                        loggerNames.add(logName);
                    }
                } else {
                    while (e.hasMoreElements()) {
                        String logName = e.nextElement();
                        if (logName == null || !logName.matches(expression) || TraceLogger.isTraceLogger(logName)) continue;
                        loggerNames.add(logName);
                    }
                }
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
        return loggerNames;
    }

    public String getParentLoggerName(String loggerName) {
        String parentLoggerName = null;
        try {
            Logger logger = Logger.getLogger(loggerName);
            if (logger != null) {
                Logger parent = logger.getParent();
                parentLoggerName = parent != null ? parent.getName() : "";
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
        return parentLoggerName;
    }

    public void setLoggerLevel(String loggerName, String levelName) {
        try {
            Logger l;
            if (loggerName != null && (l = Logger.getLogger(loggerName)) != null) {
                Level newLevel = null;
                if (levelName != null) {
                    levelName = levelName.toUpperCase();
                    newLevel = ODLLevel.parse((String)levelName);
                }
                l.setLevel(newLevel);
                String realLevelName = l.getLevel() == null ? "null" : l.getLevel().getName();
                this.loggingLevelChangedEvent("logging.level.changed", this.getLocalizedMessage("j2eelogging_level_changed_desc", realLevelName, l.getName()));
                if (this.xmlHelper_ != null) {
                    this.xmlHelper_.updateLoggerLevel(loggerName, realLevelName);
                }
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
    }

    public void setlevel(String levelName) {
        try {
            if (oracleRootLogger != null) {
                this.setLoggerLevel(oracleRootLogger.getName(), levelName);
            }
        }
        catch (Exception e) {
            if (oracleRootLogger != null) {
                oracleRootLogger.log(Level.WARNING, this.getLocalizedMessage("j2eelogging_general_exception", e.toString()), e);
            }
            Logger.getAnonymousLogger().log(Level.WARNING, this.getLocalizedMessage("j2eelogging_logger_exception", e.toString()), e);
        }
    }

    public String getlevel() {
        if (oracleRootLogger != null) {
            return this.getLoggerLevel(oracleRootLogger.getName());
        }
        return null;
    }

    public final void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        ModelMBeanNotificationBroadcaster mbeanBroadcaster = this.getModelMBeanNotificationBroadcaster();
        if (mbeanBroadcaster != null) {
            this.m_dataSourceMessageListener = new DataSourceMessages();
            this.m_connectorMessageListener = new ConnectorMessages();
            mbeanBroadcaster.addNotificationListener(this.m_dataSourceMessageListener, null, null);
            mbeanBroadcaster.addNotificationListener(this.m_connectorMessageListener, null, null);
        }
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        ModelMBeanNotificationBroadcaster mbeanBroadcaster = this.getModelMBeanNotificationBroadcaster();
        if (mbeanBroadcaster != null) {
            if (this.m_dataSourceMessageListener != null) {
                mbeanBroadcaster.removeNotificationListener(this.m_dataSourceMessageListener);
            }
            if (this.m_connectorMessageListener != null) {
                mbeanBroadcaster.removeNotificationListener(this.m_connectorMessageListener);
            }
        }
    }

    public List getHandlerNames() {
        NodeList nl = this.xmlHelper_.getHandlerElements();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            names.add(((Element)nl.item(i)).getAttribute("name"));
        }
        return names;
    }

    public Properties getHandlerProperties(String handlerName) {
        return this.xmlHelper_.getHandlerProperties(handlerName);
    }

    public void setHandlerProperty(String handlerName, String propertyName, String propertyValue) {
        this.xmlHelper_.addHandlerProperty(handlerName, propertyName, propertyValue);
    }

    public void removeHandlerProperty(String handlerName, String propertyName) {
        this.xmlHelper_.removeHandlerProperty(handlerName, propertyName);
    }

    public void setPropertyForAllHandlers(String propertyName, String propertyValue) {
        ArrayList handlerNames = (ArrayList)this.getHandlerNames();
        for (int i = 0; i < handlerNames.size(); ++i) {
            this.setHandlerProperty((String)handlerNames.get(i), propertyName, propertyValue);
        }
    }

    public void removePropertyFromAllHandlers(String propertyName) {
        ArrayList handlerNames = (ArrayList)this.getHandlerNames();
        for (int i = 0; i < handlerNames.size(); ++i) {
            this.removeHandlerProperty((String)handlerNames.get(i), propertyName);
        }
    }
}

