/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import oracle.j2ee.admin.jmx.JMXState;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.model.ManagementModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObject;

public class J2EEManagedObjectBase
extends ManagementModelMBeanProvider
implements J2EEManagedObject {
    private static Logger logger_ = TraceLogger.getLogger(J2EEManagedObjectBase.class);
    private static Hashtable domainToMBeanServerAssociation_ = new Hashtable();
    private static final String resourceBundleLocation_ = "oracle.oc4j.admin.management.mbeans.Messages";
    private String domain_ = null;
    private String baseObjectname_ = null;

    protected J2EEManagedObjectBase(String domain) {
        super(J2EEManagedObjectBase.getResourceBundle(resourceBundleLocation_, Locale.getDefault()), Locale.getDefault());
        this.domain_ = domain;
        this.init();
    }

    protected J2EEManagedObjectBase(String domain, Locale loc) {
        super(J2EEManagedObjectBase.getResourceBundle(resourceBundleLocation_, loc), loc);
        this.domain_ = domain;
        this.init();
    }

    protected J2EEManagedObjectBase() {
        super(J2EEManagedObjectBase.getResourceBundle(resourceBundleLocation_, Locale.getDefault()), Locale.getDefault());
        this.domain_ = "oc4j";
        this.init();
    }

    protected J2EEManagedObjectBase(Locale loc) {
        super(J2EEManagedObjectBase.getResourceBundle(resourceBundleLocation_, loc), loc);
        this.domain_ = "oc4j";
        this.init();
    }

    private static ResourceBundle getResourceBundle(String resourceBundleLocation, Locale loc) {
        return ResourceBundle.getBundle(resourceBundleLocation, loc);
    }

    protected final Map getDescriptorPersistConfigProperty() {
        Map descriptorProperties = this.getDescriptorConfig();
        descriptorProperties.put("persistPolicy", "OnUpdate");
        return descriptorProperties;
    }

    protected final Map getDescriptorConfig() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("currencyTimeLimit", new Integer(-1));
        return map;
    }

    protected void setBaseObjectName(String baseObjectName) {
        this.baseObjectname_ = baseObjectName;
    }

    protected String getBaseObjectName() {
        return this.baseObjectname_;
    }

    public static void registerMBeanServer(String domainName, MBeanServer server) {
        domainToMBeanServerAssociation_.put(domainName, server);
    }

    public final String getDomain() {
        return this.domain_;
    }

    protected MBeanServer getMBeanServer(String domainName) {
        return (MBeanServer)domainToMBeanServerAssociation_.get(domainName);
    }

    protected MBeanServer getMBeanServer() {
        return (MBeanServer)domainToMBeanServerAssociation_.get(this.domain_);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return ObjectNameFactory.create((String)(this.getDomain() + this.getBaseObjectName()));
    }

    public ObjectName[] getObjectNameForPattern(String objectNamePattern) throws JMXException {
        return this.getObjectNameForPattern(objectNamePattern, null);
    }

    protected Set getSetObjectNameForPattern(String objectNamePattern) throws JMXException {
        return this.getSetObjectNameForPattern(objectNamePattern, null);
    }

    protected ObjectName[] getObjectNameForPattern(String objectNamePattern, QueryExp qexp) throws JMXException {
        try {
            Set targets = this.getSetObjectNameForPattern(objectNamePattern, qexp);
            ObjectName[] objectNameArray = new ObjectName[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                objectNameArray[targetCount++] = (ObjectName)iter.next();
            }
            return objectNameArray;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new JMXException((Throwable)e);
        }
    }

    protected Set getSetObjectNameForPattern(String objectNamePattern, QueryExp qexp) throws JMXException {
        try {
            ObjectName targetPattern = ObjectNameFactory.create((String)objectNamePattern);
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("J2EEManagedObjectBase::getObjectNameForPattern Target search pattern: " + targetPattern);
            }
            MBeanServer mbeanServer = this.getMBeanServer(this.domain_);
            Set<ObjectName> targets = mbeanServer.queryNames(targetPattern, qexp);
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("" + targets.size() + " ObjectName retrieved");
            }
            return targets;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new JMXException((Throwable)e);
        }
    }

    private void init() {
    }

    public static Locale getLocaleForCall() {
        JMXState st = JMXStateFactory.getJMXState();
        return st.getLocale();
    }

    public static void setLocaleForCall(Locale loc) {
        JMXStateFactoryImpl.setLocaleForCall(loc);
    }

    public static void unsetLocaleForCall() {
        JMXStateFactoryImpl.unsetJMXStateForCall();
    }

    protected final ResourceBundle getResourceBundle(Locale loc) {
        return ResourceBundle.getBundle(resourceBundleLocation_, loc);
    }

    protected final ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.getLocale());
    }
}

