/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEDeployedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEModule;

public abstract class J2EEModuleBase
extends J2EEDeployedObjectBase
implements J2EEModule {
    private String moduleName_ = null;
    private String applicationName_ = null;

    protected J2EEModuleBase(J2EEModuleCallBackIf callBackIf, String moduleName, String applicationName, String j2eeServerName, String domain) {
        super(callBackIf, domain, j2eeServerName);
        this.moduleName_ = moduleName;
        this.applicationName_ = applicationName;
        this.init();
    }

    protected J2EEModuleBase(J2EEModuleCallBackIf callBackIf, String moduleName, String applicationName) {
        super(callBackIf);
        this.moduleName_ = moduleName;
        this.applicationName_ = applicationName;
        this.init();
    }

    protected J2EEModuleBase(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("javaVMs", "[Ljava.lang.String;", this.getLocalizedMessage("j2eemodule_javaVMs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("JavaVMs", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eemodule_javaVMs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("server", "java.lang.String", this.getLocalizedMessage("j2eestatemanageableobjectbase_server"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("Server", "javax.management.ObjectName", this.getLocalizedMessage("j2eestatemanageableobjectbase_server"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("startTime", "long", this.getLocalizedMessage("statemanageable_startTime"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("state", "int", this.getLocalizedMessage("statemanageable_state"), true, false, false));
    }

    protected final String getModuleName() {
        return this.moduleName_;
    }

    protected final String getApplicationName() {
        return this.applicationName_;
    }

    public ObjectName[] getJavaVMs() throws JMXException {
        String searchPattern = "*:j2eeType=JVM,J2EEServer=" + this.getJ2eeServerName() + ",*";
        return this.getObjectNameForPattern(searchPattern);
    }

    public String[] getjavaVMs() throws JMXException {
        ObjectName[] objs = this.getJavaVMs();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public final ObjectName getServer() throws MalformedObjectNameException {
        return ObjectNameFactory.create((String)(this.getDomain() + ":j2eeType=J2EEServer,name=" + this.getJ2eeServerName()));
    }

    public final String getserver() throws MalformedObjectNameException {
        return this.getServer().toString();
    }

    public long getstartTime() {
        try {
            return (Long)this.getMBeanServer().getAttribute(this.getApplication(), "startTime");
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public int getstate() {
        try {
            return (Integer)this.getMBeanServer().getAttribute(this.getApplication(), "state");
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private ObjectName getApplication() {
        String appName = this.getDomain() + ":j2eeType=J2EEApplication,J2EEServer=" + this.getJ2eeServerName() + ",name=" + this.applicationName_;
        return ObjectNameFactory.create((String)appName);
    }
}

