/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.ApplicationServer;
import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEServerCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerLifeCycle;
import oracle.oc4j.admin.management.mbeans.J2EEServerMBean;
import oracle.oc4j.admin.management.mbeans.StateManageable;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.InstalledLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class J2EEServer
extends J2EEManagedObjectBase
implements J2EEServerMBean,
J2EEServerLifeCycle {
    private static Logger logger_ = TraceLogger.getLogger(J2EEServer.class);
    private static J2EEServerLifeCycle lifeCycleSingleton_ = null;
    private String serverName_ = null;
    private J2EEServerCallBackIf callBackIf_ = null;

    public J2EEServer(J2EEServerCallBackIf callBackIf, String serverName, String domainName) {
        super(domainName);
        this.serverName_ = serverName;
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=J2EEServer,name=" + this.serverName_);
        lifeCycleSingleton_ = this;
        this.init();
    }

    public J2EEServer(J2EEServerCallBackIf callBackIf) {
        super("oc4j");
        this.serverName_ = "standalone";
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=J2EEServer,name=" + this.serverName_);
        lifeCycleSingleton_ = this;
        this.init();
    }

    public J2EEServer(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("deployedObjects", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_deployedObjects"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("dmsOn", Boolean.TYPE.getName(), this.getLocalizedMessage("j2eeserver_dmsOn"), true, false, true));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("node", "java.lang.String", this.getLocalizedMessage("j2eeserver_node"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("oracleHome", "java.lang.String", this.getLocalizedMessage("j2eeserver_OracleHome"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("instanceName", "java.lang.String", this.getLocalizedMessage("j2eeserver_instanceName"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("DeployedObjects", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eeserver_deployedObjects"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("Resources", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eeserver_resources"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_resources"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("javaVMs", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_javaVMs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("JavaVMs", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eeserver_javaVMs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("j2eeWebSites", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_j2eeWebSites"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("J2eeWebSites", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eeserver_j2eeWebSites"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("serverVendor", "java.lang.String", this.getLocalizedMessage("j2eeserver_serverVendor"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("serverVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_serverVersion"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("defaultApplication", "javax.management.ObjectName", this.getLocalizedMessage("j2eeserver_defaultApplication"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("sharedLibraries", "[Loracle.oc4j.admin.management.shared.SharedLibrary;", this.getLocalizedMessage("j2eeserver_sharedLibraries"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("installedLibraries", "[Loracle.oc4j.admin.management.shared.InstalledLibrary;", this.getLocalizedMessage("j2eeserver_installedLibraries"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("serverBuildDate", "java.lang.String", this.getLocalizedMessage("j2eeserver_serverBuildDate"), true, false, false));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("input", "oracle.oc4j.admin.jmx.shared.util.DataSink", this.getLocalizedMessage("j2eeserver_installSharedLibrary_input")), new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("codeSource", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_codeSource"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("installSharedLibrary", this.getLocalizedMessage("j2eeserver_installSharedLibrary"), params, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getInstalledLibraryNames", this.getLocalizedMessage("j2eeserver_installedLibrary_names"), new MBeanParameterInfo[0], "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_installedLibrary_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getInstalledLibraryVersions", this.getLocalizedMessage("j2eeserver_installedLibrary_versions"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_installedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_installedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getInstalledLibraryCodeSources", this.getLocalizedMessage("j2eeserver_installedLibrary_codeSources"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("checkSharedLibraryExists", this.getLocalizedMessage("j2eeserver_checkSharedLibraryExists"), params, "boolean", 0), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeSharedLibrary", this.getLocalizedMessage("j2eeserver_removeSharedLibrary"), params, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("libraryName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("libraryVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("libraryCompatible", "java.lang.Boolean", this.getLocalizedMessage("j2eeserver_sharedLibrary_libraryCompatible")), new MBeanParameterInfo("addCodeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_addCodeSources")), new MBeanParameterInfo("removeCodeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_removeCodeSources")), new MBeanParameterInfo("addImports", "[Loracle.oc4j.admin.management.shared.ImportSharedLibrary;", this.getLocalizedMessage("j2eeserver_sharedLibrary_addImports")), new MBeanParameterInfo("removeImports", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_removeImports"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("modifySharedLibrary", this.getLocalizedMessage("j2eeserver_modifySharedLibrary"), params, "boolean", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("libraryName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("libraryVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("libraryCompatible", "java.lang.Boolean", this.getLocalizedMessage("j2eeserver_sharedLibrary_libraryCompatible")), new MBeanParameterInfo("addCodeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_addCodeSources")), new MBeanParameterInfo("removeCodeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_removeCodeSources")), new MBeanParameterInfo("addImports", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_addImportsString")), new MBeanParameterInfo("removeImports", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_removeImports"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("modifySharedLibrary", this.getLocalizedMessage("j2eeserver_modifySharedLibrary"), params, "boolean", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("libraryName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("libraryVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("parentName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_parentName")), new MBeanParameterInfo("parentVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_parentVersion")), new MBeanParameterInfo("libraryCompatible", "java.lang.Boolean", this.getLocalizedMessage("j2eeserver_sharedLibrary_libraryCompatible")), new MBeanParameterInfo("codeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_codeSources")), new MBeanParameterInfo("imports", "[Loracle.oc4j.admin.management.shared.ImportSharedLibrary;", this.getLocalizedMessage("j2eeserver_sharedLibrary_imports"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("publishSharedLibrary", this.getLocalizedMessage("j2eeserver_publishSharedLibrary"), params, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("libraryName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("libraryVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("parentName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_parentName")), new MBeanParameterInfo("parentVersion", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_parentVersion")), new MBeanParameterInfo("libraryCompatible", "java.lang.Boolean", this.getLocalizedMessage("j2eeserver_sharedLibrary_libraryCompatible")), new MBeanParameterInfo("codeSources", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_codeSources")), new MBeanParameterInfo("imports", "[Ljava.lang.String;", this.getLocalizedMessage("j2eeserver_sharedLibrary_string_imports"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("publishSharedLibrary", this.getLocalizedMessage("j2eeserver_publishSharedLibrary"), params, "void", 1), persistenceDescriptorProperties);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryNames", this.getLocalizedMessage("j2eeserver_sharedLibrary_Names"), new MBeanParameterInfo[0], "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryVersions", this.getLocalizedMessage("j2eeserver_sharedLibrary_Versions"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryCodeSourcePaths", this.getLocalizedMessage("j2eeserver_sharedLibrary_CodeSourcePaths"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryImportNames", this.getLocalizedMessage("j2eeserver_sharedLibrary_ImportNames"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("importName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_importName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryImportMinVersion", this.getLocalizedMessage("j2eeserver_sharedLibrary_ImportMinVersion"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version")), new MBeanParameterInfo("importName", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_importName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedLibraryImportMaxVersion", this.getLocalizedMessage("j2eeserver_sharedLibrary_ImportMaxVersion"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("instantiateSharedLibrary", this.getLocalizedMessage("j2eeserver_instantiateSharedLibrary"), params, "java.lang.Boolean", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("isSharedLibraryInstantiated", this.getLocalizedMessage("j2eeserver_isSharedLibraryInstantiated"), params, "java.lang.Boolean", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_name")), new MBeanParameterInfo("version", "java.lang.String", this.getLocalizedMessage("j2eeserver_sharedLibrary_version"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("isSharedLibraryLibraryCompatible", this.getLocalizedMessage("j2eeserver_isSharedLibraryLibraryCompatible"), params, "java.lang.Boolean", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_loadApplication_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("loadApplication", this.getLocalizedMessage("j2eeserver_loadApplication"), params, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("defaultRoutingId", "java.lang.String", this.getLocalizedMessage("j2eeserver_defaultRoutingId"), true, true, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getPersistentProperties", this.getLocalizedMessage("j2eeserver_getPersistentProperties"), new MBeanParameterInfo[0], "java.util.Properties", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_persistentProperty_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getPersistentProperty", this.getLocalizedMessage("j2eeserver_getPersistentProperty"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_persistentProperty_name")), new MBeanParameterInfo("value", "java.lang.String", this.getLocalizedMessage("j2eeserver_persistentProperty_value"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setPersistentProperty", this.getLocalizedMessage("j2eeserver_setPersistentProperty"), params, "void", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_persistentProperty_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removePersistentProperty", this.getLocalizedMessage("j2eeserver_removePersistentProperty"), params, "null", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("j2eeserver_website_name")), new MBeanParameterInfo("protocol", "java.lang.String", this.getLocalizedMessage("j2eeserver_website_protocol")), new MBeanParameterInfo("port", Integer.TYPE.getName(), this.getLocalizedMessage("j2eeserver_website_port")), new MBeanParameterInfo("keystorePath", "java.lang.String", this.getLocalizedMessage("j2eeserver_website_keystorePath")), new MBeanParameterInfo("keystorePassword", "java.lang.String", this.getLocalizedMessage("j2eeserver_website_keystorePassword")), new MBeanParameterInfo("sslProvider", "java.lang.String", this.getLocalizedMessage("j2eeserver_website_sslProvider"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addWebSite", this.getLocalizedMessage("j2eeserver_addWebSite"), params, "void", 1));
        this.addStateManageableInfo();
        String[] notifType = new String[]{"j2ee.lifecycle.application.added", "j2ee.lifecycle.application.removed", "j2ee.lifecycle.application.replaced", "j2ee.lifecycle.server.ready", "j2ee.lifecycle.server.shutdown"};
        this.addModelMBeanNotificationInfo(new ModelMBeanNotificationInfo(notifType, "javax.management.Notification", this.getLocalizedMessage("j2eeserver_lifecycle_notifications")));
    }

    public String getDescription() {
        return this.getLocalizedMessage("j2eeserver_description");
    }

    public ObjectName[] getDeployedObjects() throws JMXException {
        ObjectName[][] deplObjs = new ObjectName[5][];
        String ejbModulePattern = "*:j2eeType=EJBModule,J2EEServer=" + this.serverName_ + ",*";
        deplObjs[0] = this.getObjectNameForPattern(ejbModulePattern);
        String appClModulePattern = "*:j2eeType=AppClientModule,J2EEServer=" + this.serverName_ + ",*";
        deplObjs[1] = this.getObjectNameForPattern(appClModulePattern);
        String webModulePattern = "*:j2eeType=WebModule,J2EEServer=" + this.serverName_ + ",*";
        deplObjs[2] = this.getObjectNameForPattern(webModulePattern);
        String resourceModulePattern = "*:j2eeType=ResourceAdapterModule,J2EEServer=" + this.serverName_ + ",*";
        deplObjs[3] = this.getObjectNameForPattern(resourceModulePattern);
        String applicationPattern = "*:j2eeType=J2EEApplication,J2EEServer=" + this.serverName_ + ",*";
        deplObjs[4] = this.getObjectNameForPattern(applicationPattern);
        int moduleCount = 0;
        for (int i = 0; i < 5; ++i) {
            if (deplObjs[i] == null) continue;
            moduleCount += deplObjs[i].length;
        }
        ObjectName[] res = new ObjectName[moduleCount];
        int c = 0;
        for (int i = 0; i < 5; ++i) {
            if (deplObjs[i] == null) continue;
            for (int j = 0; j < deplObjs[i].length; ++j) {
                res[c++] = deplObjs[i][j];
            }
        }
        return res;
    }

    public String[] getdeployedObjects() throws JMXException {
        ObjectName[] objs = this.getDeployedObjects();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public ObjectName[] getResources() throws JMXException {
        ObjectName[][] resObjs = new ObjectName[9][];
        String jdbcResourcePattern = "*:j2eeType=JDBCResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[0] = this.getObjectNameForPattern(jdbcResourcePattern);
        String jndiResourcePattern = "*:j2eeType=JNDIResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[1] = this.getObjectNameForPattern(jndiResourcePattern);
        String javaMailResourcePattern = "*:j2eeType=JavaMailResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[2] = this.getObjectNameForPattern(javaMailResourcePattern);
        String jtaResourcePattern = "*:j2eeType=JTAResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[3] = this.getObjectNameForPattern(jtaResourcePattern);
        String jmsResourcePattern = "*:j2eeType=JMSResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[4] = this.getObjectNameForPattern(jmsResourcePattern);
        String jmsAdministratorResourcePattern = "*:j2eeType=JMSAdministratorResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[5] = this.getObjectNameForPattern(jmsAdministratorResourcePattern);
        String rmiIIOPResourcePattern = "*:j2eeType=RMIIIOPResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[6] = this.getObjectNameForPattern(rmiIIOPResourcePattern);
        String URLResourcePattern = "*:j2eeType=URLResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[7] = this.getObjectNameForPattern(URLResourcePattern);
        String jcaResourcePattern = "*:j2eeType=JCAResource,J2EEServer=" + this.serverName_ + ",*";
        resObjs[8] = this.getObjectNameForPattern(jcaResourcePattern);
        int resCount = 0;
        for (int i = 0; i < 9; ++i) {
            if (resObjs[i] == null) continue;
            resCount += resObjs[i].length;
        }
        ObjectName[] res = new ObjectName[resCount];
        int c = 0;
        for (int i = 0; i < 9; ++i) {
            if (resObjs[i] == null) continue;
            for (int j = 0; j < resObjs[i].length; ++j) {
                res[c++] = resObjs[i][j];
            }
        }
        return res;
    }

    public String[] getresources() throws JMXException {
        ObjectName[] objs = this.getResources();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public ObjectName[] getJavaVMs() throws JMXException {
        return this.getObjectNameForPattern("*:j2eeType=JVM,J2EEServer=" + this.serverName_ + ",*");
    }

    public String[] getjavaVMs() throws JMXException {
        ObjectName[] objs = this.getJavaVMs();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public ObjectName[] getJ2eeWebSites() throws JMXException {
        return this.getObjectNameForPattern("*:j2eeType=J2EEWebSite,J2EEServer=" + this.serverName_ + ",*");
    }

    public String[] getj2eeWebSites() throws JMXException {
        ObjectName[] objs = this.getJ2eeWebSites();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public String getserverVendor() {
        return "Oracle Corp.";
    }

    public String getserverVersion() {
        return ApplicationServer.VERSION;
    }

    protected final void setCallBackInterface(J2EEServerCallBackIf clbk) {
        this.callBackIf_ = clbk;
    }

    private final StateManageable getStateManageableCallBackInterface() {
        return this.callBackIf_;
    }

    public final boolean getstateManageable() {
        return true;
    }

    public final boolean geteventProvider() {
        return true;
    }

    public void start() {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                block8: {
                    ResourceBundle bundle = this.getResourceBundle();
                    locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                    try {
                        notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting") + this.getobjectName());
                        this.fireEvent(notification);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block8;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    this.getStateManageableCallBackInterface().start();
                }
                catch (Throwable t) {
                    try {
                        Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_start") + this.getobjectName());
                        NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                        notification2.setUserData(userData);
                        this.fireEvent(notification2);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block9;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            try {
                notification = new Notification("j2ee.state.running", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_start") + this.getobjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block10;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void stop() {
        block12: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block11: {
                block10: {
                    ResourceBundle bundle = this.getResourceBundle();
                    locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                    try {
                        notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                        this.fireEvent(notification);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block10;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    String uid = System.getProperty("oracle.ons.uid");
                    if (uid != null) {
                        Class<?> cl = Class.forName("com.evermind.util.OpmnHelper");
                        Method stop = cl.getMethod("stopOc4j", Class.forName("java.lang.String"));
                        stop.invoke(null, uid);
                    } else {
                        this.getStateManageableCallBackInterface().stop();
                    }
                }
                catch (Throwable t) {
                    try {
                        Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                        NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                        notification2.setUserData(userData);
                        this.fireEvent(notification2);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block11;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            try {
                notification = new Notification("j2ee.state.stopped", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_stop") + this.getobjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block12;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    public void startRecursive() {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                block8: {
                    ResourceBundle bundle = this.getResourceBundle();
                    locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                    try {
                        notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting_rec") + this.getobjectName());
                        this.fireEvent(notification);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block8;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    this.getStateManageableCallBackInterface().startRecursive();
                }
                catch (Throwable t) {
                    try {
                        Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_startrec", this.getobjectName()));
                        NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                        notification2.setUserData(userData);
                        this.fireEvent(notification2);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger_.isLoggable(Level.SEVERE)) break block9;
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            try {
                notification = new Notification("j2ee.state.running", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_startrec", this.getobjectName()));
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block10;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public long getstartTime() {
        return this.getStateManageableCallBackInterface().getstartTime();
    }

    public int getstate() {
        return this.getStateManageableCallBackInterface().getstate();
    }

    public ObjectName getdefaultApplication() {
        return this.callBackIf_.getdefaultApplication();
    }

    public String getnode() {
        try {
            ObjectName[] objs = this.getJavaVMs();
            String node = (String)this.getMBeanServer().getAttribute(objs[0], "node");
            return node;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getoracleHome() {
        try {
            File oracleHomeFile = new File(OC4JRuntimeProperties.getOracleHome());
            return oracleHomeFile.getCanonicalPath();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getinstanceName() {
        try {
            File oracleJ2eeHome = new File(OC4JRuntimeProperties.getOracleJ2eeHome());
            File canonicalJ2eeHome = oracleJ2eeHome.getCanonicalFile();
            return canonicalJ2eeHome.getName();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private String getApplicationDirectory() throws IOException {
        return this.callBackIf_.getApplicationDirectory();
    }

    public InstalledLibrary[] getinstalledLibraries() throws IOException {
        try {
            return this.callBackIf_.getInstalledLibraries();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getserverBuildDate() {
        StringTokenizer tokens;
        String buildNumber = ApplicationServer.getBuildNumber();
        if (buildNumber != null && (tokens = new StringTokenizer(buildNumber, ".")).hasMoreTokens()) {
            return tokens.nextToken();
        }
        return null;
    }

    public void installSharedLibrary(DataSink input, String name, String version, String codeSource) throws IOException {
        this.callBackIf_.installSharedLibrary(input, name, version, codeSource);
    }

    public String[] getInstalledLibraryNames() throws IOException {
        return this.callBackIf_.getInstalledLibraryNames();
    }

    public String[] getInstalledLibraryVersions(String libraryName) throws IOException {
        return this.callBackIf_.getInstalledLibraryVersions(libraryName);
    }

    public String[] getInstalledLibraryCodeSources(String libraryName, String libraryVersion) throws IOException {
        return this.callBackIf_.getInstalledLibraryCodeSources(libraryName, libraryVersion);
    }

    public SharedLibrary[] getsharedLibraries() {
        try {
            return this.callBackIf_.getSharedLibraries();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean checkSharedLibraryExists(String libraryName, String libraryVersion) {
        return this.callBackIf_.checkSharedLibraryExists(libraryName, libraryVersion);
    }

    public void removeSharedLibrary(String libraryName, String libraryVersion) throws InstantiationException {
        this.callBackIf_.removeSharedLibrary(libraryName, libraryVersion);
    }

    public boolean modifySharedLibrary(String libraryName, String libraryVersion, Boolean libraryCompatible, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws InstantiationException {
        return this.callBackIf_.modifySharedLibrary(libraryName, libraryVersion, libraryCompatible, addCodeSources, removeCodeSources, addImports, removeImports);
    }

    public boolean modifySharedLibrary(String libraryName, String libraryVersion, Boolean libraryCompatible, String[] addCodeSources, String[] removeCodeSources, String[] addImports, String[] removeImports) throws InstantiationException {
        ImportSharedLibrary[] imports = null;
        if (addImports != null) {
            for (int i = 0; i < addImports.length; ++i) {
                imports[i] = ImportSharedLibrary.createImport((String)addImports[i]);
            }
        }
        return this.callBackIf_.modifySharedLibrary(libraryName, libraryVersion, libraryCompatible, addCodeSources, removeCodeSources, imports, removeImports);
    }

    public void publishSharedLibrary(String libraryName, String libraryVersion, String parentName, String parentVersion, Boolean libraryCompatible, String[] codeSources, ImportSharedLibrary[] imports) throws InstantiationException {
        this.callBackIf_.publishSharedLibrary(libraryName, libraryVersion, parentName, parentVersion, libraryCompatible, codeSources, imports);
    }

    public void publishSharedLibrary(String libraryName, String libraryVersion, String parentName, String parentVersion, Boolean libraryCompatible, String[] codeSources, String[] imports) throws InstantiationException {
        ImportSharedLibrary[] libs = null;
        if (imports != null) {
            libs = new ImportSharedLibrary[imports.length];
            for (int i = 0; i < imports.length; ++i) {
                libs[i] = ImportSharedLibrary.createImport((String)imports[i]);
            }
        }
        this.callBackIf_.publishSharedLibrary(libraryName, libraryVersion, parentName, parentVersion, libraryCompatible, codeSources, libs);
    }

    public String[] getSharedLibraryNames() {
        try {
            return this.callBackIf_.getSharedLibraryNames();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String[] getSharedLibraryVersions(String libraryName) {
        try {
            return this.callBackIf_.getSharedLibraryVersions(libraryName);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String[] getSharedLibraryCodeSourcePaths(String libraryName, String libraryVersion) {
        try {
            return this.callBackIf_.getSharedLibraryCodeSourcePaths(libraryName, libraryVersion);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String[] getSharedLibraryImportNames(String libraryName, String libraryVersion) {
        try {
            return this.callBackIf_.getSharedLibraryImportNames(libraryName, libraryVersion);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getSharedLibraryImportMinVersion(String libraryName, String libraryVersion, String importName) {
        try {
            return this.callBackIf_.getSharedLibraryImportMinVersion(libraryName, libraryVersion, importName);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getSharedLibraryImportMaxVersion(String libraryName, String libraryVersion, String importName) {
        try {
            return this.callBackIf_.getSharedLibraryImportMaxVersion(libraryName, libraryVersion, importName);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean instantiateSharedLibrary(String libraryName, String libraryVersion) {
        try {
            boolean res = this.callBackIf_.instantiateSharedLibrary(libraryName, libraryVersion);
            return res;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean isSharedLibraryInstantiated(String libraryName, String libraryVersion) {
        try {
            boolean res = this.callBackIf_.isSharedLibraryInstantiated(libraryName, libraryVersion);
            return res;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean isSharedLibraryLibraryCompatible(String libraryName, String libraryVersion) {
        try {
            boolean res = this.callBackIf_.isSharedLibraryLibraryCompatible(libraryName, libraryVersion);
            return res;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void loadApplication(String appName) throws InstantiationException {
        this.callBackIf_.loadApplication(appName);
    }

    public String getdefaultRoutingId() {
        return this.callBackIf_.getDefaultRoutingId();
    }

    public void setdefaultRoutingId(String routingId) {
        this.callBackIf_.setDefaultRoutingId(routingId);
    }

    public boolean isdmsOn() {
        return ApplicationServer.DMS_GATE;
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.callBackIf_.persistConfigChange();
        }
        catch (IOException ioe) {
            throw new MBeanException(ioe);
        }
    }

    public final void reportApplicationAdded(String appName) {
        block2: {
            try {
                Notification notification = new Notification("j2ee.lifecycle.application.added", this.getObjectName(), 0L, new Date().getTime(), this.getLocalizedMessage("j2ee.lifecycle.application.added", appName));
                notification.setUserData(appName);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public final void reportApplicationRemoved(String appName) {
        block2: {
            try {
                Notification notification = new Notification("j2ee.lifecycle.application.removed", this.getObjectName(), 0L, new Date().getTime(), this.getLocalizedMessage("j2ee.lifecycle.application.removed", appName));
                notification.setUserData(appName);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public final void reportApplicationReplaced(String appName) {
        block2: {
            try {
                Notification notification = new Notification("j2ee.lifecycle.application.replaced", this.getObjectName(), 0L, new Date().getTime(), this.getLocalizedMessage("j2ee.lifecycle.application.replaced", appName));
                notification.setUserData(appName);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public final void reportServerReady() {
        block2: {
            try {
                Notification notification = new Notification("j2ee.lifecycle.server.ready", this.getObjectName(), 0L, new Date().getTime(), this.getLocalizedMessage("j2ee.lifecycle.server.ready"));
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public final void reportServerShutdown() {
        block2: {
            try {
                Notification notification = new Notification("j2ee.lifecycle.server.shutdown", this.getObjectName(), 0L, new Date().getTime(), this.getLocalizedMessage("j2ee.lifecycle.server.shutdown"));
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static void notifyApplicationAdded(String appName) {
        lifeCycleSingleton_.reportApplicationAdded(appName);
    }

    public static void notifyApplicationRemoved(String appName) {
        lifeCycleSingleton_.reportApplicationRemoved(appName);
    }

    public static void notifyApplicationReplaced(String appName) {
        lifeCycleSingleton_.reportApplicationReplaced(appName);
    }

    public static void notifyServerShutdown() {
        lifeCycleSingleton_.reportServerShutdown();
    }

    public static void notifyServerReady() {
        lifeCycleSingleton_.reportServerReady();
    }

    public Properties getPersistentProperties() {
        return this.callBackIf_.getPersistentProperties();
    }

    public String getPersistentProperty(String name) {
        return this.callBackIf_.getPersistentProperty(name);
    }

    public void setPersistentProperty(String name, String value) {
        this.callBackIf_.setPersistentProperty(name, value);
    }

    public void removePersistentProperty(String name) {
        this.callBackIf_.removePersistentProperty(name);
    }

    public void addWebSite(String name, String protocol, int port, String keystorePath, String keystorePassword, String sslProvider) throws IOException, InstantiationException {
        String ksPath = keystorePath == null || keystorePath.trim().length() == 0 ? null : keystorePath.trim();
        String ksPass = keystorePassword == null || keystorePassword.trim().length() == 0 ? null : keystorePassword.trim();
        String sslProv = sslProvider == null || sslProvider.trim().length() == 0 ? null : sslProvider.trim();
        this.callBackIf_.addWebSite(name, protocol, port, ksPath, ksPass, sslProv);
        String oc4jName = this.getinstanceName();
        ObjectName oc4jProcMBeanPattern = null;
        String patternStr = "oc4j:type=OpmnProcOc4j,OpmnConfig=Singleton,name=" + oc4jName + ",*";
        try {
            oc4jProcMBeanPattern = new ObjectName(patternStr);
        }
        catch (MalformedObjectNameException e) {
            logger_.log(Level.WARNING, "can not create object name from string \"" + patternStr + "\"", e);
            return;
        }
        Set<ObjectName> mbeans = this.getMBeanServer().queryNames(oc4jProcMBeanPattern, null);
        if (mbeans.size() == 0) {
            return;
        }
        try {
            ObjectName procMBean = (ObjectName)mbeans.toArray()[0];
            Object[] params = new Object[]{name, Integer.toString(port), protocol};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            this.getMBeanServer().invoke(procMBean, "setPort", params, sigs);
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "update port for oc4j " + oc4jName + " in opmn.xml failed.", e);
            throw new InstantiationException(e.getMessage());
        }
        String oh = this.getoracleHome();
        this.syncLocalOpmnAndOpmnMBeans(oh, oc4jName);
    }

    private void syncLocalOpmnAndOpmnMBeans(String oh, String oc4jName) {
        try {
            ObjectName opmnMBean = new ObjectName("oc4j:type=OpmnConfig,name=Singleton");
            this.getMBeanServer().invoke(opmnMBean, "reloadOPMN", null, null);
            Class<?> cl = Class.forName("oracle.oc4j.admin.ias.runtime.TopologyUtil");
            Class[] paramTypes = new Class[]{String.class, String.class};
            Method methodSync = cl.getMethod("syncLocalOpmnMBeans", paramTypes);
            Object[] params = new Object[]{oh, oc4jName};
            methodSync.invoke(null, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger_.log(Level.WARNING, "invoke syncLocalOpmnAndOpmnMBeans fails: " + e.getMessage(), e);
        }
    }
}

