/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.jms.JMSUtils;
import java.net.InetAddress;
import java.util.Locale;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JMSRemoteServerMBean;

public class JMSRemoteServer
extends J2EEServerDependentObjectBase
implements JMSRemoteServerMBean {
    private String m_clientID;
    private String m_connectionID;
    private String m_user;
    private String m_cuser;
    private InetAddress m_addr;
    private int m_port;

    public JMSRemoteServer(String id, String user, InetAddress addr, int port) {
        this.m_user = user;
        this.m_addr = addr;
        this.m_port = port;
        this.setBaseObjectName(":j2eeType=JMSRemoteServerResource,name=" + ObjectNameUtil.quote((String)id) + ",JMSResource=" + ObjectNameUtil.quote((String)"JMS") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JMSRemoteServer(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("address", "java.net.InetAddress", this.getLocalizedMessage("jmsremoteserver_address"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("host", "java.lang.String", this.getLocalizedMessage("jmsremoteserver_host"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("port", "int", this.getLocalizedMessage("jmsremoteserver_port"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("user", "java.lang.String", this.getLocalizedMessage("jmsremoteserver_user"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("currentUser", "java.lang.String", this.getLocalizedMessage("jmsremoteserver_currentuser"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsremoteserver_clientid"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionID", "java.lang.String", this.getLocalizedMessage("jmsremoteserver_connectionid"), true, false, false));
    }

    public InetAddress getaddress() {
        return this.m_addr;
    }

    public InetAddress gethost() {
        return JMSUtils.normalize(this.m_addr);
    }

    public int getport() {
        return this.m_port;
    }

    public String getuser() {
        return this.m_user;
    }

    public void setcurrentUser(String user) {
        this.m_cuser = user;
    }

    public String getcurrentUser() {
        return this.m_cuser;
    }

    public void setclientID(String id) {
        this.m_clientID = id;
    }

    public String getclientID() {
        return this.m_clientID;
    }

    public void getconnectionID(String id) {
        this.m_connectionID = id;
    }

    public String getconnectionID() {
        return this.m_connectionID;
    }
}

