/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.CompositeData;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnConfigCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.OpmnComp;
import oracle.oc4j.admin.management.mbeans.OpmnCompMBean;
import oracle.oc4j.admin.management.mbeans.OpmnCompOc4jGroup;
import oracle.oc4j.admin.management.mbeans.OpmnConfigMBean;

public class OpmnConfig
extends J2EEServerDependentObjectBase
implements OpmnConfigMBean {
    private static Logger logger_ = TraceLogger.getLogger(OpmnConfig.class);
    OpmnConfigCallBackIf callBackIf_ = null;
    MBeanServer mbeanServer_ = null;
    ArrayList compMBeans_ = new ArrayList();

    protected MBeanServer getMyMBeanServer() {
        return this.mbeanServer_;
    }

    protected void setMyMBeanServer(MBeanServer server) {
        this.mbeanServer_ = server;
    }

    public OpmnConfig(OpmnConfigCallBackIf callBackIf, String domain, String j2eeServerName) {
        super(domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":type=OpmnConfig,name=" + this.callBackIf_.getname());
        this.init();
    }

    public OpmnConfig(OpmnConfigCallBackIf callBackIf) {
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":type=OpmnConfig,name=" + this.callBackIf_.getname());
        this.init();
    }

    public OpmnConfig(Locale loc) {
        super(loc);
        this.init();
    }

    protected OpmnConfig(String domain) {
        super(domain);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceOnUpdate = new HashMap<String, String>();
        persistenceOnUpdate.put("persistPolicy", "OnUpdate");
        HashMap<String, String> persistenceNever = new HashMap<String, String>();
        persistenceNever.put("persistPolicy", "Never");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("routingId", "java.lang.String", this.getLocalizedMessage("opmn_routingId"), true, true, false), persistenceOnUpdate);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("iasInstanceId", "java.lang.String", this.getLocalizedMessage("opmn_iasInstanceId"), true, false, false), persistenceNever);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("iasInstanceName", "java.lang.String", this.getLocalizedMessage("opmn_iasInstanceName"), true, false, false), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("store", "store configuration", null, "void", 1), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("reloadMBean", this.getLocalizedMessage("opmn_reloadMBean"), null, "void", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("reloadOPMN", this.getLocalizedMessage("opmn_reloadOPMN"), null, "void", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getComponents", this.getLocalizedMessage("opmn_getComponents"), null, "[Ljavax.management.ObjectName;", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getNotificationServerAttrs", this.getLocalizedMessage("opmn_getNotificationServerAttrs"), null, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("attrName", "java.lang.String", this.getLocalizedMessage("opmn_param_attrName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getNotificationServerAttr", this.getLocalizedMessage("opmn_getNotificationServerAttr"), params, "java.lang.String", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeNotificationServerAttr", this.getLocalizedMessage("opmn_removeNotificationServerAttr"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("attrName", "java.lang.String", this.getLocalizedMessage("opmn_param_attrName")), new MBeanParameterInfo("attrValue", "java.lang.String", this.getLocalizedMessage("opmn_param_attrValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setNotificationServerAttr", this.getLocalizedMessage("opmn_setNotificationServerAttr"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getNotificationServerSettings", this.getLocalizedMessage("opmn_getNotificationServerSettings"), null, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("opmn_param_NSSettingName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getNotificationServerSetting", this.getLocalizedMessage("opmn_getNotificationServerSetting"), params, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeNotificationServerSetting", this.getLocalizedMessage("opmn_removeNotificationServerSetting"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("opmn_param_NSSettingName")), new MBeanParameterInfo("data", "javax.management.openmbean.CompositeData", this.getLocalizedMessage("opmn_param_NSSettingData"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setNotificationServerSetting", this.getLocalizedMessage("opmn_setNotificationServerSetting"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getTopologies", this.getLocalizedMessage("opmn_getTopologies"), null, "javax.management.openmbean.CompositeData", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("opmn_param_topologyName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getTopology", this.getLocalizedMessage("opmn_getTopology"), params, "java.lang.String", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeTopology", this.getLocalizedMessage("opmn_removeTopology"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("opmn_param_topologyName")), new MBeanParameterInfo("value", "java.lang.String", this.getLocalizedMessage("opmn_param_topologyValue")), new MBeanParameterInfo("append", "boolean", this.getLocalizedMessage("opmn_param_topologyAppend"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setTopology", this.getLocalizedMessage("opmn_setTopology"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("groupName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jGroupName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("createOc4jGroup", this.getLocalizedMessage("opmn_createOc4jGroup"), params, "javax.management.ObjectName", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOc4jGroup", this.getLocalizedMessage("opmn_getOc4jGroup"), params, "javax.management.ObjectName", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeOc4jGroup", this.getLocalizedMessage("opmn_removeOc4jGroup"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOc4jGroups", this.getLocalizedMessage("opmn_getOc4jGroups"), null, "[Ljavax.management.ObjectName;", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOhsComponents", this.getLocalizedMessage("opmn_getOhsComponents"), null, "[Ljavax.management.ObjectName;", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("oc4jName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOc4jInstance", this.getLocalizedMessage("opmn_getOc4jInstance"), params, "javax.management.ObjectName", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getParameters", this.getLocalizedMessage("opmn_getParameters"), null, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("category", "java.lang.String", this.getLocalizedMessage("opmn_param_paramCategory")), new MBeanParameterInfo("paramName", "java.lang.String", this.getLocalizedMessage("opmn_param_paramName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getParameter", this.getLocalizedMessage("opmn_getParameter"), params, "java.lang.String", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeParameter", this.getLocalizedMessage("opmn_removeParameter"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("category", "java.lang.String", this.getLocalizedMessage("opmn_param_paramCategory")), new MBeanParameterInfo("paramName", "java.lang.String", this.getLocalizedMessage("opmn_param_paramName")), new MBeanParameterInfo("paramValue", "java.lang.String", this.getLocalizedMessage("opmn_param_paramValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setParameter", this.getLocalizedMessage("opmn_setParameter"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEnvironments", this.getLocalizedMessage("opmn_getEnvironments"), null, "[Ljavax.management.openmbean.CompositeData;", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("envName", "java.lang.String", this.getLocalizedMessage("opmn_param_envName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEnvironment", this.getLocalizedMessage("opmn_getEnvironment"), params, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeEnvironment", this.getLocalizedMessage("opmn_removeEnvironment"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("envName", "java.lang.String", this.getLocalizedMessage("opmn_param_envName")), new MBeanParameterInfo("envValues", "[Ljava.lang.String;", this.getLocalizedMessage("opmn_param_envValues")), new MBeanParameterInfo("append", "boolean", this.getLocalizedMessage("opmn_param_envAppend")), new MBeanParameterInfo("conversion", "boolean", this.getLocalizedMessage("opmn_param_envConversion"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addEnvironment", this.getLocalizedMessage("opmn_addEnvironment"), params, "void", 1), persistenceOnUpdate);
        params[1] = new MBeanParameterInfo("envValue", "java.lang.String", this.getLocalizedMessage("opmn_param_envValue"));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("appendEnvironment", this.getLocalizedMessage("opmn_appendEnvironment"), params, "void", 1), persistenceOnUpdate);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.mbeanServer_ = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        this.registerComponentMBeans();
    }

    protected void registerComponentMBeans() {
        OpmnCompCallBackIf[] comps = this.callBackIf_.getComponents();
        if (comps == null || comps.length == 0) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            try {
                OpmnComp mbean = this.registerComponentMBean(comps[i]);
                continue;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "register component mbean failed", e);
            }
        }
    }

    private OpmnComp registerComponentMBean(OpmnCompCallBackIf callBack) throws Exception {
        Class<?> mbeanCl = Class.forName(callBack.getMBeanClassName(), true, this.getClass().getClassLoader());
        Class[] argTypes = new Class[]{OpmnCompCallBackIf.class};
        Constructor<?> mbeanConst = mbeanCl.getConstructor(argTypes);
        Object[] args = new Object[]{callBack};
        OpmnComp mbean = (OpmnComp)mbeanConst.newInstance(args);
        this.registerComponentMBean(mbean);
        return mbean;
    }

    protected OpmnCompMBean registerComponentMBean(OpmnComp mbean) throws Exception {
        this.getMyMBeanServer().registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        this.compMBeans_.add(mbean);
        mbean.setParent(this);
        logger_.fine("reg comp: " + mbean.getObjectName());
        return mbean;
    }

    protected void unRegisterCompMBeans() {
        for (int i = this.compMBeans_.size() - 1; i >= 0; --i) {
            OpmnComp mbean = (OpmnComp)this.compMBeans_.get(i);
            this.unregisterCompMBean(mbean);
        }
    }

    protected void unregisterCompMBean(OpmnComp mbean) {
        try {
            this.getMyMBeanServer().unregisterMBean(mbean.getObjectName());
            this.compMBeans_.remove(mbean);
            logger_.fine("unreg comp:" + mbean.getObjectName());
        }
        catch (InstanceNotFoundException e1) {
            logger_.log(Level.WARNING, "unregister component mbean failed", e1);
        }
        catch (MBeanRegistrationException e2) {
            logger_.log(Level.WARNING, "unregister component mbean failed", e2);
        }
        catch (MalformedObjectNameException e3) {
            logger_.log(Level.WARNING, "unregister component mbean failed", e3);
        }
    }

    public String getDescription() {
        return this.getLocalizedMessage("opmn_OpmnConfig_desc");
    }

    public void store() {
        try {
            this.callBackIf_.store();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void reloadMBean() throws ConfigMBeanException {
        try {
            this.unRegisterCompMBeans();
            this.callBackIf_.reloadMBean();
            this.registerComponentMBeans();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new ConfigMBeanException(e);
        }
    }

    public void reloadOPMN() throws ConfigMBeanException {
        this.callBackIf_.reloadOPMN();
    }

    public ObjectName[] getComponents() throws ConfigMBeanException {
        if (this.compMBeans_ == null || this.compMBeans_.size() == 0) {
            return new ObjectName[0];
        }
        ObjectName[] names = new ObjectName[this.compMBeans_.size()];
        try {
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((OpmnComp)this.compMBeans_.get(i)).getObjectName();
            }
        }
        catch (MalformedObjectNameException mfe) {
            throw ConfigMBeanExceptionHelper.getException(2, mfe, JMXStateFactory.getJMXState().getLocale());
        }
        return names;
    }

    public CompositeData getNotificationServerAttrs() throws ConfigMBeanException {
        return this.callBackIf_.getNotificationServerAttrs();
    }

    public String getNotificationServerAttr(String attrName) throws ConfigMBeanException {
        return this.callBackIf_.getNotificationServerAttr(attrName);
    }

    public void setNotificationServerAttr(String attrName, String attrValue) throws ConfigMBeanException {
        this.callBackIf_.setNotificationServerAttr(attrName, attrValue);
    }

    public void removeNotificationServerAttr(String attrName) throws ConfigMBeanException {
        this.callBackIf_.removeNotificationServerAttr(attrName);
    }

    public CompositeData getNotificationServerSettings() throws ConfigMBeanException {
        return this.callBackIf_.getNotificationServerSettings();
    }

    public CompositeData getNotificationServerSetting(String name) throws ConfigMBeanException {
        return this.callBackIf_.getNotificationServerSetting(name);
    }

    public void setNotificationServerSetting(String name, CompositeData data) throws ConfigMBeanException {
        this.callBackIf_.setNotificationServerSetting(name, data);
    }

    public void removeNotificationServerSetting(String name) throws ConfigMBeanException {
        this.callBackIf_.removeNotificationServerSetting(name);
    }

    public CompositeData getTopologies() throws ConfigMBeanException {
        return this.callBackIf_.getTopologies();
    }

    public String getTopology(String name) throws ConfigMBeanException {
        return this.callBackIf_.getTopology(name);
    }

    public void setTopology(String name, String value, boolean append) throws ConfigMBeanException {
        this.callBackIf_.setTopology(name, value, append);
    }

    public void removeTopology(String name) throws ConfigMBeanException {
        this.callBackIf_.removeTopology(name);
    }

    public ObjectName createOc4jGroup(String groupName) throws ConfigMBeanException {
        OpmnCompCallBackIf callback = this.callBackIf_.createOc4jGroup(groupName);
        try {
            OpmnComp mbean = this.registerComponentMBean(callback);
            return mbean.getObjectName();
        }
        catch (ConfigMBeanException e1) {
            logger_.log(Level.SEVERE, "create oc4j group fails: " + groupName, e1);
            throw e1;
        }
        catch (Exception e2) {
            logger_.log(Level.SEVERE, "create oc4j group fails: " + groupName, e2);
            throw ConfigMBeanExceptionHelper.getException(53, groupName, (Throwable)e2, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public void removeOc4jGroup(String groupName) throws ConfigMBeanException {
        OpmnCompOc4jGroup grpMBean = null;
        for (int i = 0; i < this.compMBeans_.size(); ++i) {
            OpmnComp mbean = (OpmnComp)this.compMBeans_.get(i);
            if (!mbean.getname().equals(groupName)) continue;
            try {
                grpMBean = (OpmnCompOc4jGroup)mbean;
                break;
            }
            catch (ClassCastException e) {
                throw ConfigMBeanExceptionHelper.getException(52, groupName, JMXStateFactory.getJMXState().getLocale());
            }
        }
        if (grpMBean == null) {
            logger_.severe("couldn't find mbean for oc4j group " + groupName);
            throw ConfigMBeanExceptionHelper.getException(51, groupName, JMXStateFactory.getJMXState().getLocale());
        }
        if (this.callBackIf_.isOc4jGroupAlive(groupName)) {
            throw ConfigMBeanExceptionHelper.getException(74, groupName, JMXStateFactory.getJMXState().getLocale());
        }
        grpMBean.removeAllOc4js();
        this.callBackIf_.removeOc4jGroup(groupName);
        this.unregisterCompMBean(grpMBean);
    }

    private ObjectName[] getComponentObjectNames(String compType) {
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        for (int i = 0; i < this.compMBeans_.size(); ++i) {
            OpmnComp mbean = (OpmnComp)this.compMBeans_.get(i);
            try {
                ObjectName objectName = mbean.getObjectName();
                String type = objectName.getKeyProperty("type");
                if (!compType.equals(type)) continue;
                list.add(objectName);
                continue;
            }
            catch (MalformedObjectNameException mone) {
                logger_.log(Level.WARNING, "malformed object name at getComponentObjectNames()", mone);
            }
        }
        ObjectName[] result = new ObjectName[list.size()];
        list.toArray(result);
        return result;
    }

    public ObjectName[] getOc4jGroups() {
        return this.getComponentObjectNames("OpmnCompOc4jGroup");
    }

    public ObjectName getOc4jGroup(String groupName) throws ConfigMBeanException {
        ObjectName[] grpNames = this.getOc4jGroups();
        for (int i = 0; i < grpNames.length; ++i) {
            String name = grpNames[i].getKeyProperty("name");
            if (!name.equals(groupName)) continue;
            return grpNames[i];
        }
        return null;
    }

    public ObjectName[] getOhsComponents() {
        return this.getComponentObjectNames("OpmnCompOhs");
    }

    public ObjectName getOc4jInstance(String oc4jName) throws ConfigMBeanException {
        try {
            ObjectName appPatternObj = ObjectNameFactory.create((String)("*:type=OpmnProcOc4j,name=" + oc4jName + ",*"));
            Set<ObjectName> childs = this.getMyMBeanServer().queryNames(appPatternObj, null);
            if (childs.size() == 0) {
                return null;
            }
            return (ObjectName)childs.toArray()[0];
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public CompositeData getParameters() {
        return this.callBackIf_.getParameters();
    }

    public String getParameter(String category, String paramName) throws ConfigMBeanException {
        return this.callBackIf_.getParameter(category, paramName);
    }

    public void setParameter(String category, String paramName, String paramValue) throws ConfigMBeanException {
        this.callBackIf_.setParameter(category, paramName, paramValue);
    }

    public void removeParameter(String category, String paramName) throws ConfigMBeanException {
        this.callBackIf_.removeParameter(category, paramName);
    }

    public CompositeData[] getEnvironments() {
        return this.callBackIf_.getEnvironments();
    }

    public CompositeData getEnvironment(String envName) throws ConfigMBeanException {
        return this.callBackIf_.getEnvironment(envName);
    }

    public void addEnvironment(String envName, String[] envValues, boolean append, boolean conversion) throws ConfigMBeanException {
        this.callBackIf_.addEnvironment(envName, envValues, append, conversion);
    }

    public void appendEnvironment(String envName, String envValue, boolean append, boolean conversion) throws ConfigMBeanException {
        this.callBackIf_.appendEnvironment(envName, envValue, append, conversion);
    }

    public void removeEnvironment(String envName) throws ConfigMBeanException {
        this.callBackIf_.removeEnvironment(envName);
    }

    public String getiasInstanceId() {
        return this.callBackIf_.getiasInstanceId();
    }

    public String getiasInstanceName() {
        return this.callBackIf_.getiasInstanceName();
    }

    public String getroutingId() {
        try {
            return this.getParameter("start-parameters", "routing-id");
        }
        catch (ConfigMBeanException e) {
            logger_.log(Level.SEVERE, "get ias-instance routing-id failed", e);
            return null;
        }
    }

    public void setroutingId(String routingId) throws ConfigMBeanException {
        this.setParameter("start-parameters", "routing-id", routingId);
    }

    public OpmnComp getCompMBean(String compId) {
        OpmnComp compMBean = null;
        for (int i = 0; i < this.compMBeans_.size(); ++i) {
            OpmnComp mbean = (OpmnComp)this.compMBeans_.get(i);
            if (!mbean.getname().equals(compId)) continue;
            compMBean = mbean;
            break;
        }
        return compMBean;
    }

    protected Iterator getCompMBeans() {
        return this.compMBeans_.iterator();
    }
}

