/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.evermind.server.auth.OC4JPrincipal;
import com.evermind.util.IIOPProperties;
import com.evermind.util.OC4JRuntimeProperties;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.iiop.CommonCSIV2TaggedComponentInfo;
import oracle.oc4j.corba.iiop.security.ConnectionContext;
import oracle.oc4j.corba.iiop.security.ConnectionExecutionContext;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.iiop.security.InvalidIdentityTokenException;
import oracle.oc4j.corba.iiop.security.InvalidMechanismException;
import oracle.oc4j.corba.iiop.security.SecurityContext;
import oracle.oc4j.corba.iiop.security.SecurityMechanismException;
import oracle.oc4j.corba.iiop.server.ComponentInvocation;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import org.omg.CORBA.ORB;

public class ClientSecurityMechanismSelector {
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    protected static boolean useSSL = false;
    protected CompoundSecMech mech = null;
    protected CommonCSIV2TaggedComponentInfo ctc = null;
    protected ORB orb = null;
    protected static String nameServiceKey;
    private boolean initialized = false;
    protected static final String SECURE_PROPERTIES = "ejb_sec.properties";
    public static final String OC4J_IIOP_KEYSTORELOC_PROP = "oc4j.iiop.keyStoreLoc";
    public static final String OC4J_IIOP_KEYSTOREPASS_PROP = "oc4j.iiop.keyStorePass";
    public static final String OC4J_IIOP_TRUSTSTORELOC_PROP = "oc4j.iiop.trustStoreLoc";
    public static final String OC4J_IIOP_TRUSTSTOREPASS_PROP = "oc4j.iiop.trustStorePass";
    public static final String OC4J_IIOP_ENABLE_CLIENTAUTH_PROP = "oc4j.iiop.enable.clientauth";
    public static final String OC4J_IIOP_CIPHERSUITES_PROP = "oc4j.iiop.ciphersuites";
    public static final String NAMESERVICE_USESSL_PROP = "nameservice.useSSL";
    public static final String CLIENT_SENDPASSWORD_PROP = "client.sendpassword";
    public static final String OC4J_IIOP_TRUSTEDSERVERS_PROP = "oc4j.iiop.trustedServers";
    protected String keyStoreLoc;
    protected String keyStorePass;
    protected String trustStoreLoc;
    protected String trustStorePass;
    protected boolean enableClientAuth;
    protected String cipherSuites;
    protected boolean nameServiceUseSSL;
    protected boolean sendPassword;
    protected String[] trustedServers = null;
    protected static final String ANONYMOUS_USER_NAME = "Anonymous";
    private static final String PASSWORD_AUTHENTICATION_KEY = "Client:PA:Tuple";
    static final PasswordAuthentication EMPTY_PA;

    public ClientSecurityMechanismSelector() {
        if (!this.initialized) {
            block6: {
                Properties props = new Properties();
                try {
                    FileInputStream fis;
                    String spf = System.getProperty("ejb_sec_properties_location");
                    if (spf == null) {
                        spf = this.getEjbSecPropertiesFileLocation();
                    }
                    if (spf == null) break block6;
                    try {
                        File secFile = new File(spf);
                        fis = new FileInputStream(secFile);
                    }
                    catch (FileNotFoundException e) {
                        File secFile = new File(SECURE_PROPERTIES);
                        fis = new FileInputStream(secFile);
                    }
                    props.load(fis);
                    fis.close();
                    this.setUp(props);
                }
                catch (IOException e) {
                    CSIV2Messages.finerThrowableNoMsg(e);
                }
            }
            this.initialized = true;
        }
    }

    void setUp(Properties props) {
        String falseString = "false";
        this.keyStoreLoc = props.getProperty(OC4J_IIOP_KEYSTORELOC_PROP);
        this.keyStorePass = props.getProperty(OC4J_IIOP_KEYSTOREPASS_PROP);
        this.trustStoreLoc = props.getProperty(OC4J_IIOP_TRUSTSTORELOC_PROP);
        this.trustStorePass = props.getProperty(OC4J_IIOP_TRUSTSTOREPASS_PROP);
        this.enableClientAuth = new Boolean(props.getProperty(OC4J_IIOP_ENABLE_CLIENTAUTH_PROP, falseString).trim());
        this.cipherSuites = props.getProperty(OC4J_IIOP_CIPHERSUITES_PROP);
        this.nameServiceUseSSL = new Boolean(props.getProperty(NAMESERVICE_USESSL_PROP, falseString).trim());
        this.sendPassword = new Boolean(props.getProperty(CLIENT_SENDPASSWORD_PROP, falseString).trim());
        String temp = props.getProperty(OC4J_IIOP_TRUSTEDSERVERS_PROP);
        if (!ClientSecurityMechanismSelector.isEmpty(temp)) {
            this.trustedServers = ClientSecurityMechanismSelector.stringToArray(temp, ",");
        }
    }

    private static boolean isEmpty(String string) {
        boolean retVal = true;
        retVal = string == null ? true : string.trim().length() == 0;
        return retVal;
    }

    protected String getEjbSecPropertiesFileLocation() {
        return OC4JRuntimeProperties.getJ2eeHomeDir() + File.separator + "config" + File.separator + SECURE_PROPERTIES;
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public Object getSSLPort(Object ior, ConnectionContext ctx) {
        Object info = null;
        try {
            this.mech = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(this.mech);
        if (this.mech == null) {
            return null;
        }
        TLS_SEC_TRANS ssl = this.ctc.getSSLInformation(this.mech);
        if (ssl == null) {
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (this.isSet(targetRequires, 2) || this.isSet(targetRequires, 4) || this.isSet(targetRequires, 64)) {
            CSIV2Messages.finestMsg("Target requires SSL");
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (this.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            short ssl_port = ssl.addresses[0].port;
            String host_name = ssl.addresses[0].host_name;
            info = OrbManager.createEndPointInfo(type, ssl_port, host_name);
            return info;
        }
        if (this.isSet(targetSupports, 2) || this.isSet(targetSupports, 4) || this.isSet(targetSupports, 64)) {
            CSIV2Messages.finestMsg("Target supports SSL");
            if (this.clientPrefersSSL()) {
                CSIV2Messages.finestMsg("Client is configured to use SSL for the target");
                ctx.setSSLUsed(true);
                String host_name = ssl.addresses[0].host_name;
                short ssl_port = ssl.addresses[0].port;
                info = OrbManager.createEndPointInfo("SSL", ssl_port, host_name);
                return info;
            }
            return null;
        }
        return null;
    }

    public CompoundSecMech selectSecurityMechanism(Object ior) throws SecurityMechanismException {
        if (this.ctc == null) {
            this.init(true);
        }
        CompoundSecMech[] mechList = this.ctc.getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    public SecurityContext selectSecurityContext() throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        ConnectionContext cc = this.getClientConnectionContext();
        if (cc == null) {
            return null;
        }
        this.mech = cc.getMechanism();
        if (this.mech == null) {
            return null;
        }
        boolean sslUsed = cc.getSSLUsed();
        boolean clientAuthOccurred = cc.getSSLClientAuthenticationOccurred();
        CSIV2Messages.finestMsg("SSL used:" + sslUsed + " SSL Mutual auth:" + clientAuthOccurred);
        return this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred);
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        if (!sslUsed) {
            ctx = this.sendUsernameAndPassword(plainIIOP, ci, clientAuthOccurred);
        } else if (!clientAuthOccurred) {
            plainIIOP = false;
            ctx = this.sendUsernameAndPassword(plainIIOP, ci, clientAuthOccurred);
        } else {
            return null;
        }
        return ctx;
    }

    private SecurityContext sendUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci, boolean clientAuthOccurred) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mech == null) {
            return null;
        }
        AS_ContextSec asContext = this.mech.as_context_mech;
        if (!(this.isSet(asContext.target_requires, 64) || this.isSet(this.mech.target_requires, 64) && !clientAuthOccurred)) {
            return null;
        }
        ctx = this.setUsernameAndPassword(plainIIOP, ci);
        CSIV2Messages.finestMsg("Sending Username/Password");
        return ctx;
    }

    protected SecurityContext setUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.isServerTrusted()) {
            if (plainIIOP && this.sendPassword || !plainIIOP) {
                ctx = this.getUsernameAndPassword(ci);
            } else {
                String msg = "Cannot send authentication information because ";
                msg = plainIIOP && !this.sendPassword ? msg + " client policy does not allow password to " + " be sent over plain IIOP" : msg + " client does not trust the server " + " to send password over IIOP";
                CSIV2Messages.finestMsg(msg);
                throw new SecurityMechanismException(msg);
            }
        }
        return ctx;
    }

    private boolean isServerTrusted() {
        String star = "*";
        if (this.trustedServers == null) {
            return false;
        }
        for (int i = 0; i < this.trustedServers.length; ++i) {
            if (this.trustedServers[i].length() != 1 || !this.trustedServers[i].equals(star)) continue;
            return true;
        }
        ConnectionContext scc = this.getClientConnectionContext();
        if (scc != null) {
            Socket skt = scc.getSocket();
            InetAddress adr = skt.getInetAddress();
            return this.isDomainInTrustedList(adr, this.trustedServers);
        }
        return false;
    }

    protected boolean isDomainInTrustedList(InetAddress inetAddress, String[] trusted) throws SecurityException {
        boolean isTrusted = false;
        String domain = null;
        String ipAddr = null;
        String star = "*";
        String dot = ".";
        try {
            domain = inetAddress.getHostName();
            ipAddr = inetAddress.getHostAddress();
        }
        catch (Exception e) {
            System.err.println(" Could not lookup the domain name of IP  address = " + inetAddress.getHostAddress());
            return false;
        }
        CSIV2Messages.finestMsg("Verifying if domain address =\" )+ inetAddress.toString() +\n                \" is in the Trusted list " + "" + " the domain name is = \" + domain" + " IP is = \" + ipAddr");
        String[] domainTok = ClientSecurityMechanismSelector.stringToArray(domain, dot);
        for (int i = 0; i < trusted.length; ++i) {
            if (ipAddr.equals(trusted[i])) {
                return true;
            }
            String[] toksList = ClientSecurityMechanismSelector.stringToArray(trusted[i], dot);
            if (toksList.length == 1 && toksList[0].equals(domainTok[0])) {
                return true;
            }
            if (toksList.length != domainTok.length) {
                isTrusted = false;
                continue;
            }
            for (int j = toksList.length - 1; j >= 0; --j) {
                if (toksList[j].equals(domainTok[j])) {
                    isTrusted = true;
                    continue;
                }
                if (toksList[j].equals(star)) {
                    isTrusted = true;
                    continue;
                }
                isTrusted = false;
                break;
            }
            if (!isTrusted) continue;
            return isTrusted;
        }
        return isTrusted;
    }

    public static String[] stringToArray(String from, String separator) {
        if (from == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringTokenizer toks = new StringTokenizer(from, separator);
        String[] result = new String[toks.countTokens()];
        int i = 0;
        while (toks.hasMoreTokens()) {
            result[i++] = toks.nextToken().trim();
        }
        return result;
    }

    protected SecurityContext getUsernameAndPassword(ComponentInvocation ci) {
        try {
            Subject s = this.getJndiSubject();
            CSIV2Messages.finestMsg("SUBJECT:" + s);
            SecurityContext ctx = new SecurityContext();
            final Subject sub = s;
            ctx.subject = s;
            Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            if (privateCredSet.isEmpty()) {
                CSIV2Messages.finestMsg("no private credential run as mode");
                ctx.authcls = null;
                ctx.identcls = GSSUPName.class;
            } else {
                ctx.authcls = PasswordCredential.class;
            }
            return ctx;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Subject getJndiSubject() {
        PasswordAuthentication pa = ClientSecurityMechanismSelector.getUserPassTuple();
        return ClientSecurityMechanismSelector.createJndiSubject(pa.getUserName(), new String(pa.getPassword()), IIOPProperties.getSecurityRealm());
    }

    public static PasswordAuthentication getUserPassTuple() {
        Hashtable h = ConnectionExecutionContext.getContext();
        if (h.get(PASSWORD_AUTHENTICATION_KEY) == null) {
            return EMPTY_PA;
        }
        return (PasswordAuthentication)h.get(PASSWORD_AUTHENTICATION_KEY);
    }

    public static void setUserPassTuple(PasswordAuthentication pa) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(PASSWORD_AUTHENTICATION_KEY, pa);
    }

    boolean isJndiCredentialAvailable() {
        if (ClientSecurityMechanismSelector.getUserPassTuple() != null) {
            String user = ClientSecurityMechanismSelector.getUserPassTuple().getUserName();
            String pass = new String(ClientSecurityMechanismSelector.getUserPassTuple().getPassword());
            if (user != null && user.trim().length() > 0) {
                return true;
            }
        }
        return false;
    }

    static Subject createJndiSubject(String userName, String password, String realm) {
        final Subject s = new Subject();
        if (ClientSecurityMechanismSelector.isEmpty(userName)) {
            return s;
        }
        if (userName != null) {
            s.getPrincipals().add(new OC4JPrincipal(userName));
        }
        if (password != null) {
            Set credSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return s.getPrivateCredentials();
                }
            });
            credSet.add(new PasswordCredential(userName, password, realm));
        }
        return s;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        for (int i = 0; i < mechList.length; ++i) {
            mech = mechList[i];
            boolean useMech = this.useMechanism(mech);
            if (!useMech) continue;
            return mech;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.ctc.getSSLInformation(mech);
        if (tls == null) {
            return true;
        }
        short targetRequires = tls.target_requires;
        if (this.isSet(targetRequires, 64) && ClientSecurityMechanismSelector.isClientKeyStoreAvailable()) {
            val = false;
        }
        return val;
    }

    public static boolean isClientKeyStoreAvailable() {
        String keyfile = IIOPProperties.getComOracleClientKeyStore();
        File f = new File(keyfile);
        return f.exists();
    }

    private boolean clientPrefersSSL() {
        return this.nameServiceUseSSL;
    }

    protected boolean isServerInvocation() {
        return false;
    }

    protected boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    protected void init(boolean orbInitialized) {
        if (orbInitialized) {
            this.orb = OrbManager.getClientOrb();
            this.ctc = new CommonCSIV2TaggedComponentInfo(this.orb);
        }
    }

    static {
        EMPTY_PA = new PasswordAuthentication("", "".toCharArray());
    }
}

