/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.server.ejb.logging.EJBIiopMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import oracle.oc4j.corba.ServerOrbManager;
import oracle.oc4j.corba.naming.ApplicationClientNamingContext;
import oracle.oc4j.corba.transport.AbstractReferenceGenerator;
import oracle.oc4j.corba.transport.BaseServantLocator;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.corba.transport.ORBSystemException;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;

class HomeReferenceGenerator
extends AbstractReferenceGenerator {
    private POA m_homePoa = null;
    private String m_applicationName;
    private List boundHomes;

    HomeReferenceGenerator(POA rootPoa, POAPolicyCreationStrategy policyStrategy, CorbaEJBHome home) throws ORBInitializationException {
        try {
            Policy[] policies = this.createPOAPolicies(home, rootPoa, policyStrategy);
            this.m_applicationName = home.getApplicationName();
            this.m_homePoa = this.createPOA("oc4j.ejb.home." + this.m_applicationName, rootPoa, policies);
            this.m_homePoa.the_POAManager().activate();
            this.boundHomes = new ArrayList();
        }
        catch (ORBConfigurationException e) {
            throw new ORBInitializationException(e);
        }
        catch (AdapterInactive adapterInactive) {
            throw new ORBInitializationException(adapterInactive);
        }
        this.setServantLocator(this.m_homePoa, new HomeServantLocator());
    }

    EJBHome getHomeReference(CorbaEJBHome homeSupport) {
        return homeSupport.getHomeReference();
    }

    boolean isIdentical(EJBHome clientReference, CorbaEJBHome ejbHome) {
        if (!(clientReference instanceof Object)) {
            return false;
        }
        return this.equivalentCORBAObjects(ejbHome.getHomeReference(), clientReference);
    }

    void deploy(CorbaEJBHome home) throws ORBInitializationException {
        Servant servant = this.createServantForHomeWrapper(home);
        home.setHomeServant(servant);
        home.setHomeReference(this.createHomeObjectReference(home, servant));
    }

    private EJBHome createHomeObjectReference(CorbaEJBHome home, Servant servant) throws ORBInitializationException {
        try {
            EJBObjectID objectID = new EJBObjectID(home.getApplicationName(), home.getLocation());
            Object obj = this.m_homePoa.create_reference_with_id(objectID.toByteArray(), this.getRepositoryID(servant));
            this.bindHomeReference(home, obj);
            return this.narrowToEjbHome(obj, home);
        }
        catch (Exception e) {
            EJBIiopMessages.severeUnableToCreateHomeReference(home, e);
            throw new ORBInitializationException(e.getMessage());
        }
    }

    private void bindHomeReference(CorbaEJBHome home, Object obj) throws org.omg.CORBA.ORBPackage.InvalidName, ORBConfigurationException, NotFound, CannotProceed, InvalidName {
        try {
            NamingContext rootContext = NamingContextHelper.narrow((Object)ServerOrbManager.getOrb().resolve_initial_references("NameService"));
            NameComponent[] name = new NameComponent[]{new NameComponent(home.getLocation(), "")};
            NamingContext appContext = this.getCorbaApplicationContext(rootContext);
            appContext.rebind(name, obj);
            this.boundHomes.add(name);
        }
        catch (OBJECT_NOT_EXIST e) {
            EJBIiopMessages.severeUnableToRegisterHome(home, (Exception)((java.lang.Object)e));
        }
    }

    private void unbindApplication() throws org.omg.CORBA.ORBPackage.InvalidName, ORBConfigurationException, NotFound, CannotProceed, InvalidName {
        try {
            NamingContext rootContext = NamingContextHelper.narrow((Object)ServerOrbManager.getOrb().resolve_initial_references("NameService"));
            NameComponent[] name = new NameComponent[]{new NameComponent(this.m_applicationName, "")};
            rootContext.unbind(name);
        }
        catch (OBJECT_NOT_EXIST e) {
            EJBIiopMessages.severeUnableToUnregisterHomes(this.m_applicationName, (Exception)((java.lang.Object)e));
        }
    }

    private void unbindApplicationContext() throws org.omg.CORBA.ORBPackage.InvalidName, ORBConfigurationException, NotFound, CannotProceed, InvalidName {
        NamingContext rootContext = NamingContextHelper.narrow((Object)ServerOrbManager.getOrb().resolve_initial_references("NameService"));
        NamingContext appContext = this.getCorbaApplicationContext(rootContext);
        if (appContext instanceof ApplicationClientNamingContext) {
            return;
        }
        Iterator it = this.boundHomes.iterator();
        while (it.hasNext()) {
            try {
                NameComponent[] boundHomeName = (NameComponent[])it.next();
                appContext.unbind(boundHomeName);
            }
            catch (OBJECT_NOT_EXIST e) {
                EJBIiopMessages.severeUnableToUnregisterHomes(this.m_applicationName, (Exception)((java.lang.Object)e));
            }
            catch (NotFound e) {
                EJBIiopMessages.severeUnableToUnregisterHomes(this.m_applicationName, (Exception)((java.lang.Object)e));
            }
        }
        this.boundHomes = null;
    }

    private NamingContext getCorbaApplicationContext(NamingContext rootContext) throws CannotProceed, InvalidName, NotFound {
        NamingContext appContext;
        NameComponent[] name = new NameComponent[]{new NameComponent(this.m_applicationName, "")};
        try {
            appContext = NamingContextHelper.narrow((Object)rootContext.resolve(name));
        }
        catch (NotFound notFound) {
            appContext = rootContext.new_context();
            try {
                rootContext.bind_context(name, appContext);
            }
            catch (AlreadyBound alreadyBound) {
                throw new ORBSystemException(alreadyBound);
            }
        }
        return appContext;
    }

    private Servant createServantForHomeWrapper(CorbaEJBHome home) throws ORBInitializationException {
        return this.createServantForWrapper(home);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBHome narrowToEjbHome(java.lang.Object obj, CorbaEJBHome home) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(home.getHomeClassName(), true, home.getClassLoader());
        this.setEjbContextContainerForThread(home);
        try {
            EJBHome eJBHome = (EJBHome)PortableRemoteObject.narrow((java.lang.Object)obj, clazz);
            return eJBHome;
        }
        finally {
            this.unsetEjbContextContainerForThread();
        }
    }

    public void undeploy() {
        try {
            this.unbindApplicationContext();
            this.unbindApplication();
            this.m_homePoa.destroy(false, true);
        }
        catch (UserException e) {
            EJBIiopMessages.warningErrorUndeployingApplication(this.m_applicationName, (Exception)((java.lang.Object)e));
        }
    }

    class HomeServantLocator
    extends BaseServantLocator {
        HomeServantLocator() {
        }

        protected Servant getSelectedServant(CorbaEJBHome home, EJBObjectID objectID) {
            return home.getHomeServant();
        }
    }
}

