/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.config.xml;

import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.oc4j.configuration.XMLSerializable;
import oracle.oc4j.loader.config.ImportSharedLibraryType;
import oracle.oc4j.loader.config.xml.ComparisonUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class ImportSharedLibraryElement
implements ImportSharedLibraryType,
XMLSerializable {
    private String name;
    private String minVersion;
    private String maxVersion;
    private boolean optional;

    public ImportSharedLibraryElement() {
    }

    public ImportSharedLibraryElement(String name, String minVersion, String maxVersion) {
        this(name, minVersion, maxVersion, false);
    }

    public ImportSharedLibraryElement(String name, String minVersion, String maxVersion, boolean optional) {
        this.name = name;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.optional = optional;
    }

    public boolean equals(Object other) {
        try {
            ImportSharedLibraryElement it = (ImportSharedLibraryElement)other;
            if (!ComparisonUtils.equal(this.name, it.name)) {
                return false;
            }
            if (!ComparisonUtils.equal(this.minVersion, it.minVersion)) {
                return false;
            }
            return ComparisonUtils.equal(this.maxVersion, it.maxVersion);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String version) {
        this.minVersion = version;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String version) {
        this.maxVersion = version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void read(Node node) throws DOMException {
        this.name = XMLUtils.getNodeAttribute(node, "name");
        this.minVersion = XMLUtils.getNodeAttribute(node, "min-version");
        this.maxVersion = XMLUtils.getNodeAttribute(node, "max-version");
        this.optional = XMLUtils.getBooleanNodeAttribute(node, "optional") == 1;
    }

    public void write(PrintWriter out, String indent) throws IOException {
        out.print(indent);
        out.print("<import-shared-library name=\"" + this.name + "\"");
        if (this.minVersion != null) {
            out.print(" min-version=\"" + this.minVersion + "\"");
        }
        if (this.maxVersion != null) {
            out.print(" max-version=\"" + this.maxVersion + "\"");
        }
        if (this.optional) {
            out.print(" optional=\"true\"");
        }
        out.println("/>");
    }
}

