/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.network;

import com.evermind.util.DoubleLinkedListNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import oracle.oc4j.network.ServerSocketAcceptHandler;
import oracle.oc4j.network.ServerSocketDriver;

public class ServerSocketReadHandler
implements Runnable {
    ServerSocketAcceptHandler acceptHandler;
    private Socket realSocket;
    private SSLSocket sslSocket;
    private long idleExpiredTime;
    private DoubleLinkedListNode idleDLLNode = new IdleNode();
    private Runnable safeRunnable = new SafeRunnable();
    private boolean moreRequest;
    private boolean endRunInvoked = false;
    private InputStream socketIS;
    private OutputStream socketOS;

    public void beforeCaching() {
        this.realSocket = null;
        this.sslSocket = null;
        this.socketIS = null;
        this.socketOS = null;
    }

    public void clearFieldsForGC() {
        this.realSocket = null;
        this.sslSocket = null;
        this.socketIS = null;
        this.socketOS = null;
        this.safeRunnable = null;
        this.idleDLLNode = null;
    }

    public void bindAcceptHandler(ServerSocketAcceptHandler handler) {
        this.acceptHandler = handler;
    }

    public void setSockets(Socket _socket, SSLSocket _sslSocket) throws IOException {
        this.realSocket = _socket;
        this.sslSocket = _sslSocket;
        try {
            this.socketIS = this.getSocket().getInputStream();
            this.socketOS = this.getSocket().getOutputStream();
        }
        catch (IOException e) {
            if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                ServerSocketDriver.logger.log(Level.WARNING, "Cannot get socket input and output streams", e);
            }
            throw e;
        }
    }

    protected Socket getSocket() {
        return this.sslSocket != null ? this.sslSocket : this.realSocket;
    }

    protected void initReadHandler() {
    }

    protected Socket getAcceptedSocket() {
        return this.realSocket;
    }

    public void run() {
        block2: {
            try {
                this.getOutputStream().write("Default ReadHandler invoked".getBytes());
                this.getOutputStream().flush();
                this.endRun(false);
            }
            catch (Exception e) {
                if (!ServerSocketDriver.logger.isLoggable(Level.FINE)) break block2;
                ServerSocketDriver.logger.log(Level.FINE, "IOException in ServerSocketReadHandler:run", e);
            }
        }
    }

    public void endRun(boolean moreRequest) {
        if (this.endRunInvoked) {
            return;
        }
        this.moreRequest = moreRequest;
        this.endRunInvoked = true;
        if (!moreRequest) {
            this.acceptHandler.noExCloseSocket(this.getSocket(), "close the socket", Level.WARNING);
        }
    }

    protected InputStream getInputStream() throws IOException {
        return this.socketIS;
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.socketOS;
    }

    public ServerSocketAcceptHandler getAcceptHandler() {
        return this.acceptHandler;
    }

    SocketChannel getChannel() {
        return this.realSocket.getChannel();
    }

    public boolean waitTooLongREAD_OP() {
        return this.waitTooLongREAD_OP(System.currentTimeMillis());
    }

    public boolean waitTooLongREAD_OP(long current) {
        if (this.acceptHandler.getIdleSocketTimeout() == 0L) {
            return false;
        }
        return current >= this.idleExpiredTime;
    }

    void onRegisterForRead() {
        this.idleExpiredTime = System.currentTimeMillis() + this.acceptHandler.getIdleSocketTimeout();
    }

    public DoubleLinkedListNode getIdleDLLNode() {
        return this.idleDLLNode;
    }

    public void bindSocket() throws Exception {
    }

    public void unbindSocket() {
    }

    public void bindThread() throws Exception {
    }

    public void unbindThread() {
    }

    void removeImmediate() {
        block4: {
            try {
                if (!this.realSocket.isClosed()) {
                    this.endRun(false);
                }
                if (this.acceptHandler.isIdleTimeoutNeeded()) {
                    this.acceptHandler.removeFromIdle(this);
                }
            }
            catch (Throwable e) {
                if (!ServerSocketDriver.logger.isLoggable(Level.FINE)) break block4;
                ServerSocketDriver.logger.log(Level.FINE, "IOException in ServerSocketReadHandler:removeImmediate", e);
            }
        }
    }

    Runnable getSafeRunnable() {
        return this.safeRunnable;
    }

    public class SafeRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ServerSocketReadHandler.this.moreRequest = false;
                ServerSocketReadHandler.this.endRunInvoked = false;
                ServerSocketReadHandler.this.bindThread();
                ServerSocketReadHandler.this.run();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    ServerSocketReadHandler.this.unbindThread();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    if (!ServerSocketReadHandler.this.endRunInvoked) {
                        ServerSocketReadHandler.this.endRun(false);
                    }
                    ServerSocketReadHandler.this.acceptHandler.endReadHandlerRun(ServerSocketReadHandler.this.moreRequest, ServerSocketReadHandler.this, ServerSocketReadHandler.this.acceptHandler.getIdleSocketTimeout());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public class IdleNode
    extends DoubleLinkedListNode {
        public Object getRealNode() {
            return ServerSocketReadHandler.this;
        }
    }
}

