/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import com.evermind.server.ApplicationServer;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.administration.HttpSessionRuntimeInfo;
import com.evermind.util.ErrorHandler;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.oc4j.query.AbstractWatchedSession;
import oracle.oc4j.query.HttpSessionsUtils;
import oracle.oc4j.query.IdlestWatchedSession;
import oracle.oc4j.query.LargestWatchedSession;
import oracle.oc4j.query.OldestWatchedSession;
import oracle.oc4j.query.WatchedSession;
import oracle.oc4j.query.YoungestWatchedSession;

public class HttpSessions
extends ReportQuery
implements ErrorHandler {
    int totalAttributes = 0;
    int totalSessions = 0;
    long totalSize = 0L;
    boolean showAttributes = true;
    final boolean showErrors = false;
    DateFormat formatter = DateFormat.getDateTimeInstance();

    public String getDescription() {
        String firstPartDesc = "List all the active HttpSessions for deployed applications.\n";
        String secondPartDesc = "\"Args[verbose]:\\n\\n \" \n  verbose - displays the attributes from each HttpSession.\n";
        if (ClassLoadEnvironment.ORACLE_DOMAIN) {
            return firstPartDesc + secondPartDesc;
        }
        return firstPartDesc;
    }

    public void createQueryReport(String[] args) throws Exception {
        long timeStamp = System.currentTimeMillis();
        this.showAttributes = args.length > 0 && args[0].equalsIgnoreCase("verbose") && ClassLoadEnvironment.ORACLE_DOMAIN;
        this.doDetailReport(timeStamp);
        StringBuffer summary = this.doSummary(timeStamp);
        StringBuffer report = this.getReportBuffer();
        report.insert(0, summary.toString());
    }

    protected StringBuffer doSummary(long timeStamp) {
        StringBuffer miniIndent = new StringBuffer("  ");
        StringBuffer newLine = new StringBuffer("\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append(newLine).append("** Summary at ").append(this.formatter.format(new Date(timeStamp))).append(" **").append(newLine).append(newLine).append(miniIndent).append("Total Sessions: ").append(this.totalSessions).append(newLine).append(miniIndent).append("Total Attributes: ").append(this.totalAttributes).append(newLine).append(miniIndent).append("Total Session Size: ").append(this.totalSize).append(" bytes").append(newLine);
        Map watchedSessions = this.seekSummarySessions(timeStamp);
        Set keySet = watchedSessions.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            buffer.append(newLine);
            String key = (String)iterator.next();
            WatchedSession watchedSession = (WatchedSession)watchedSessions.get(key);
            buffer.append(miniIndent).append(key).append(" Session: ").append(watchedSession);
        }
        return buffer;
    }

    void doDetailReport(long timeStamp) {
        this.appendln();
        this.appendln();
        this.appendln("** Details **");
        this.appendln();
        try {
            HttpServer httpServer = this.getHttpServer();
            List httpSites = this.getHttpWebSites(httpServer);
            Iterator iter = httpSites.iterator();
            while (iter.hasNext()) {
                HttpSite httpSite = (HttpSite)iter.next();
                this.inspectApplicationsForSite(httpSite, timeStamp);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            super.append((Object)e);
        }
    }

    void inspectApplicationsForSite(HttpSite site, long timeStamp) {
        SortedMap applications = this.getApplicationsFromSite(site);
        Iterator iter = applications.keySet().iterator();
        while (iter.hasNext()) {
            String applicationName = (String)iter.next();
            HttpApplication application = (HttpApplication)applications.get(applicationName);
            this.append("[");
            this.append(applicationName);
            this.appendln("]");
            this.appendln();
            this.inspectHttpSessions(applicationName, application, timeStamp);
            this.appendln();
        }
    }

    void inspectHttpSessions(String applicationName, HttpApplication application, long timeStamp) {
        Map sessions = this.getSessionsForApplication(application);
        if (sessions.isEmpty()) {
            this.indent();
            this.appendln("No active sessions");
            return;
        }
        this.indent();
        this.append("Number of sessions: ");
        this.appendln(sessions.size());
        int count = 0;
        Iterator iter = sessions.keySet().iterator();
        while (iter.hasNext()) {
            String sessionId = (String)iter.next();
            HttpSessionRuntimeInfo session = (HttpSessionRuntimeInfo)sessions.get(sessionId);
            if (session == null) continue;
            this.printHttpSession(sessionId, session, count, timeStamp);
            this.printHttpSessionAttributes(session.getAttributes());
            ++count;
        }
        this.totalSessions += sessions.size();
    }

    void printHttpSession(String sessionId, HttpSessionRuntimeInfo session, int num, long timeStamp) {
        int indent = 4;
        if (sessionId == null || session == null) {
            return;
        }
        this.appendln();
        this.indent();
        this.indentLineNumber(num + 1);
        this.append(" Session ID: ");
        this.appendln(sessionId);
        this.indent(indent);
        this.append("Creation Time: ");
        this.appendln(this.formatter.format(new Date(session.getCreated())));
        this.indent(indent);
        this.append("Last Accessed: ");
        this.appendln(this.formatter.format(new Date(session.getLastAccessed())));
        this.indent(indent);
        this.append("Age: ");
        this.append(Long.toString(HttpSessionsUtils.calcSessionAgeInSeconds(timeStamp, session.getCreated())));
        this.appendln(" seconds");
        this.indent(indent);
        this.append("Idle Time: ");
        this.append(Long.toString(HttpSessionsUtils.calcIdleTimeInSeconds(timeStamp, session.getLastAccessed())));
        this.appendln(" seconds");
        this.indent(indent);
        this.append("Size of Session: ");
        long sessionSize = HttpSessionsUtils.calcSizeOfSessionAttributes(session.getAttributes());
        this.totalSize += sessionSize;
        this.append(String.valueOf(sessionSize));
        this.appendln(" bytes");
    }

    private void printHttpSessionAttributes(Map attributes) {
        int indent = 4;
        this.indent(indent);
        this.append("Number of Attributes: ");
        if (attributes == null || attributes.size() == 0) {
            this.appendln("0");
            this.appendln();
        } else {
            this.append(attributes.size());
            this.appendln();
            this.totalAttributes += attributes.size();
            if (this.showAttributes) {
                this.appendln();
                Set keys = attributes.keySet();
                Iterator iter = keys.iterator();
                int linenum = 1;
                while (iter.hasNext()) {
                    ArrayList<String> viewlist = new ArrayList<String>();
                    String key = (String)iter.next();
                    Object val = attributes.get(key);
                    viewlist.add(key + " : " + val);
                    this.indent(indent);
                    this.indentLineNumber(linenum++);
                    this.append(key);
                    this.append(" :: ");
                    this.appendln(val);
                }
            }
        }
    }

    private ApplicationServer getApplicationServerInstance() {
        ApplicationServer appServer = ApplicationServer.getInstance();
        return appServer;
    }

    private HttpServer getHttpServer() {
        HttpServer httpServer = this.getApplicationServerInstance().getHttpServer();
        return httpServer;
    }

    private List getHttpWebSites() {
        List httpSites = this.getHttpServer().getSites();
        return httpSites;
    }

    private List getHttpWebSites(HttpServer httpServer) {
        List httpSites = httpServer.getSites();
        return httpSites;
    }

    private SortedMap getApplicationsFromSite(HttpSite site) {
        SortedMap ret = new TreeMap();
        try {
            Map apps = site.getApplications(this);
            if (apps != null) {
                ret = this.sortApplications(apps);
            }
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        return ret;
    }

    private Map getSessionsForApplication(HttpApplication application) {
        String[][] sessions = application.getSessionIDs();
        int numsessions = sessions.length;
        HashMap<String, HttpSessionRuntimeInfo> ret = new HashMap<String, HttpSessionRuntimeInfo>(numsessions);
        for (int i = 0; i < numsessions; ++i) {
            String sessionId = sessions[i][0];
            HttpSessionRuntimeInfo session = application.getSessionByID(sessions[i][0]);
            if (session == null) continue;
            ret.put(sessionId, session);
        }
        return ret;
    }

    private Map getAllSessions() {
        HashMap allSessions = new HashMap();
        List sites = this.getHttpWebSites();
        if (sites == null) {
            return allSessions;
        }
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            HttpSite site = (HttpSite)iter.next();
            SortedMap applications = this.getApplicationsFromSite(site);
            Iterator appIter = applications.keySet().iterator();
            while (appIter.hasNext()) {
                String key = (String)appIter.next();
                HttpApplication application = (HttpApplication)applications.get(key);
                allSessions.putAll(this.getSessionsForApplication(application));
            }
        }
        return allSessions;
    }

    private SortedMap sortApplications(Map applications) {
        TreeMap<String, HttpApplication> sortedApplications = new TreeMap<String, HttpApplication>();
        if (applications == null) {
            return sortedApplications;
        }
        Set keys = applications.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            HttpApplication val;
            String appname;
            String newKey;
            String[] key = (String[])iter.next();
            String modulename = key[1];
            String contextroot = key[0];
            if ("<unknown>".equals(modulename) || sortedApplications.containsKey(newKey = (appname = (val = (HttpApplication)applications.get(key)).getName()) + ":" + modulename)) continue;
            sortedApplications.put(appname + ":" + modulename, val);
        }
        return sortedApplications;
    }

    Map seekSummarySessions(long timeStamp) {
        LargestWatchedSession largest = new LargestWatchedSession();
        OldestWatchedSession oldest = new OldestWatchedSession();
        YoungestWatchedSession youngest = new YoungestWatchedSession();
        IdlestWatchedSession idlest = new IdlestWatchedSession();
        HashMap<String, AbstractWatchedSession> watchedSessions = new HashMap<String, AbstractWatchedSession>();
        watchedSessions.put(oldest.getName(), oldest);
        watchedSessions.put(youngest.getName(), youngest);
        watchedSessions.put(idlest.getName(), idlest);
        watchedSessions.put(largest.getName(), largest);
        Map sessions = this.getAllSessions();
        Iterator iter = sessions.keySet().iterator();
        while (iter.hasNext()) {
            String sessionId = (String)iter.next();
            HttpSessionRuntimeInfo session = (HttpSessionRuntimeInfo)sessions.get(sessionId);
            Iterator inneriter = watchedSessions.values().iterator();
            while (inneriter.hasNext()) {
                WatchedSession watchedSession = (WatchedSession)inneriter.next();
                watchedSession.doWatchCheck(sessionId, session, timeStamp);
            }
        }
        return watchedSessions;
    }

    public boolean handleEvent(String message, int level) throws RemoteException {
        String[] error_levels = new String[]{"WARNING", "ERROR", "CRITICAL ERROR"};
        return true;
    }
}

