/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.security.User;
import com.evermind.server.UserSubjectBridgeI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.Security;

public final class SecurityAssociation
extends Security {
    private UserSubjectBridgeI userSubjectBridge;
    private final Logger m_logger = TraceLogger.getLogger(SecurityAssociation.class);

    SecurityAssociation() {
    }

    SecurityAssociation(UserSubjectBridgeI userSubjectBridge) {
        this.userSubjectBridge = userSubjectBridge;
    }

    private CommonThreadState getState() {
        return CommonThreadState.getCurrent();
    }

    public static void setImpl(Security securityImpl) {
        Security.setImpl(securityImpl);
    }

    public Subject getSubject_() throws SecurityException {
        Subject subject;
        User user;
        OC4JSecurity.checkPermission(new AuthPermission("getSubject"));
        if (null != this.userSubjectBridge && null != (user = this.getState().getActiveUser()) && null != (subject = this.userSubjectBridge.toSubject(user))) {
            return subject;
        }
        Subject subject2 = this.getState().getPropagatedSubject();
        return subject2;
    }

    protected void setSubject_(Subject subject, Security.Longevity longevity) throws SecurityException {
        OC4JSecurity.checkPermission(new AuthPermission("doAs"));
        CommonThreadState cts = this.getState();
        cts.setPropagatedSubject(subject);
        try {
            User user;
            User user2 = user = null != this.userSubjectBridge ? this.userSubjectBridge.toUser(subject, cts.getContextUserManager()) : null;
            if (Security.Longevity.SESSION == longevity) {
                cts.setRemoteUser(user, subject);
            } else {
                cts.setActiveUser(user);
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

