/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.acc;

import com.evermind.util.SecurityProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.acc.AtzContainerContracts;
import oracle.oc4j.security.acc.AtzContainerContractsBasic;
import oracle.oc4j.security.acc.AtzContainerContractsJaznJacc;

public class AtzContainerContractsFactory {
    private static AtzContainerContractsFactory m_singletonInstance;
    private static Logger m_logger;
    private Map m_accSuites = new HashMap();

    protected AtzContainerContractsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtzContainerContractsFactory getDefault() {
        if (null != m_singletonInstance) {
            return m_singletonInstance;
        }
        Logger logger = m_logger;
        synchronized (logger) {
            if (null == m_singletonInstance) {
                m_singletonInstance = new AtzContainerContractsFactory();
            }
        }
        return m_singletonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtzContainerContracts getAtzContainerContracts(String contextId) throws Exception {
        if (this.m_accSuites.containsKey(contextId)) {
            return (AtzContainerContracts)this.m_accSuites.get(contextId);
        }
        AtzContainerContractsFactory atzContainerContractsFactory = this;
        synchronized (atzContainerContractsFactory) {
            if (this.m_accSuites.containsKey(contextId)) {
                return (AtzContainerContracts)this.m_accSuites.get(contextId);
            }
            AtzContainerContracts acc = AtzContainerContractsFactory.isJaccEnabled() ? this.createJaccAtzContainerContracts(contextId) : this.createBasicAtzContainerContracts(contextId);
            this.m_accSuites.put(contextId, acc);
            return acc;
        }
    }

    public static boolean isJaccEnabled() {
        return SecurityProperties.getOracleOc4JSecurityJACC();
    }

    AtzContainerContracts createJaccAtzContainerContracts(String contextId) throws Exception {
        m_logger.log(Level.FINE, "creating AtzContainerContracts suite " + AtzContainerContractsJaznJacc.class.toString());
        return AtzContainerContractsJaznJacc.create(contextId);
    }

    AtzContainerContracts createBasicAtzContainerContracts(String contextId) throws Exception {
        m_logger.log(Level.FINE, "creating AtzContainerContracts suite " + AtzContainerContractsBasic.class.toString());
        return new AtzContainerContractsBasic(contextId);
    }

    static {
        m_logger = TraceLogger.getLogger(AtzContainerContractsFactory.class);
    }
}

