/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.acc;

import com.evermind.server.http.deployment.ResourceCollection;
import com.evermind.server.http.deployment.SecurityConstraint;
import com.evermind.util.ServerProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import oracle.j2ee.security.SecurityMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.acc.AtzContainerContractsBasic;
import oracle.oc4j.security.acc.AtzContainerPermission;
import oracle.oc4j.security.acc.MapValue;
import oracle.oc4j.security.acc.MethodValue;

public abstract class AtzContainerContractsJacc
extends AtzContainerContractsBasic {
    public static final String POLICY_PROVIDER_TAG = "javax.security.jacc.policy.provider";
    public static String JACC_POLICY_PROVIDER = "oracle.security.jacc.provider.J2SEPolicy";
    public static final String POLICY_CONFIG_FACTORY_TAG = "javax.security.jacc.PolicyConfigurationFactory.provider";
    public static String JACC_POLICY_CONFIG_FACTORY = "oracle.security.jacc.provider.JACCPolicyConfigurationFactory";
    public static final boolean DEFAULT_OVERWRITE_POLICY = false;
    public static final boolean DEFAULT_OVERWRITE_ROLE_MAPPINGS = false;
    public static final boolean DEFAULT_FORCE_POLICY_CONFIG_LOAD = false;
    private static final Logger s_traceLogger = TraceLogger.getLogger(AtzContainerContractsJacc.class);
    private static final Logger s_customerFacingLogger = CustomerLogger.getLogger("oracle.j2ee.security.oc4j", SecurityMessageBundle.class.getName());
    private static URLClassLoader m_classLoader;
    private static Policy m_policy;
    private PolicyConfiguration m_policyConfiguration;

    protected AtzContainerContractsJacc(String contextId) {
        super(contextId);
        this.init();
    }

    static ClassLoader getJaccJarClassLoader(String jaccJarName) throws InstantiationException {
        if (null == m_classLoader) {
            ClassLoader cl = AtzContainerContractsJacc.class.getClassLoader();
            if (null != jaccJarName) {
                try {
                    File f = new File(jaccJarName);
                    if (!f.exists()) {
                        throw new InstantiationException(jaccJarName + " does not exists!");
                    }
                    URL url = f.toURL();
                    URL[] urls = new URL[]{url};
                    m_classLoader = new URLClassLoader(urls, cl);
                }
                catch (MalformedURLException mex) {
                    throw (InstantiationException)new InstantiationException("Exception looking up jacc providerJar").initCause(mex);
                }
            }
        }
        return m_classLoader;
    }

    private void init() {
        this.establishPolicyConfigurationSettings();
        this.establishRoleMappingConfigurationSettings();
        this.establishPolicyRepositorySettings();
    }

    abstract void establishRoleMappingConfigurationSettings();

    abstract void establishPolicyRepositorySettings();

    void setPolicy(boolean force) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (force) {
            m_policy = null;
        }
        if (null != m_policy) {
            return;
        }
        if (null == this.getPolicyProviderClassName()) {
            throw new InstantiationException("jacc system policy provider not set: javax.security.jacc.policy.provider");
        }
        if (null != m_policy) {
            return;
        }
        this.onSettingPolicyProvider(this.getPolicyProviderClassName());
        ClassLoader cl = AtzContainerContractsJacc.getJaccJarClassLoader(ServerProperties.getOracleOc4jJaccProviderJar());
        if (null != cl) {
            if (this.getTraceLogger().isLoggable(Level.FINE)) {
                this.getTraceLogger().log(Level.FINE, "\t...using class loader: {0}", cl.getClass());
            }
            m_policy = (Policy)Class.forName(this.getPolicyProviderClassName(), true, cl).newInstance();
        } else {
            m_policy = (Policy)Class.forName(this.getPolicyProviderClassName()).newInstance();
        }
        Policy.setPolicy(m_policy);
    }

    Policy getPolicy() throws Exception {
        if (null == m_policy) {
            this.setPolicy(false);
        }
        return m_policy;
    }

    String getPolicyProviderClassName() {
        return System.getProperty(POLICY_PROVIDER_TAG, JACC_POLICY_PROVIDER);
    }

    void establishPolicyConfigurationSettings() {
        if (null == System.getProperty(POLICY_CONFIG_FACTORY_TAG)) {
            if (this.getTraceLogger().isLoggable(Level.FINE)) {
                this.getTraceLogger().log(Level.FINE, "system.property {0} is defaulting to {1}", new String[]{POLICY_CONFIG_FACTORY_TAG, JACC_POLICY_CONFIG_FACTORY});
            }
            System.setProperty(POLICY_CONFIG_FACTORY_TAG, JACC_POLICY_CONFIG_FACTORY);
        }
    }

    PolicyConfiguration getPolicyConfiguration() throws PolicyContextException, ClassNotFoundException {
        return this.getPolicyConfiguration(false, false);
    }

    PolicyConfiguration getPolicyConfiguration(boolean forcePolicyConfigLoad, boolean overwriteAllPolicy) throws PolicyContextException, ClassNotFoundException {
        this.establishPolicyConfigurationSettings();
        if (null == this.m_policyConfiguration || forcePolicyConfigLoad || overwriteAllPolicy) {
            if (null != ServerProperties.getOracleOc4jJaccProviderJar()) {
                try {
                    ClassLoader cl = AtzContainerContractsJacc.getJaccJarClassLoader(ServerProperties.getOracleOc4jJaccProviderJar());
                    String factoryProviderName = System.getProperty(POLICY_CONFIG_FACTORY_TAG);
                    Class<?> clazz = Class.forName(factoryProviderName, overwriteAllPolicy, cl);
                    Object o = clazz.newInstance();
                    PolicyConfigurationFactory factory = (PolicyConfigurationFactory)o;
                    this.m_policyConfiguration = factory.getPolicyConfiguration(this.getContextId(), overwriteAllPolicy);
                    return this.m_policyConfiguration;
                }
                catch (InstantiationException ie) {
                    throw new PolicyContextException((Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    throw new PolicyContextException((Throwable)iae);
                }
            }
            this.m_policyConfiguration = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(this.getContextId(), overwriteAllPolicy);
        }
        return this.m_policyConfiguration;
    }

    ProtectionDomain getProtectionDomain(Subject subject, CodeSource codeSource) {
        Principal[] principals = null == subject || subject.getPrincipals().size() <= 0 ? null : new Principal[subject.getPrincipals().size()];
        return new ProtectionDomain(codeSource, null, null, null == principals ? null : subject.getPrincipals().toArray(principals));
    }

    Permission convertPermission(String type, AtzContainerPermission permission) throws Exception {
        if (null == type || null == permission) {
            return null;
        }
        try {
            if (null != permission.getJaccPermission()) {
                return permission.getJaccPermission();
            }
            if ("EJB" == type) {
                return this.convertEjbPermission(permission);
            }
            if ("WEB" == type) {
                return this.convertWebPermission(permission);
            }
        }
        catch (Exception e) {
            this.getCustomerFacingLogger().severe("problem with " + permission);
            this.getTraceLogger().throwing(this.getClass().toString(), "convertPermission", e);
            throw e;
        }
        return null;
    }

    private Permission convertEjbPermission(AtzContainerPermission permission) throws Exception {
        if (null != permission.getActions() && permission.getActions().length > 1) {
            throw new Exception("multi-values are not currently supported");
        }
        Object j2p = null;
        if (null != permission.getFirstResource() && null != permission.getFirstAction()) {
            j2p = permission.isRoleType() ? new EJBRoleRefPermission(this.cleanEjbName(permission.getFirstResource()), permission.getFirstAction()) : new EJBMethodPermission(this.cleanEjbName(permission.getFirstResource()), this.cleanEjbMethod(permission.getFirstAction()), permission.getInterface(), permission.getArguments());
            this.onConvertingPermission(permission, (Permission)j2p);
        }
        return j2p;
    }

    private Permission convertWebPermission(AtzContainerPermission permission) throws Exception {
        Permission j2p = null;
        if (permission.isRoleType()) {
            if (null != permission.getActions() && permission.getActions().length > 1) {
                throw new Exception("multi-values are not currently supported");
            }
            j2p = new WebRoleRefPermission(this.cleanWebResource(permission.getFirstResource(), false), permission.getFirstAction());
        } else {
            j2p = null == permission.getActions() || permission.getActions().length <= 1 ? this.convertSingleWebPermission(permission) : this.convertMultiWebPermission(permission);
        }
        this.onConvertingPermission(permission, j2p);
        return j2p;
    }

    private Permission convertSingleWebPermission(AtzContainerPermission permission) throws Exception {
        WebResourcePermission j2p = null;
        if (null == permission.getIsSecureTransport()) {
            j2p = new WebResourcePermission(this.cleanWebResource(permission.getFirstResource()), permission.getFirstAction());
        } else if (null == permission.getIsSecureTransport()) {
            j2p = new WebUserDataPermission(this.cleanWebResource(permission.getFirstResource()), permission.getFirstAction());
        } else if (null == j2p) {
            j2p = new WebUserDataPermission(this.cleanWebResource(permission.getFirstResource()), permission.getActions(), this.getTransportType(permission));
        }
        this.onConvertingPermission(permission, (Permission)j2p);
        return j2p;
    }

    private Permission convertMultiWebPermission(AtzContainerPermission permission) throws Exception {
        WebResourcePermission j2p = null;
        if (null == permission.getIsSecureTransport()) {
            j2p = new WebResourcePermission(this.cleanWebResource(permission.getFirstResource()), permission.getActions());
        } else if (null == j2p) {
            j2p = new WebUserDataPermission(this.cleanWebResource(permission.getFirstResource()), permission.getActions(), this.getTransportType(permission));
        }
        this.onConvertingPermission(permission, (Permission)j2p);
        return j2p;
    }

    String cleanEjbName(String name) throws Exception {
        if (name.startsWith("/")) {
            throw new IllegalArgumentException("name is invalid: " + name);
        }
        return name;
    }

    String cleanEjbMethod(String name) throws Exception {
        if (name.equals("*")) {
            return null;
        }
        if (name.startsWith("/")) {
            throw new IllegalArgumentException("name is invalid for this type: " + name);
        }
        return name;
    }

    String cleanWebResource(String name) throws Exception {
        return this.cleanWebResource(name, true);
    }

    String cleanWebResource(String name, boolean doChecks) throws Exception {
        if (null == name || name.length() <= 0 || name.equals("/*:")) {
            name = "/";
        }
        return name;
    }

    String getTransportType(AtzContainerPermission permission) {
        return null == permission.getIsSecureTransport() || permission.getIsSecureTransport() == false ? "NONE" : "CONFIDENTIAL";
    }

    public Logger getTraceLogger() {
        return s_traceLogger;
    }

    public Logger getCustomerFacingLogger() {
        return s_customerFacingLogger;
    }

    protected void onSettingPolicyProvider(String policyProviderClassName) {
        if (this.getCustomerFacingLogger().isLoggable(Level.INFO)) {
            this.getCustomerFacingLogger().log(Level.INFO, "setting policy provider class to: {0}", policyProviderClassName);
        }
    }

    protected void onConvertingPermission(AtzContainerPermission permission, Permission j2p) {
        if (this.getTraceLogger().isLoggable(Level.FINEST)) {
            this.getTraceLogger().log(Level.FINEST, "converting {0} to {1}", new String[]{permission.toString(), j2p.toString()});
        }
    }

    protected void onDeploymentPerformed(boolean wildcardRolesDeployed) {
    }

    void onCheckedPolicyDeploymentPerformed(Permission j2p, AtzContainerPermission permission, String role) {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
            this.getCustomerFacingLogger().log(Level.FINE, "adding to checked policy: {0} for app/role: {1}/{2}", new String[]{permission.toString(), this.getContextId(), role});
        }
    }

    void onUncheckedPolicyDeploymentPerformed(Permission j2p, AtzContainerPermission permission) {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
            this.getCustomerFacingLogger().log(Level.FINE, "adding to unchecked policy: {0} for app: {1}", new String[]{permission.toString(), this.getContextId()});
        }
    }

    void onExcludedPolicyDeploymentPerformed(Permission j2p, AtzContainerPermission permission) {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
            this.getCustomerFacingLogger().log(Level.FINE, "adding to excluded policy: {0} for app: {1}", new String[]{permission.toString(), this.getContextId()});
        }
    }

    void onRoleMappingPerformed(Principal p, String role) {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
            this.getCustomerFacingLogger().log(Level.FINE, "adding role mapping; principal {0} roled-mapped to app/role: {1}/{2}", new String[]{((Object)p).toString(), this.getContextId(), role});
        }
    }

    void onAuthorizationPerformed(AtzContainerPermission permission, boolean decision, ProtectionDomain pd) {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINER)) {
            this.getCustomerFacingLogger().log(Level.FINER, "authorization performed; decision was: {0} for permission: {1} in protection domain: {2} and app: {3}", new String[]{String.valueOf(decision), permission.toString(), pd.toString(), this.getContextId()});
        }
    }

    boolean hasDeferredDeploymentTasks() {
        return ((JaccDeployer)this.getDeployer("EJB")).hasDeferredDeploymentTasks() || ((JaccDeployer)this.getDeployer("WEB")).hasDeferredDeploymentTasks();
    }

    public void clearAllContracts() throws Exception {
        if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
            this.getCustomerFacingLogger().log(Level.FINE, "clearing all contracts for app {0}", this.getContextId());
        }
        this.getPolicyConfiguration(false, true).delete();
        this.m_policyConfiguration = null;
        ((JaccDeployer)this.getDeployer("EJB")).clearDeferredDeploymentTasks();
        ((JaccDeployer)this.getDeployer("WEB")).clearDeferredDeploymentTasks();
    }

    protected AtzContainerContractsBasic.Deployer createDeployer(String type) {
        if ("EJB" == type) {
            return new JaccEjbDeployer(this);
        }
        if ("WEB" == type) {
            return new JaccWebDeployer(this);
        }
        return null;
    }

    protected AtzContainerContractsBasic.Authorizer createAuthorizer(String type) {
        return new JaccAuthorizer(this, type);
    }

    public void finishedDeploymentPhase() throws Exception {
        PolicyConfiguration pc = this.getPolicyConfiguration();
        if (!pc.inService() || this.hasDeferredDeploymentTasks()) {
            if (pc.inService()) {
                pc = this.getPolicyConfiguration(true, false);
            }
            if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
                this.getCustomerFacingLogger().log(Level.FINE, "start - finishDeploymentPhase for app {0}", this.getContextId());
            }
            ((JaccDeployer)this.getDeployer("EJB")).finishDeploymentPhase();
            ((JaccDeployer)this.getDeployer("WEB")).finishDeploymentPhase();
            pc.commit();
            this.getPolicy().refresh();
            if (this.getCustomerFacingLogger().isLoggable(Level.FINE)) {
                this.getCustomerFacingLogger().log(Level.FINE, "end - finishDeploymentPhase for app {0}", this.getContextId());
            }
        }
        PolicyContext.setContextID((String)this.getContextId());
    }

    protected static class JaccAuthorizer
    extends AtzContainerContractsBasic.Authorizer {
        JaccAuthorizer(AtzContainerContractsJacc accSuite, String type) {
            super(accSuite, type);
        }

        boolean implies(ProtectionDomain pd, Permission permission) throws Exception {
            return ((AtzContainerContractsJacc)this.m_accSuite).getPolicy().implies(pd, permission);
        }

        public boolean isAuthorized(Subject subject, AtzContainerPermission permission, CodeSource codeSource) throws Exception {
            if (null == subject || null == permission) {
                throw new IllegalArgumentException("subject and permission are both required");
            }
            ProtectionDomain pd = ((AtzContainerContractsJacc)this.m_accSuite).getProtectionDomain(subject, codeSource);
            return this.isAuthorized(permission, pd);
        }

        public boolean isAuthorized(AtzContainerPermission permission, ProtectionDomain pd) throws Exception {
            if (null == permission || null == pd) {
                throw new IllegalArgumentException("permission and policy domain are both required");
            }
            Permission j2p = ((AtzContainerContractsJacc)this.m_accSuite).convertPermission(this.getType(), permission);
            boolean decision = this.implies(pd, j2p);
            ((AtzContainerContractsJacc)this.m_accSuite).onAuthorizationPerformed(permission, decision, pd);
            return decision;
        }
    }

    static class JaccWebDeployer
    extends JaccDeployer {
        List m_cachedSecurityConstraints = new ArrayList();

        JaccWebDeployer(AtzContainerContractsJacc accSuite) {
            super(accSuite, "WEB");
        }

        private void createWebRoleRefPermission(List constraints) {
        }

        void processConstraints(List constraints) throws Exception {
            HashMap qpMap = this.parseConstraints(constraints);
            HashMap<String, Permissions> roleMap = new HashMap<String, Permissions>();
            Permissions excluded = new Permissions();
            Permissions unchecked = new Permissions();
            Iterator<Object> it = qpMap.values().iterator();
            while (it.hasNext()) {
                MapValue m = (MapValue)it.next();
                if (m.irrelevantByQualifier) continue;
                String name = m.urlPatternSpec.toString();
                String[] actions = m.getMethodsWithPredefinedOutcome(false);
                if (actions != null) {
                    excluded.add((Permission)new WebResourcePermission(name, actions));
                    excluded.add((Permission)new WebUserDataPermission(name, actions, null));
                }
                if ((actions = m.getMethodsWithPredefinedOutcome(true)) != null) {
                    unchecked.add((Permission)new WebResourcePermission(name, actions));
                }
                for (int i = 0; i < MethodValue.connectKeys.length; ++i) {
                    actions = m.getConnectMap(1 << i);
                    if (actions == null) continue;
                    unchecked.add((Permission)new WebUserDataPermission(name, actions, (String)MethodValue.connectKeys[i]));
                }
                HashMap rMap = m.getRoleMap();
                Iterator i = rMap.keySet().iterator();
                while (i.hasNext()) {
                    String role = (String)i.next();
                    actions = MapValue.getMethodArray((Integer)rMap.get(role));
                    Permissions p = (Permissions)roleMap.get(role);
                    if (p == null) {
                        p = new Permissions();
                        roleMap.put(role, p);
                    }
                    p.add((Permission)new WebResourcePermission(name, actions));
                }
            }
            this.notifyOnExcluded(excluded);
            ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToExcludedPolicy((PermissionCollection)excluded);
            this.notifyOnUnchecked(unchecked);
            ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToUncheckedPolicy((PermissionCollection)unchecked);
            it = roleMap.keySet().iterator();
            while (it.hasNext()) {
                String role = (String)it.next();
                Permissions pCollection = (Permissions)roleMap.get(role);
                this.notifyOnChecked(role, pCollection);
                ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToRole(role, (PermissionCollection)pCollection);
            }
        }

        HashMap parseConstraints(List constraints) throws Exception {
            HashMap<String, MapValue> qpMap = new HashMap<String, MapValue>();
            qpMap.put("/", new MapValue("/"));
            Iterator iter = constraints.iterator();
            while (iter.hasNext()) {
                SecurityConstraint sc = (SecurityConstraint)iter.next();
                Iterator ewrc = sc.getResourceCollections().iterator();
                while (ewrc.hasNext()) {
                    ResourceCollection wrc = (ResourceCollection)ewrc.next();
                    Iterator eurl = wrc.getURLPatterns().iterator();
                    while (eurl.hasNext()) {
                        String url = (String)eurl.next();
                        MapValue mValue = (MapValue)qpMap.get(url);
                        if (mValue == null) {
                            mValue = new MapValue(url);
                            Iterator it = qpMap.keySet().iterator();
                            while (it.hasNext()) {
                                String otherUrl = (String)it.next();
                                int otherUrlType = MapValue.patternType(otherUrl);
                                switch (MapValue.patternType(url)) {
                                    case 2: {
                                        if ((otherUrlType == 2 || otherUrlType == 3) && MapValue.implies(url, otherUrl)) {
                                            mValue.addQualifier(otherUrl);
                                            break;
                                        }
                                        if (otherUrlType == 2 && MapValue.implies(otherUrl, url)) {
                                            ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                            break;
                                        }
                                        if (otherUrlType != 1 && otherUrlType != 0) break;
                                        ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                        break;
                                    }
                                    case 1: {
                                        if (otherUrlType == 2 || otherUrlType == 3 && MapValue.implies(url, otherUrl)) {
                                            mValue.addQualifier(otherUrl);
                                            break;
                                        }
                                        if (otherUrlType != 0) break;
                                        ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                        break;
                                    }
                                    case 0: {
                                        if (otherUrlType == 0) break;
                                        mValue.addQualifier(otherUrl);
                                        break;
                                    }
                                    case 3: {
                                        if ((otherUrlType == 2 || otherUrlType == 1) && MapValue.implies(otherUrl, url)) {
                                            ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                            break;
                                        }
                                        if (otherUrlType != 0) break;
                                        ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                    }
                                }
                            }
                            qpMap.put(url, mValue);
                        }
                        int methods = MapValue.methodArrayToSet(wrc.getMethods());
                        if (this.isUnchecked(sc)) {
                            mValue.setPredefinedOutcomeOnMethods(methods, true);
                        } else {
                            Iterator eroles = sc.getRoleNames().iterator();
                            if (!eroles.hasNext()) {
                                mValue.setPredefinedOutcomeOnMethods(methods, false);
                            } else {
                                while (eroles.hasNext()) {
                                    String role = (String)eroles.next();
                                    mValue.setRoleOnMethods(role, methods, this.m_accSuite.getRoleMapper().getRoles());
                                }
                            }
                        }
                        if (null == sc.getTransportGuaranteeString()) {
                            mValue.setConnectOnMethods(null, methods);
                            continue;
                        }
                        mValue.setConnectOnMethods(sc.getTransportGuaranteeString(), methods);
                    }
                }
            }
            return qpMap;
        }

        boolean isUnchecked(SecurityConstraint sc) {
            return !sc.hasAuthorizationConstraint();
        }

        void notifyOnExcluded(Permissions excluded) {
            Enumeration<Permission> en = excluded.elements();
            while (en.hasMoreElements()) {
                Permission j2p = en.nextElement();
                AtzContainerPermission permission = AtzContainerPermission.create(j2p);
                ((AtzContainerContractsJacc)this.m_accSuite).onExcludedPolicyDeploymentPerformed(j2p, permission);
                ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
            }
        }

        void notifyOnUnchecked(Permissions unchecked) {
            Enumeration<Permission> en = unchecked.elements();
            while (en.hasMoreElements()) {
                Permission j2p = en.nextElement();
                AtzContainerPermission permission = AtzContainerPermission.create(j2p);
                ((AtzContainerContractsJacc)this.m_accSuite).onUncheckedPolicyDeploymentPerformed(j2p, permission);
                ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
            }
        }

        void notifyOnChecked(String role, Permissions checked) {
            Enumeration<Permission> en = checked.elements();
            while (en.hasMoreElements()) {
                Permission j2p = en.nextElement();
                AtzContainerPermission permission = AtzContainerPermission.create(j2p);
                ((AtzContainerContractsJacc)this.m_accSuite).onCheckedPolicyDeploymentPerformed(j2p, permission, role);
                ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
            }
        }

        boolean hasDeferredDeploymentTasks() {
            return !this.m_cachedSecurityConstraints.isEmpty();
        }

        void finishDeploymentPhase() throws Exception {
            this.createWebRoleRefPermission(this.m_cachedSecurityConstraints);
            this.processConstraints(this.m_cachedSecurityConstraints);
            this.clearDeferredDeploymentTasks();
        }

        void clearDeferredDeploymentTasks() {
            this.m_cachedSecurityConstraints.clear();
        }

        public void addToUncheckedPolicy(AtzContainerPermission permission) throws Exception {
            throw new Exception("not implemented");
        }

        public void revokePermissionToRoles(AtzContainerPermission permission) throws Exception {
            throw new Exception("not implemented");
        }

        public void apply(SecurityConstraint securityConstraint) throws Exception {
            this.m_cachedSecurityConstraints.add(securityConstraint);
        }
    }

    static class JaccEjbDeployer
    extends JaccDeployer {
        JaccEjbDeployer(AtzContainerContractsJacc accSuite) {
            super(accSuite, "EJB");
        }

        boolean hasDeferredDeploymentTasks() {
            return false;
        }

        void finishDeploymentPhase() throws Exception {
        }

        void clearDeferredDeploymentTasks() {
        }

        public void addToUncheckedPolicy(AtzContainerPermission permission) throws Exception {
            Permission j2p = ((AtzContainerContractsJacc)this.m_accSuite).convertPermission(this.getType(), permission);
            if (null == j2p) {
                throw new IllegalStateException("unable to determine permission for type " + this.getType());
            }
            ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToUncheckedPolicy(j2p);
            ((AtzContainerContractsJacc)this.m_accSuite).onUncheckedPolicyDeploymentPerformed(j2p, permission);
            ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
        }

        public void revokePermissionToRoles(AtzContainerPermission permission) throws Exception {
            Permission j2p = ((AtzContainerContractsJacc)this.m_accSuite).convertPermission(this.getType(), permission);
            if (null == j2p) {
                throw new IllegalStateException("unable to determine permission for type " + this.getType());
            }
            ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToExcludedPolicy(j2p);
            ((AtzContainerContractsJacc)this.m_accSuite).onExcludedPolicyDeploymentPerformed(j2p, permission);
            ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
        }

        public void apply(SecurityConstraint securityConstraint) throws Exception {
            throw new Exception("not a valid method for this type");
        }
    }

    static abstract class JaccDeployer
    extends AtzContainerContractsBasic.Deployer {
        JaccDeployer(AtzContainerContractsJacc accSuite, String type) {
            super(accSuite, type);
        }

        abstract boolean hasDeferredDeploymentTasks();

        abstract void clearDeferredDeploymentTasks();

        abstract void finishDeploymentPhase() throws Exception;

        public void grantPermissionToRoles(AtzContainerPermission permission, String[] roles) throws Exception {
            this.addToRoles(permission, roles);
        }

        public void addToRoles(AtzContainerPermission permission, String[] roles) throws Exception {
            if (null == roles || roles.length <= 0) {
                Permission j2p = ((AtzContainerContractsJacc)this.m_accSuite).convertPermission(this.getType(), permission);
                if (null == j2p) {
                    throw new IllegalStateException("unable to determine permission for type " + this.getType());
                }
                ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToUncheckedPolicy(j2p);
                ((AtzContainerContractsJacc)this.m_accSuite).onUncheckedPolicyDeploymentPerformed(j2p, permission);
                ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
            } else {
                for (int i = 0; i < roles.length; ++i) {
                    this.addToRole(permission, roles[i]);
                }
            }
        }

        public void addToRole(AtzContainerPermission permission, String role) throws Exception {
            Permission j2p = ((AtzContainerContractsJacc)this.m_accSuite).convertPermission(this.getType(), permission);
            if (null == j2p) {
                throw new IllegalStateException("unable to determine permission for type " + this.getType());
            }
            ((AtzContainerContractsJacc)this.m_accSuite).getPolicyConfiguration().addToRole(role, j2p);
            ((AtzContainerContractsJacc)this.m_accSuite).onCheckedPolicyDeploymentPerformed(j2p, permission, role);
            ((AtzContainerContractsJacc)this.m_accSuite).onDeploymentPerformed(false);
        }
    }
}

