/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.acc;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.auth.OC4JPrincipal;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.ejb.deployment.ExcludeList;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.MethodPermission;
import com.evermind.server.http.deployment.SecurityConstraint;
import com.evermind.util.SecurityProperties;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.xml.soap.SOAPMessage;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.acc.AtzContainerAuthorizer;
import oracle.oc4j.security.acc.AtzContainerContracts;
import oracle.oc4j.security.acc.AtzContainerContractsFactory;
import oracle.oc4j.security.acc.AtzContainerDeployer;
import oracle.oc4j.security.acc.AtzContainerPermission;
import oracle.oc4j.security.acc.AtzContainerRoleMapWriter;
import oracle.oc4j.security.acc.AtzContainerRoleMapper;
import oracle.security.jazn.oc4j.JAZNUserAdaptor;

public class JaccWrapper {
    private String contextId;
    private AtzContainerContracts m_atzContractOveride;
    private static Map defaultSecurityRoles = new HashMap();
    private static Logger m_logger = TraceLogger.getLogger(JaccWrapper.class);
    private static final boolean enabled = SecurityProperties.getOracleOc4JSecurityJACC();

    public AtzContainerContracts getJaccContracts() throws Exception {
        if (null != this.m_atzContractOveride) {
            return this.m_atzContractOveride;
        }
        return AtzContainerContractsFactory.getDefault().getAtzContainerContracts(this.contextId);
    }

    public AtzContainerDeployer getJaccEJBDeployer() {
        try {
            return this.getJaccContracts().getDeployer("EJB");
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public AtzContainerDeployer getJaccWebDeployer() {
        try {
            return this.getJaccContracts().getDeployer("WEB");
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public AtzContainerRoleMapper getJaccRoleMapper() {
        try {
            return this.getJaccContracts().getRoleMapper();
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public AtzContainerRoleMapWriter getJaccRoleMapWriter() {
        try {
            return this.getJaccEJBDeployer().getRoleMapWriter();
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public AtzContainerAuthorizer getJaccEJBAuthorizer() {
        try {
            return this.getJaccContracts().getAuthorizer("EJB");
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public AtzContainerAuthorizer getJaccWebAuthorizer() {
        try {
            return this.getJaccContracts().getAuthorizer("WEB");
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
            return null;
        }
    }

    public JaccWrapper(String contextId) {
        this.contextId = contextId;
    }

    public JaccWrapper(String contextId, AtzContainerContracts atzContract) {
        this.contextId = contextId;
        if (null != atzContract) {
            this.m_atzContractOveride = atzContract;
        }
    }

    public void addDefaultSecurityRole(SecurityRole securityRole) throws PolicyContextException {
        defaultSecurityRoles.put(this.contextId, securityRole);
    }

    public void addExcludeListforEJB(ExcludeList excludeList) throws PolicyContextException {
        try {
            Iterator methods = excludeList.getMethods().iterator();
            while (methods.hasNext()) {
                MethodDescriptor methodDescriptor = (MethodDescriptor)methods.next();
                this.getJaccEJBDeployer().revokePermissionToRoles(this.createAtzContainerPermission(methodDescriptor));
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
    }

    public void addEJBMethodPermission(MethodPermission methodPermission) throws PolicyContextException {
        try {
            MethodDescriptor[] descriptors = methodPermission.getMethods();
            for (int xDescriptor = 0; xDescriptor < descriptors.length; ++xDescriptor) {
                MethodDescriptor descriptor = descriptors[xDescriptor];
                AtzContainerPermission p = this.createAtzContainerPermission(descriptor);
                if (methodPermission.isUnchecked()) {
                    this.getJaccEJBDeployer().addToUncheckedPolicy(p);
                    continue;
                }
                this.getJaccEJBDeployer().grantPermissionToRoles(p, methodPermission.getRoleNames());
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
    }

    public void addEJBSecurityRoleRef(SecurityRoleReference securityRoleRef, String ejbName) throws PolicyContextException {
        try {
            AtzContainerPermission ejbRoleRefPermission = AtzContainerPermission.createEJBRoleRefPermission(ejbName, securityRoleRef.getName());
            String[] roles = new String[]{securityRoleRef.getLink()};
            this.getJaccEJBDeployer().grantPermissionToRoles(ejbRoleRefPermission, roles);
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
    }

    public void addWebSecurityConstraint(SecurityConstraint securityConstraint) throws PolicyContextException {
        try {
            this.getJaccWebDeployer().apply(securityConstraint);
        }
        catch (Exception e) {
            throw new PolicyContextException((Throwable)e);
        }
    }

    public synchronized void addWebSecurityRoleRef(SecurityRoleReference securityRoleRef, String servletName) throws PolicyContextException {
        try {
            AtzContainerPermission p = AtzContainerPermission.createWebRoleRefPermission(servletName, securityRoleRef.getName());
            this.getJaccWebDeployer().grantPermissionToRoles(p, Collections.singleton(securityRoleRef.getLink()));
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
    }

    public void addRoleMapping(SecurityRole securityRole) throws PolicyContextException {
        try {
            Iterator itar = securityRole.getUsers().iterator();
            while (itar.hasNext()) {
                OC4JPrincipal p = new OC4JPrincipal((String)itar.next());
                this.getJaccRoleMapWriter().assignPrincipalToRole(p, securityRole.getName());
            }
            Iterator itar2 = securityRole.getGroups().iterator();
            while (itar2.hasNext()) {
                OC4JPrincipal p = new OC4JPrincipal((String)itar2.next());
                this.getJaccRoleMapWriter().assignPrincipalToRole(p, securityRole.getName());
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
    }

    public void finishDeployment() throws Exception {
        this.getJaccContracts().finishedDeploymentPhase();
    }

    public boolean authorizeEJB(EJBMethodPermission permission, User user, Object[] arguments, EnterpriseBean bean, SOAPMessage soapMessage) {
        if (this.isUserAuthorizedByDefaultSecurityRole(user)) {
            return true;
        }
        JAZNUserAdaptor jaznUser = (JAZNUserAdaptor)user;
        if (jaznUser.getName().equalsIgnoreCase("admin")) {
            return true;
        }
        Subject subject = JaccWrapper.createSubjectFromUser(user);
        return this.authorizeEJB(permission, subject, arguments, bean, soapMessage);
    }

    private boolean isUserAuthorizedByDefaultSecurityRole(User user) {
        SecurityRole defaultRole = (SecurityRole)defaultSecurityRoles.get(this.contextId);
        boolean retVal = false;
        if (defaultRole == null) {
            retVal = false;
        } else {
            retVal = defaultRole.impliesAll();
            if (!retVal) {
                List defaultRoleGroups;
                List defaultRoleUsers = defaultRole.getUsers();
                if (!defaultRoleUsers.isEmpty()) {
                    Iterator iter = defaultRoleUsers.iterator();
                    while (iter.hasNext()) {
                        User u = (User)iter.next();
                        if (!u.getName().equals(user.getName())) continue;
                        retVal = true;
                        break;
                    }
                }
                if (!(defaultRoleGroups = defaultRole.getGroups()).isEmpty()) {
                    Iterator iter = defaultRoleGroups.iterator();
                    while (iter.hasNext()) {
                        Group g = (Group)iter.next();
                        if (!user.isMemberOf(g)) continue;
                        retVal = true;
                        break;
                    }
                }
            }
        }
        return retVal;
    }

    public boolean authorizeEJB(EJBMethodPermission permission, Subject subject, Object[] arguments, EnterpriseBean bean, SOAPMessage soapMessage) {
        boolean authorized = this.check((Permission)permission, subject, false);
        if (!authorized) {
            authorized = this.checkDefaultRoleAuthorized(subject);
        }
        return authorized;
    }

    private boolean checkDefaultRoleAuthorized(Subject subject) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean check(Permission permission, Subject subject, boolean isWeb) {
        boolean result = false;
        try {
            ProtectionDomain pd = this.createProtectionDomain(subject);
            AtzContainerPermission atzPermission = AtzContainerPermission.create(permission);
            result = this.getJaccEJBAuthorizer().isAuthorized(atzPermission, pd);
            return result;
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean check(Permission permission, User user, boolean isWeb) {
        boolean result = false;
        try {
            Subject subject = JaccWrapper.createSubjectFromUser(user);
            ProtectionDomain pd = this.createProtectionDomain(subject);
            AtzContainerPermission atzPermission = AtzContainerPermission.create(permission);
            result = this.getJaccEJBAuthorizer().isAuthorized(atzPermission, pd);
            return result;
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Exception:", e);
        }
        finally {
            return result;
        }
    }

    private Principal[] getPrincipalArray(Subject subject) {
        if (null == subject) {
            return null;
        }
        Principal[] p = new Principal[subject.getPrincipals().size()];
        int i = 0;
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            p[i++] = iter.next();
        }
        return p;
    }

    private ProtectionDomain createProtectionDomain(Subject subject) {
        return new ProtectionDomain(null, null, null, this.getPrincipalArray(subject));
    }

    static Subject createSubjectFromUser(User user) {
        Subject s = new Subject();
        s.getPrincipals().add(new OC4JPrincipal(user.getName()));
        Iterator groups = user.getGroups().iterator();
        while (groups.hasNext()) {
            s.getPrincipals().add(new OC4JPrincipal(((Principal)groups.next()).getName()));
        }
        return s;
    }

    public boolean authorizeWeb(String requestURI, String contextPath, String method, int transportLevel, User user) {
        if (this.isAdminUser(user)) {
            return true;
        }
        boolean authorized = false;
        try {
            String uri = JaccWrapper.getUriMinusContextPath(requestURI.toString(), contextPath);
            WebResourcePermission wrp = new WebResourcePermission(uri, method);
            authorized = this.check((Permission)wrp, user, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return authorized;
    }

    boolean isAdminUser(User user) {
        if (!(user instanceof JAZNUserAdaptor)) {
            return false;
        }
        JAZNUserAdaptor jaznUser = (JAZNUserAdaptor)user;
        return jaznUser.getName().equalsIgnoreCase("admin");
    }

    boolean isAnonymousUser(User user) {
        ApplicationServer appServer = ApplicationServer.getInstance();
        User anonUser = appServer.getAnonymousUser();
        return anonUser != null && anonUser.equals(user);
    }

    private static String getUriMinusContextPath(String auri, String contextPath) {
        String uri = auri;
        if (uri != null) {
            int contextLength;
            int n = contextLength = contextPath == null ? 0 : contextPath.length();
            if (contextLength > 0) {
                uri = uri.substring(contextLength);
            }
            if (uri.equals("/")) {
                uri = "";
            }
        } else {
            uri = "";
        }
        return uri;
    }

    private AtzContainerPermission createAtzContainerPermission(MethodDescriptor methodDescriptor) {
        String[] arguments;
        String ejbName = methodDescriptor.getBeanName();
        String methodName = methodDescriptor.getName();
        int type = methodDescriptor.getType();
        String methodInterface = null;
        if (type > 0) {
            methodInterface = MethodDescriptor.getMethodOriginName(type);
        }
        if ((arguments = methodDescriptor.getParameterNames()) == null || arguments.length == 0) {
            arguments = null;
        }
        return AtzContainerPermission.createEJBMethodPermission(ejbName, methodName, methodInterface, arguments);
    }

    public static boolean isJaccEnabled() {
        return enabled;
    }
}

