/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.iiop;

import com.evermind.security.User;
import com.evermind.server.RoleUser;
import com.evermind.server.ThreadState;
import com.evermind.util.ServerProperties;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.oc4j.corba.iiop.security.AnonCredential;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;

public class CSIv2Security {
    private static ThreadLocal _publicCredentials = new ThreadLocal();

    public static Subject getCsiSubject() {
        Subject subject;
        block18: {
            Set<Object> credSet;
            subject = new Subject();
            User user = ThreadState.getCurrentState().getUser();
            if (user != null) {
                subject.getPrincipals().add(user);
                if (user instanceof RoleUser) {
                    GSSUPName gssname = CSIv2Security.getGSSName((RoleUser)user);
                    Set<Object> pSet = subject.getPublicCredentials();
                    if (pSet != null) {
                        pSet.add(gssname);
                    }
                    return subject;
                }
                String name = null;
                String pass = null;
                try {
                    pass = user.getPassword();
                    name = user.getName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                final Subject s = subject;
                if (name != null && pass != null && !pass.equals("")) {
                    Set credSet2 = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return s.getPrivateCredentials();
                        }
                    });
                    if (credSet2 != null) {
                        try {
                            credSet2.add(new PasswordCredential(name, pass, "default"));
                        }
                        catch (Exception e) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Adding to private credentials failed: " + e.getMessage());
                            }
                        }
                    }
                } else if (name.equals("anonymous") && pass == null && CSIv2Security.getPublicCredentials() == null) {
                    subject.getPublicCredentials().add(new AnonCredential());
                    return subject;
                }
            } else if (CSIv2Security.getPublicCredentials() == null) {
                subject.getPublicCredentials().add(new AnonCredential());
                return subject;
            }
            if (CSIv2Security.getPublicCredentials() != null && (credSet = subject.getPublicCredentials()) != null) {
                try {
                    credSet.add(CSIv2Security.getPublicCredentials());
                }
                catch (Exception e) {
                    if (!ServerProperties.getApplicationServerDebug()) break block18;
                    System.out.println("Adding to public credentials failed: " + e.getMessage());
                }
            }
        }
        return subject;
    }

    private static Object getPublicCredentials() {
        return _publicCredentials.get();
    }

    public static void setPublicCredentials(Object credentials) {
        _publicCredentials.set(credentials);
    }

    private static GSSUPName getGSSName(RoleUser __user) {
        String usr1 = null;
        List usrList = __user.getRole().getUsers();
        if (usrList != null && !usrList.isEmpty()) {
            usr1 = (String)usrList.get(0);
        }
        if (usr1 == null) {
            throw new IllegalStateException("Logical Security Role not mapped to physical users");
        }
        return new GSSUPName(usr1, "default");
    }
}

