/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.connector.deployment.SharedConnectionPool;
import com.evermind.util.ObjectUtils;
import com.evermind.util.TaskManager;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.NativeDataSourceWrapper;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSourceUtils {
    public static final int ERROR_CODE_ORA_END_OF_FILE_ON_COM_CHANNEL = 3113;
    public static final int ERROR_CODE_ORA_NOT_CONNECTED_TO_ORACLE = 3114;
    public static final int ERROR_CODE_ORA_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    public static final int ERROR_CODE_ORA_ORACLE_NOT_AVAILABLE = 1034;
    public static final int ERROR_CODE_ORA_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    public static final int ERROR_CODE_ORA_SHUTDOWN_IN_PROGRESS_CONN_NOT_PERMITTED = 1090;
    public static final int ERROR_CODE_ORA_INSTANCE_TERMINATED = 1092;
    public static final int ERROR_CODE_ORA_CONNECTION_CLOSED = 17008;
    public static final int ERROR_CODE_ORA_INVALID_OR_STALE_CONNECTION_FOUND = 17143;
    private static final int[] m_oracleFatalErrorCodes = new int[]{3113, 3114, 1033, 1034, 1089, 1090, 1092, 17008, 17143};
    private static final String ORACLE_OC4J_SQL_CONNECTION_POOL_IMPL = "oracle.oc4j.sql.ConnectionPoolImpl";

    public static int[] getOracleFatalErrorCodes() {
        return m_oracleFatalErrorCodes;
    }

    public static boolean isOracleFatalError(SQLException exc) {
        int errorCode = exc.getErrorCode();
        for (int i = 0; i < m_oracleFatalErrorCodes.length; ++i) {
            if (errorCode != m_oracleFatalErrorCodes[i]) continue;
            return true;
        }
        return false;
    }

    public static Document createDom(String xml) throws ParserConfigurationException, IOException, SAXException {
        if (xml == null) {
            xml = "";
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("utf-8"));
        InputSource inputSource = new InputSource(bais);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    public static void setProperties(Object object, PropertyConfig[] properties) throws DataSourceException {
        for (int i = 0; i < properties.length; ++i) {
            try {
                boolean isDBLink = properties[i].getName().toLowerCase().indexOf("dblink") != -1;
                ObjectUtils.setProperty(object, properties[i].getName(), properties[i].getValue(), true, isDBLink);
                continue;
            }
            catch (Throwable exception) {
                throw new DataSourceException(DataSourceMessages.severeSetDataSourceProperty(properties[i].getName(), exception));
            }
        }
    }

    public static void setProperty(Object object, String name, String value, boolean throwException) throws Exception {
        block2: {
            try {
                ObjectUtils.setProperty(object, name, value, true, false);
            }
            catch (Exception exception) {
                DataSourceMessages.warningSetProperty(name, value, object.getClass().getName(), exception);
                if (!throwException) break block2;
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPropertySettable(Object object, String name) {
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = new PropertyDescriptor[]{};
        try {
            descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                if (descriptors[i].getWriteMethod() == null || !descriptors[i].getName().equals(name)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IntrospectionException introspectionException) {
        }
        finally {
            Introspector.flushCaches();
        }
        return false;
    }

    public static void setUser(Object target, String user) throws DataSourceException {
        try {
            ObjectUtils.setProperty(target, "user", user, true, true);
            ObjectUtils.setProperty(target, "userName", user, true, true);
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeSetUser(target.getClass().getName(), exception);
            throw new DataSourceException(msg, exception);
        }
    }

    public static void setPassword(Object target, String password) throws DataSourceException {
        SecuritySensitive securitySensitive = SecuritySensitive.global();
        if (securitySensitive != null) {
            password = securitySensitive.decode(password, null);
        }
        try {
            ObjectUtils.setProperty(target, "password", password, true, true);
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeSetPassword(target.getClass().getName(), exception);
            throw new DataSourceException(msg);
        }
    }

    public static void setUrl(Object target, String url) throws DataSourceException {
        try {
            ObjectUtils.setProperty(target, "url", url, true, true);
            ObjectUtils.setProperty(target, "URL", url, true, true);
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeSetUrl(target.getClass().getName(), exception);
            throw new DataSourceException(msg);
        }
    }

    public static String[] getproxyInterfaceSQLObjects() {
        String[] sqlObjects = new String[]{"Array", "Blob", "CallableStatement", "Clob", "Connection", "DatabaseMetaData", "ParameterMetaData", "PreparedStatement", "Ref", "ResultSet", "ResultSetMetaData", "Savepoint", "SQLData", "SQLInput", "SQLOutput", "Statement", "Struct"};
        return sqlObjects;
    }

    public static DataSource createDataSource(NativeDataSourceConfig nativeDataSourceConfig) throws DataSourceException {
        if (nativeDataSourceConfig == null) {
            throw new IllegalArgumentException("The native data source configuration cannot be null.");
        }
        try {
            DataSource dataSource = DataSourceConfigUtils.createDataSource(nativeDataSourceConfig.getDataSourceClass());
            if (dataSource instanceof NativeDataSourceWrapper) {
                NativeDataSourceWrapper ndsw = (NativeDataSourceWrapper)dataSource;
                ndsw.setProperties(nativeDataSourceConfig.getProperties());
                DataSourceUtils.setStandardProperties(dataSource, nativeDataSourceConfig);
            } else {
                DataSourceUtils.setStandardProperties(dataSource, nativeDataSourceConfig);
                DataSourceUtils.setProperties(dataSource, nativeDataSourceConfig.getProperties());
            }
            return dataSource;
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.severeCreateNativeDataSource(nativeDataSourceConfig.getName(), sqlException);
            throw new DataSourceException(msg, sqlException);
        }
    }

    private static void setStandardProperties(DataSource dataSource, NativeDataSourceConfig nativeDataSourceConfig) throws DataSourceException, SQLException {
        DataSourceUtils.setUser(dataSource, nativeDataSourceConfig.getUser());
        String password = nativeDataSourceConfig.getPassword();
        DataSourceUtils.setPassword(dataSource, password);
        DataSourceUtils.setUrl(dataSource, nativeDataSourceConfig.getUrl());
        dataSource.setLoginTimeout(nativeDataSourceConfig.getLoginTimeout());
    }

    public static DataSourceConnectionPool getDataSourceConnectionPool(ResourceAdapterImpl resourceAdapter, ConnectionPoolConfig connectionPoolConfig, SharedConnectionPool jcaConnectionPool, NounIntf noun, TaskManager taskManager, String applicationName) throws ResourceException, InstantiationException, DataSourceException {
        DataSourceConnectionPool dataSourceConnectionPool = resourceAdapter.createDataSourceConnectionPool(connectionPoolConfig, applicationName);
        ConnectionPool connectionPool = jcaConnectionPool.getConnectionPool(true, null, noun, taskManager, ManagedConnectionFactoryImpl.class.getName(), ORACLE_OC4J_SQL_CONNECTION_POOL_IMPL);
        dataSourceConnectionPool.setConnectorConnectionPool(connectionPool);
        DataSourceUtils.setConnectionPoolProperties(dataSourceConnectionPool, dataSourceConnectionPool.getConfig(), connectionPool);
        return dataSourceConnectionPool;
    }

    private static void setConnectionPoolProperties(DataSourceConnectionPool dataSourceConnectionPool, ConnectionPoolConfig config, ConnectionPool connectorConnectionPool) throws DataSourceException {
        block13: {
            try {
                connectorConnectionPool.setMinConnections(config.getMinConnections());
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.severeConnectorConnectionPoolSetMinConnections(config.getName(), (Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
            try {
                connectorConnectionPool.setMaxConnections(config.getMaxConnections());
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.severeConnectorConnectionPoolSetMaxConnections(config.getName(), (Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
            try {
                connectorConnectionPool.setWaitTimeout(config.getUsedConnectionWaitTimeout());
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.severeConnectorConnectionPoolSetWaitTimeout(config.getName(), (Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
            try {
                connectorConnectionPool.setInactivityTimeout(config.getInactivityTimeout());
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.severeConnectorConnectionPoolSetInactivityTimeout(config.getName(), (Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
            try {
                if (dataSourceConnectionPool.isICC()) {
                    connectorConnectionPool.setScheme("none");
                    break block13;
                }
                connectorConnectionPool.setScheme("fixed_wait");
                try {
                    connectorConnectionPool.setInitialCapacity(config.getInitialLimit());
                }
                catch (ApplicationServerInternalException asie) {
                    String msg = DataSourceMessages.severeConnectorConnectionPoolSetInitialCapacity(config.getName(), (Exception)((Object)asie));
                    throw new DataSourceException(msg, asie);
                }
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.severeConnectorConnectionPoolSetScheme(config.getName(), (Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
        }
    }

    public static boolean isClass(Class clazz, String className) {
        if (clazz != null) {
            try {
                Class<?> classFromName = Class.forName(className, true, clazz.getClassLoader());
                return classFromName.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }
}

