/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.util.Vector;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.PropertyConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionPropertiesConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "connection-properties";
    private PropertyConfig[] m_properties = new PropertyConfig[0];

    public ConnectionPropertiesConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setProperties();
    }

    public ConnectionPropertiesConfig(PropertyConfig[] properties) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setProperties(properties);
    }

    public PropertyConfig[] getProperties() {
        return this.m_properties;
    }

    public void setProperties(PropertyConfig[] properties) {
        this.m_properties = properties == null ? new PropertyConfig[0] : properties;
    }

    private void setProperties() throws DataSourceConfigException {
        Vector<PropertyConfig> properties = new Vector<PropertyConfig>();
        NodeList nodes = this.getRootNode().getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getNodeName().equals("property")) continue;
                properties.add(new PropertyConfig(node));
            }
        }
        int numProperties = properties.size();
        PropertyConfig[] propertiesArray = new PropertyConfig[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            propertiesArray[i] = (PropertyConfig)properties.get(i);
        }
        this.m_properties = propertiesArray;
    }

    public synchronized void addProperty(String name, String value) throws DataSourceConfigException {
        this.addProperty(new PropertyConfig(name, value));
    }

    public synchronized void addProperty(PropertyConfig property) throws DataSourceConfigException {
        PropertyConfig[] properties = this.m_properties;
        this.m_properties = new PropertyConfig[properties.length + 1];
        for (int i = 0; i < properties.length; ++i) {
            this.m_properties[i] = properties[i];
        }
        this.m_properties[this.m_properties.length - 1] = property;
    }

    public synchronized void removeProperty(String name) throws DataSourceConfigException {
        Vector<PropertyConfig> vector = new Vector<PropertyConfig>();
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (this.m_properties[i].getName().equals(name)) continue;
            vector.add(this.m_properties[i]);
        }
        int numProperties = vector.size();
        this.m_properties = new PropertyConfig[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            this.m_properties[i] = (PropertyConfig)vector.elementAt(i);
        }
    }

    public synchronized void removeProperty(PropertyConfig property) throws DataSourceConfigException {
        this.removeProperty(property.getName());
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        for (int i = 0; i < this.m_properties.length; ++i) {
            element.appendChild(this.m_properties[i].createXML(document));
        }
        return element;
    }
}

