/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.util.Vector;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.ErrorCodeConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FatalErrorCodesConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "fatal-error-codes";
    private ErrorCodeConfig[] m_errorCodes = new ErrorCodeConfig[0];

    public FatalErrorCodesConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setErrorCodes();
    }

    public FatalErrorCodesConfig(ErrorCodeConfig[] errorCodes) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setErrorCodes(errorCodes);
    }

    public ErrorCodeConfig[] getErrorCodes() {
        return this.m_errorCodes;
    }

    public void setErrorCodes(ErrorCodeConfig[] errorCodes) throws DataSourceConfigException {
        if (errorCodes == null) {
            throw new DataSourceConfigException("The error codes cannot be null.");
        }
        this.m_errorCodes = errorCodes;
    }

    private void setErrorCodes() throws DataSourceConfigException {
        Vector<ErrorCodeConfig> errorCodes = new Vector<ErrorCodeConfig>();
        NodeList nodes = this.getRootNode().getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getNodeName().equals("error-code")) continue;
                errorCodes.add(new ErrorCodeConfig(node));
            }
        }
        int numErrorCodes = errorCodes.size();
        ErrorCodeConfig[] errorCodesArray = new ErrorCodeConfig[numErrorCodes];
        for (int i = 0; i < numErrorCodes; ++i) {
            errorCodesArray[i] = (ErrorCodeConfig)errorCodes.get(i);
        }
        this.m_errorCodes = errorCodesArray;
    }

    public synchronized void addErrorCode(int errorCode) throws DataSourceConfigException {
        this.addErrorCode(new ErrorCodeConfig(errorCode));
    }

    public synchronized void addErrorCode(ErrorCodeConfig errorCode) throws DataSourceConfigException {
        int errorCodeCode = errorCode.getCode();
        for (int i = 0; i < this.m_errorCodes.length; ++i) {
            if (this.m_errorCodes[i].getCode() != errorCodeCode) continue;
            return;
        }
        ErrorCodeConfig[] errorCodes = this.m_errorCodes;
        this.m_errorCodes = new ErrorCodeConfig[errorCodes.length + 1];
        for (int i = 0; i < errorCodes.length; ++i) {
            this.m_errorCodes[i] = errorCodes[i];
        }
        this.m_errorCodes[this.m_errorCodes.length - 1] = errorCode;
    }

    public synchronized void removeErrorCode(int errorCode) throws DataSourceConfigException {
        this.removeErrorCode(new ErrorCodeConfig(errorCode));
    }

    public synchronized void removeErrorCode(ErrorCodeConfig errorCode) throws DataSourceConfigException {
        Vector<ErrorCodeConfig> vector = new Vector<ErrorCodeConfig>();
        int errorCodeCode = errorCode.getCode();
        for (int i = 0; i < this.m_errorCodes.length; ++i) {
            int j;
            if (this.m_errorCodes[i].getCode() != errorCodeCode) continue;
            for (j = 0; j < i; ++j) {
                vector.add(this.m_errorCodes[j]);
            }
            for (j = i + 1; j < this.m_errorCodes.length; ++j) {
                vector.add(this.m_errorCodes[j]);
            }
            int numConfigs = vector.size();
            this.m_errorCodes = new ErrorCodeConfig[numConfigs];
            for (int j2 = 0; j2 < numConfigs; ++j2) {
                this.m_errorCodes[j2] = (ErrorCodeConfig)vector.elementAt(j2);
            }
            return;
        }
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        for (int i = 0; i < this.m_errorCodes.length; ++i) {
            element.appendChild(this.m_errorCodes[i].createXML(document));
        }
        return element;
    }
}

