/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.proxy;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Map;
import oracle.oc4j.sql.proxy.SQLBCELProxy;

public abstract class ConnectionBCELProxy
extends SQLBCELProxy
implements Connection {
    protected ConnectionBCELProxy(Object target, SQLBCELProxy parent) {
        super(target, parent);
    }

    protected void oc4j_releaseTarget() throws SQLException {
        if (this.m_target == null) {
            return;
        }
        ((Connection)this.m_target).close();
        super.oc4j_releaseTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void oc4j_dissociate() throws SQLException {
        try {
            super.oc4j_dissociate();
        }
        finally {
            this.oc4j_releaseTarget();
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).nativeSQL(sql);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).getAutoCommit();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void commit() throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).commit();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).rollback();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.oc4j_close(true);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public boolean oc4j_getIsClosed() {
        return this.m_isClosed;
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).isReadOnly();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).setCatalog(catalog);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).getCatalog();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).getTransactionIsolation();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).getWarnings();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).clearWarnings();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).setTypeMap(map);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).setHoldability(holdability);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.oc4j_intercept();
            return ((Connection)this.m_target).getHoldability();
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
            throw e;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.oc4j_intercept();
            ((Connection)this.m_target).releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.oc4j_handleSQLException(e);
        }
    }
}

