/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import com.evermind.server.connector.deployment.SharedConnectionPool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.connector.ExtendedConnectionManager;
import oracle.j2ee.connector.ExtendedManagedConnectionFactory;
import oracle.j2ee.connector.proxy.BCELProxyClassLoader;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.mbean.DMSUtils;
import oracle.oc4j.sql.proxy.CallableStatementBCELProxy;
import oracle.oc4j.sql.proxy.PreparedStatementBCELProxy;
import oracle.oc4j.sql.proxy.ResultSetBCELProxy;
import oracle.oc4j.sql.proxy.SQLBCELProxy;
import oracle.oc4j.sql.proxy.SQLBCELProxyFactory;
import oracle.oc4j.sql.proxy.StatementBCELProxy;
import oracle.oc4j.sql.security.CredentialUtility;
import oracle.oc4j.sql.spi.ConnectionHandle;
import oracle.oc4j.sql.spi.ConnectionManagerImpl;
import oracle.oc4j.sql.spi.ConnectionRequestInfoImpl;
import oracle.oc4j.sql.spi.ManagedConnectionImpl;
import oracle.oc4j.sql.spi.OracleConnectionHandle;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;
import oracle.oc4j.sql.xa.EmulatedXADataSource;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ExtendedManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory,
Serializable {
    private ConnectionManager m_connectionManager;
    private transient ResourceAdapterImpl m_ResourceAdapter;
    private transient Map m_proxyInterfaces = new HashMap();
    private ManagedDataSourceConfig m_managedDataSourceConfig;
    private transient DataSourceConnectionPool m_dataSourceConnectionPool;
    private ConnectionPoolConfig m_connectionPoolConfig;
    private String m_applicationName;
    private ManagedDataSource m_managedDataSource;
    private boolean m_oracleSQLTraceActive = false;
    private transient PrintWriter m_logWriter;
    private boolean m_supports2PC;
    private boolean m_isOracle;
    private boolean m_isICC;
    private boolean m_proxySessions;
    private LazyAssociatableConnectionManager m_lazyAssociatableConnectionManager;
    private LazyEnlistableConnectionManager m_lazyEnlistableConnectionManager;
    private ExtendedConnectionManager m_extendedConnectionManager;
    protected transient ConnectionHandle m_reassociatehandle;
    private transient SQLBCELProxyFactory m_proxyFactory;
    private boolean m_isEmulatedXADataSource = false;
    private boolean m_manageSqlObjectsDirty = false;
    private boolean m_minimalManagement = false;
    private boolean m_hasInvalidConnections = false;
    private Serializable m_invalidConnectionLock = new Serializable(){};

    public ManagedConnectionFactoryImpl() {
        this.m_logWriter = new PrintWriter(System.out, true);
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        this.setConnectionManager(connectionManager);
        this.m_managedDataSource = new ManagedDataSource(this, connectionManager);
        return this.m_managedDataSource;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new ConnectionManagerImpl());
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        XAConnection xaConnection = null;
        ConnectionRequestInfoImpl connectionRequestInfoImpl = (ConnectionRequestInfoImpl)connectionRequestInfo;
        xaConnection = this.createXAConnection(subject, connectionRequestInfoImpl);
        ManagedConnectionImpl managedConnectionImpl = new ManagedConnectionImpl(this, xaConnection, subject, connectionRequestInfoImpl);
        return managedConnectionImpl;
    }

    protected XAConnection createXAConnection(Subject subject, ConnectionRequestInfoImpl connectionRequestInfo) throws ResourceException {
        XAConnection xaConnection = null;
        try {
            PasswordCredential passwordCredential = subject == null ? null : CredentialUtility.getCredentialFromSubject(this, subject);
            String userName = null;
            String password = null;
            if (passwordCredential != null) {
                userName = passwordCredential.getUserName();
                password = new String(passwordCredential.getPassword());
            } else if (connectionRequestInfo != null) {
                password = connectionRequestInfo.getPassword();
                userName = connectionRequestInfo.getUser();
            }
            XADataSource xaDataSource = this.getXADataSource();
            if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
                DataSourceMessages.debugBeforeGetConnection(xaDataSource);
            }
            xaConnection = userName != null && !userName.equals("") && password != null && !password.equals("") ? xaDataSource.getXAConnection(userName, password) : xaDataSource.getXAConnection();
            if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
                DataSourceMessages.debugAfterGetConnection(xaDataSource);
            }
            return xaConnection;
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ConnectionRequestInfoImpl connectionRequestInfoImpl = (ConnectionRequestInfoImpl)connectionRequestInfo;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ManagedConnectionImpl managedConnectionImpl = (ManagedConnectionImpl)iterator.next();
            if (!managedConnectionImpl.isValid() || !this.isManagedConnectionMatch(managedConnectionImpl, subject, connectionRequestInfoImpl)) continue;
            managedConnectionImpl.initOnMatch(this, connectionRequestInfoImpl);
            return managedConnectionImpl;
        }
        return null;
    }

    protected final boolean isManagedConnectionMatch(ManagedConnectionImpl managedConnectionImpl, Subject subject, ConnectionRequestInfoImpl connectionRequestInfo) {
        if (subject != null) {
            PasswordCredential credential = CredentialUtility.getCredential(this, subject, connectionRequestInfo);
            if (CredentialUtility.areCredentialsEqual(managedConnectionImpl.getCredential(), credential)) {
                return true;
            }
        } else {
            ConnectionRequestInfoImpl mciRi = managedConnectionImpl.getConnectionRequestInfo();
            if (mciRi.equalsIgnoreTransactional(connectionRequestInfo)) {
                return true;
            }
        }
        return false;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.m_logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.m_ResourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        if (!(resourceAdapter instanceof ResourceAdapterImpl)) {
            String msg = DataSourceMessages.severeManagedConnectionFactorySetResourceAdapterInvalidImplementationClass(ResourceAdapterImpl.class.getName());
            throw new ResourceException(msg);
        }
        this.m_ResourceAdapter = (ResourceAdapterImpl)resourceAdapter;
    }

    public Map getProxyInterfaces() {
        return this.m_proxyInterfaces;
    }

    protected ConnectionManager getConnectionManager() {
        return this.m_connectionManager;
    }

    protected void setConnectionManager(ConnectionManager connectionManager) {
        this.m_connectionManager = connectionManager;
        if (this.m_connectionManager instanceof LazyAssociatableConnectionManager) {
            this.m_lazyAssociatableConnectionManager = (LazyAssociatableConnectionManager)this.m_connectionManager;
        }
        if (this.m_connectionManager instanceof LazyEnlistableConnectionManager) {
            this.m_lazyEnlistableConnectionManager = (LazyEnlistableConnectionManager)this.m_connectionManager;
        }
        if (this.m_connectionManager instanceof ExtendedConnectionManager) {
            this.m_extendedConnectionManager = (ExtendedConnectionManager)this.m_connectionManager;
            this.m_extendedConnectionManager.setAllowReassociationForUnshareableConnections(false);
        }
    }

    public XADataSource getXADataSource() throws ResourceException {
        return this.m_dataSourceConnectionPool.getConnectionFactory().getXADataSource();
    }

    public void setManagedDataSourceConfigXML(String managedDataSourceConfigXML) throws ResourceException {
        try {
            this.m_managedDataSourceConfig = new ManagedDataSourceConfig(DataSourceUtils.createDom(managedDataSourceConfigXML).getDocumentElement());
            this.m_supports2PC = this.m_managedDataSourceConfig.getTxLevel().equals("global");
            this.m_minimalManagement = this.getManageSqlObjects().equals("minimal");
            DataSourceConnectionPool connectionPool = this.m_ResourceAdapter.getDataSourceConnectionPool(this.m_managedDataSourceConfig.getConnectionPoolName());
            if (connectionPool == null) {
                String msg = DataSourceMessages.warningManagedConnectionFactorySetManagedDataSourceConfigXML(this.m_managedDataSourceConfig.getConnectionPoolName());
                throw new ResourceException(msg);
            }
            this.setDataSourceConnectionPool(connectionPool);
        }
        catch (Exception e) {
            throw new ResourceException(e.toString(), (Throwable)e);
        }
    }

    public ManagedDataSourceConfig getManagedDataSourceConfig() {
        return this.m_managedDataSourceConfig;
    }

    public ManagedDataSource getManagedDataSource() {
        return this.m_managedDataSource;
    }

    public DataSourceConnectionPool getDataSourceConnectionPool() {
        return this.m_dataSourceConnectionPool;
    }

    public void setDataSourceConnectionPool(DataSourceConnectionPool dataSourceConnectionPool) throws IllegalArgumentException {
        if (dataSourceConnectionPool == null) {
            String msg = DataSourceMessages.severeManagedConnectionFactorySetDataSourceConnectionPool();
            throw new IllegalArgumentException(msg);
        }
        this.m_dataSourceConnectionPool = dataSourceConnectionPool;
        this.m_isEmulatedXADataSource = this.m_dataSourceConnectionPool.getConnectionFactory().getXADataSource() instanceof EmulatedXADataSource;
        this.m_connectionPoolConfig = this.m_dataSourceConnectionPool.getConfig();
        this.m_applicationName = this.m_dataSourceConnectionPool.getApplicationName();
        this.m_isICC = this.m_dataSourceConnectionPool.isICC();
        String url = dataSourceConnectionPool.getConfig().getConnectionFactoryConfig().getUrl();
        if (this.m_isICC || url.indexOf("jdbc:oracle:thin:") >= 0 || url.indexOf("jdbc:oracle:oci8:") >= 0 || url.indexOf("jdbc:oracle:oci:") >= 0) {
            this.m_isOracle = true;
        }
        this.m_proxySessions = dataSourceConnectionPool.getConfig().isProxySessions();
        ResourceAdapterImpl.addResourceAdapter(this.m_applicationName, this.m_ResourceAdapter);
        this.setProxyInterfacesFromConfig();
        this.m_ResourceAdapter.bindConnectionFactoryToConnectionPool(this);
    }

    private void setProxyInterfacesFromConfig() {
        Map proxyInterfaces = DataSourceConfigUtils.createProxyInterfaceMap(this.m_dataSourceConnectionPool.getConnectionFactory().getConnectionFactoryConfig().getProxyInterfaces());
        this.m_proxyInterfaces = proxyInterfaces == null ? null : new HashMap(proxyInterfaces);
    }

    protected int getNumCachedStatements() {
        return this.m_dataSourceConnectionPool.getConfig().getNumCachedStatements();
    }

    protected void checkAssociation(ConnectionHandle connectionHandle, ManagedConnection managedConnection, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.m_extendedConnectionManager != null) {
            this.m_extendedConnectionManager.checkAssociation(connectionHandle, managedConnection, this, connectionRequestInfo);
        }
    }

    protected void enlist(ManagedConnection managedConnection) throws ResourceException {
        if (this.m_lazyEnlistableConnectionManager != null) {
            this.m_lazyEnlistableConnectionManager.lazyEnlist(managedConnection);
        }
    }

    protected void activateConnection(ConnectionHandle connection, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.m_lazyAssociatableConnectionManager != null) {
            this.m_lazyAssociatableConnectionManager.associateConnection((Object)connection, (ManagedConnectionFactory)this, connectionRequestInfo);
        }
    }

    protected synchronized SQLBCELProxyFactory getBCELProxyFactory() {
        if (this.m_proxyFactory == null || this.m_manageSqlObjectsDirty) {
            String manageSqlObjects = this.getManageSqlObjects();
            this.m_proxyFactory = new SQLBCELProxyFactory(new BCELProxyClassLoader(this.m_ResourceAdapter.getClassLoaderForProxyCreation()), this.m_proxyInterfaces, null, 2, !this.m_minimalManagement);
            this.m_proxyFactory.setProxySuperClassMapping(Connection.class, ConnectionHandle.class);
            if (manageSqlObjects.equals("basic")) {
                this.m_proxyFactory.setProxySuperClassMapping(CallableStatement.class, CallableStatementBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(PreparedStatement.class, PreparedStatementBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Statement.class, StatementBCELProxy.class);
            } else if (manageSqlObjects.equals("all")) {
                this.m_proxyFactory.setProxySuperClassMapping(CallableStatement.class, CallableStatementBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(PreparedStatement.class, PreparedStatementBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Statement.class, StatementBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(ResultSet.class, ResultSetBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Array.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Blob.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Clob.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(DatabaseMetaData.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(ParameterMetaData.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Ref.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(ResultSetMetaData.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(Savepoint.class, SQLBCELProxy.class);
                this.m_proxyFactory.setProxySuperClassMapping(SQLData.class, SQLBCELProxy.class);
            }
            if (this.isOracle()) {
                this.m_proxyFactory.setProxySuperClassMapping(Connection.class, OracleConnectionHandle.class);
                try {
                    this.m_proxyFactory.setNoProxyResultMethods(OracleConnectionHandle.class, OracleConnectionHandle.oc4j_getNoProxyResultMethods(this.m_ResourceAdapter.getClassLoaderForProxyCreation()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.m_manageSqlObjectsDirty = false;
        }
        return this.m_proxyFactory;
    }

    private String getManageSqlObjects() {
        if (this.m_managedDataSource == null) {
            if (this.m_managedDataSourceConfig == null) {
                return "basic";
            }
            return this.m_managedDataSourceConfig.getManageSqlObjects();
        }
        return this.m_managedDataSource.getManageSqlObjects();
    }

    public boolean isManageSqlObjectsDirty() {
        return this.m_manageSqlObjectsDirty;
    }

    public void setManageSqlObjectsDirty() {
        this.m_manageSqlObjectsDirty = true;
        this.m_minimalManagement = this.getManageSqlObjects().equals("minimal");
    }

    public boolean isOracleSQLTraceActive() {
        return this.m_oracleSQLTraceActive;
    }

    public void setOracleSQLTraceActive(boolean oracleSQLTraceActive) {
        this.m_oracleSQLTraceActive = oracleSQLTraceActive;
    }

    public boolean supportsGlobalTx() {
        return this.m_supports2PC;
    }

    public boolean isOracle() {
        return this.m_isOracle;
    }

    protected void setOracle(boolean isOracle) {
        this.m_isOracle = isOracle;
    }

    public boolean isICC() {
        return this.m_isICC;
    }

    protected void setICC(boolean isICC) {
        this.m_isICC = isICC;
    }

    public boolean isProxySession() {
        return this.m_proxySessions;
    }

    protected void setProxySession(boolean proxySessions) {
        this.m_proxySessions = proxySessions;
    }

    public boolean isMinimalManagement() {
        return this.m_minimalManagement;
    }

    protected void setMinimalManagement(boolean minimalManagement) {
        this.m_minimalManagement = minimalManagement;
    }

    protected boolean isEmulatedXADataSource() {
        return this.m_isEmulatedXADataSource;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.m_logWriter = new PrintWriter(System.out, true);
        try {
            JMXStateFactory.getJMXState();
        }
        catch (IllegalStateException e) {
            DMSUtils.setDMSActive(false);
        }
        try {
            this.setResourceAdapter(ResourceAdapterImpl.getResourceAdapter(this.m_applicationName));
            this.m_dataSourceConnectionPool = this.m_ResourceAdapter.getDataSourceConnectionPool(this.m_connectionPoolConfig.getName());
            if (this.m_dataSourceConnectionPool == null) {
                SharedConnectionPool jcaConnectionPool = new SharedConnectionPool(this.m_connectionPoolConfig.getName());
                this.m_dataSourceConnectionPool = DataSourceUtils.getDataSourceConnectionPool(this.m_ResourceAdapter, this.m_connectionPoolConfig, jcaConnectionPool, null, null, this.m_applicationName);
            }
            this.setProxyInterfacesFromConfig();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getInvalidConnections(Set set) throws ResourceException {
        HashSet<ManagedConnectionImpl> invalidSet = null;
        Serializable serializable = this.m_invalidConnectionLock;
        synchronized (serializable) {
            if (this.m_hasInvalidConnections && set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ManagedConnectionImpl mc = (ManagedConnectionImpl)iterator.next();
                    if (mc.isValid()) continue;
                    if (invalidSet == null) {
                        invalidSet = new HashSet<ManagedConnectionImpl>();
                    }
                    invalidSet.add(mc);
                }
                this.m_hasInvalidConnections = false;
            }
        }
        return invalidSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInvalidConnection(ManagedConnectionImpl connection) {
        Serializable serializable = this.m_invalidConnectionLock;
        synchronized (serializable) {
            connection.setValid(false);
            this.m_hasInvalidConnections = true;
        }
    }
}

