/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.oc4j.util.ActiveResource;
import oracle.oc4j.util.Closeable;

public class LRUMap
extends LinkedHashMap {
    private int m_maxSize;

    public LRUMap() {
        super(10, 0.75f, true);
    }

    public LRUMap(int maxSize) {
        this();
        this.m_maxSize = maxSize;
    }

    public void add(Object entry) {
        this.put(entry, entry);
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.m_maxSize = maxSize;
    }

    public Object put(Object key, Object value) {
        block9: {
            Closeable v;
            Map.Entry entry;
            if (this.m_maxSize <= 0 || this.size() < this.getMaxSize()) break block9;
            Set entrySet = this.entrySet();
            HashSet<Map.Entry> activeSet = null;
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                v = this.getCloseable(entry);
                if (v == null) {
                    iter.remove();
                    break;
                }
                if (!(v instanceof ActiveResource) || !((ActiveResource)((Object)v)).isActive()) {
                    if (!this.closeObject(v)) break;
                    iter.remove();
                    break;
                }
                if (activeSet == null) {
                    activeSet = new HashSet<Map.Entry>();
                }
                activeSet.add(entry);
            }
            if (activeSet != null) {
                if (activeSet.size() >= this.getMaxSize()) {
                    iter = entrySet.iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        v = this.getCloseable(entry);
                        if (!this.closeObject(v)) continue;
                        iter.remove();
                    }
                } else {
                    Iterator it = activeSet.iterator();
                    while (it.hasNext()) {
                        entry = (Map.Entry)it.next();
                        this.get(entry.getKey());
                    }
                }
            }
        }
        return super.put(key, value);
    }

    protected Closeable getCloseable(Map.Entry entry) {
        Object v;
        if (null != entry && (v = entry.getValue()) instanceof Closeable) {
            return (Closeable)v;
        }
        return null;
    }

    protected boolean closeObject(Closeable v) {
        try {
            v.close();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

