/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class AddDestinationCommand
extends AdminCommandBase {
    String _domain;
    String _name;
    String _location;
    String _persistenceFile;
    String _description;
    static final String COMMANDNAME = "-addDestination";
    static final String COMMANDMENU = "-addDestination -domain <domain> -name <name> -jndiLocation <jndiLocation> [options]";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addDestination\n   - Create a new OC4J JMS destination.\n\nValid switches are: \n   -domain <domain>                                    - Required  JMS domain of this destination (`QUEUE' or `TOPIC').\n   -name <name>                                        - Required  The OC4J JMS provider-specific name of the destination.\n   -jndiLocation <jndiLocation>                        - Required  JNDI location this destination will be bound to.\n   -persistenceFile <persistenceFile>                  - Optional  The persistence-file associated with this destination. (defaults to null)\n   -description <description>                          - Optional  A textual description of this destination. (defaults to null).\n\n";

    public AddDestinationCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("addDestination subcommand");
            if (command.equalsIgnoreCase("-domain")) {
                this._domain = this.getNextArgument("-domain ");
                continue;
            }
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("-name ");
                continue;
            }
            if (command.equalsIgnoreCase("-jndiLocation")) {
                this._location = this.getNextArgument("-jndiLocation ");
                continue;
            }
            if (command.equalsIgnoreCase("-persistenceFile")) {
                this._persistenceFile = this.getNextArgument("-persistenceFile ");
                continue;
            }
            if (command.equalsIgnoreCase("-description")) {
                this._description = this.getNextArgument("-description ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_addDestination_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._domain, "-domain");
        this.checkArgIsNull(this._name, "-name");
        this.checkArgIsNull(this._location, "-location");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.addDestination(this._domain, this._name, this._location, this._persistenceFile, this._description);
            System.out.println("Command was successful");
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("addDestination_error", new String[]{e.getMessage()}), e);
        }
    }
}

