/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.ArrayList;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;

public class PublishSharedLibraryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-publishSharedLibrary";
    public static final String COMMANDMENU = "-publishSharedLibrary -name <name> -version <version> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -publishSharedLibrary [<switch>]\n   - Creates and publishes a new shared library in the OC4J instance(s).\n   - At least one code source or one import library is required.\n\nValid switches are: \n   -name <name>                    - Required  The name of the shared library.\n   -version <version>              - Required  The version of the shared library.\n   -parentName <name>              - Optional  The name of the parent library.\n   -parentVersion <version>        - Optional  The version of the parent library.\n\n   -libraryCompatible <true/false> - Optional  Whether the shared library is library compatible.\n\n   -installCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies local jar/zip files to be uploaded to\n                      |   the server and added to the shared library.  For\n                      |   multiple archives, separate each jar_file_path \n                      |   with a space.\n\n   -addCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies existing jar/zip files on the server to\n                      |   be added to the shared library. For multiple\n                      |   archives, separate each jar_file_path with a space.\n\n   -imports <shared_library>...<shared_library_n>\n         - Optional   |   Shared libraries to be imported into this library.\n                      |   For multiple imports, separate each shared_library\n                      |   with a space.\n                      |   \n                      |   <shared_library> must be of format \n                      |        <library name>[:[min-version][,max-version]]\n\n";
    private String _name;
    private String _version;
    private String _parentName = null;
    private String _parentVersion = null;
    private Boolean _libraryCompatible = new Boolean("false");
    private ArrayList _installCodeSources = new ArrayList();
    private ArrayList _addCodeSources = new ArrayList();
    private ArrayList _imports = new ArrayList();

    public PublishSharedLibraryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("publishSharedLibrary subcommand");
            String nextArg = null;
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("publishSharedLibrary -name name");
                continue;
            }
            if (command.equalsIgnoreCase("-version")) {
                this._version = this.getNextArgument("version");
                continue;
            }
            if (command.equalsIgnoreCase("-parentName")) {
                this._parentName = this.getNextArgument("publishSharedLibrary -parentName name");
                continue;
            }
            if (command.equalsIgnoreCase("-parentVersion")) {
                this._parentVersion = this.getNextArgument("parentversion");
                continue;
            }
            if (command.equalsIgnoreCase("-libraryCompatible")) {
                this._libraryCompatible = new Boolean(this.getNextArgument("libraryCompatible"));
                continue;
            }
            if (command.equalsIgnoreCase("-installcodesources")) {
                while ((nextArg = this.readNextArgument()) != null && !nextArg.startsWith("-")) {
                    this._installCodeSources.add(this.getNextArgument("installCodeSource"));
                }
                continue;
            }
            if (command.equalsIgnoreCase("-addcodesources")) {
                while ((nextArg = this.readNextArgument()) != null && !nextArg.startsWith("-")) {
                    this._addCodeSources.add(this.getNextArgument("addCodeSource"));
                }
                continue;
            }
            if (command.equalsIgnoreCase("-imports")) {
                while ((nextArg = this.readNextArgument()) != null && !nextArg.startsWith("-")) {
                    this._imports.add(this.getNextArgument("imports"));
                }
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_publishsharedlibrary_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._name, "-name");
        this.checkArgIsNull(this._version, "-version");
        if (this._addCodeSources.size() == 0 && this._installCodeSources.size() == 0 && this._imports.size() == 0) {
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("codesource_or_import_not_specified"), COMMANDNAME);
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            if (this._j2eeDeplMgr.checkSharedLibraryExists(this._name, this._version)) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("shared_library_already_exists", new String[]{this._name, this._version}));
            }
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("publishsharedlibrary_error", new String[]{e.getMessage()}), e);
        }
        String[] ics = this._installCodeSources.toArray(new String[this._installCodeSources.size()]);
        String[] acs = this._addCodeSources.toArray(new String[this._addCodeSources.size()]);
        ImportSharedLibrary[] libs = null;
        if (this._imports.size() != 0) {
            libs = new ImportSharedLibrary[this._imports.size()];
            for (int i = 0; i < this._imports.size(); ++i) {
                libs[i] = ImportSharedLibrary.createImport(this._imports.get(i).toString());
            }
        }
        try {
            this._j2eeDeplMgr.publishSharedLibrary(this._name, this._version, this._parentName, this._parentVersion, this._libraryCompatible, ics, acs, libs);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("publishsharedlibrary_error", new String[]{e.getMessage()}), e);
        }
        System.out.println("");
        System.out.println(FormattingResourceBundle.DeploymentMessages.getString("command_successful", new String[]{"publishSharedLibrary"}));
        System.out.println("");
    }
}

