/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RedeployCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-redeploy";
    public static final String COMMANDMENU = "-redeploy -file <filename> -deploymentName <appname> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -redeploy [<switch>]\n   - Redeploys an application, standalone WAR or standalone RAR.\n\nValid switches are:\n   -file <path>           - Required  The file path of the archive or\n                                      application directory to be redeployed.\n   -deploymentName <name>\n                        - Required  The name to assign to the redeployed \n                                    application.\n   -removeArchive       - Optional  Enable removing the archive after the \n                                    application is redeployed.\n   -bindAllWebApps [<web_site_name>]\n                        - Optional  Binds all WAR files within the EAR to\n                                    specified Web site. If omitted, modules\n                                    are bound to the 'default-web-site'.\n                                    This option has higher priority than\n                                    -keepsettings.\n   -keepsettings        - Optional  Retain current settings the application\n                                    has on the server.\n   -sequential [waitsec]  - Optional  Deploy the archive to each OC4J instance\n                                      within the cluster in sequence. If you\n                                      specify waitsec, admin_client waits waitsec\n                                      between deployments to the different \n                                      instances. If not included, the archive \n                                      is simultaneously deployed to all instances.\n   -contextRoot <root>    - Optional  Used for standalone WAR file redeployment\n                                      only. The context root for the Web \n                                      module. If omitted, the -deploymentName\n                                      value is used.\n   -failureRecovery       - Optional  Enable recovery from a failed redeployment.\n                                      The previous archive is redeployed if possible.\n";
    private String _fileName = null;
    private String _appName = null;
    private Map _extraParams = new HashMap();
    private String _clientJarPath = null;
    private boolean _keepsettings = false;
    private boolean _serialized = false;
    private String _deploymentPlanPath = null;
    private boolean _failureRecovery = false;

    public RedeployCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String nextArg;
            String command = this.getNextArgument("deployment subcommand");
            if (command.equalsIgnoreCase("-file")) {
                this._fileName = this.getNextArgument("deployment -file filename");
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentname")) {
                this._appName = this.getNextArgument("deployment name");
                continue;
            }
            if (command.equalsIgnoreCase("-bindallwebapps")) {
                nextArg = this.readNextArgument();
                if (nextArg == null || nextArg.startsWith("-")) {
                    this._extraParams.put("bindWebApp", "default-web-site");
                    continue;
                }
                this._extraParams.put("bindWebApp", this.getNextArgument("web site name for -bindAllWebApps"));
                continue;
            }
            if (command.equalsIgnoreCase("-keepsettings")) {
                this._keepsettings = true;
                continue;
            }
            if (command.equalsIgnoreCase("-sequential")) {
                nextArg = this.readNextArgument();
                if (nextArg != null && !nextArg.startsWith("-")) {
                    this._extraParams.put("sequentialDelay", this.getNextArgument("delay value in sequential option"));
                }
                this._serialized = true;
                continue;
            }
            if (command.equalsIgnoreCase("-removeArchive")) {
                this._extraParams.put("removeArchive", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-contextroot")) {
                this._extraParams.put("contextRoot", this.getNextArgument("-contextRoot"));
                continue;
            }
            if (command.equalsIgnoreCase("-failureRecovery")) {
                this._extraParams.put("failureRecovery", "true");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_redeploy_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._fileName, "-file");
        this.checkArgIsNull(this._appName, "-deploymentName");
        this.checkArgs();
    }

    protected void doExecute() throws AdminCommandException {
        File packageFile = new File(this._fileName);
        try {
            this._j2eeDeplMgr.redeploy(packageFile.getAbsolutePath(), this._appName, this._extraParams, this._keepsettings, this._serialized);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("redeploy_error", new String[]{e.getMessage()}), e);
        }
    }

    private void checkArgs() {
        if (!this._keepsettings && DeploymentUtils.isWar(this._fileName)) {
            DeploymentUtils.findContextRootInArchive(this._fileName, this._extraParams);
            DeploymentUtils.setDefaultContextRoot(this._appName, this._extraParams);
        }
    }
}

