/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveJMSFactoryCommand
extends AdminCommandBase {
    String _location;
    static final String COMMANDNAME = "-removeJMSConnectionFactory";
    static final String COMMANDMENU = "-removeJMSConnectionFactory -jndiLocation <jndiLocation>";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeJMSConnectionFactory\n   - Delete an existing OC4J JMS connection factory.\n\nValid switches are: \n   -jndiLocation <jndiLocation>                            - Required  The JNDI location of the connection factory to remove.\n\n";

    public RemoveJMSFactoryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("removeFactory subcommand");
            if (command.equalsIgnoreCase("-jndiLocation")) {
                this._location = this.getNextArgument("-jndiLocation ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removeFactory_switch", new String[]{command}), "-removeFactory");
        }
        this.checkArgIsNull(this._location, "-jndiLocation");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.removeFactory(this._location);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removeFactory_error", new String[]{e.getMessage()}), e);
        }
    }
}

