/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.CodeSourceNode;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ModifiableRootNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryRootNode;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.management.shared.CodeSource;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class CodeSourceRootNode
extends ViewableJTreeNodeSupport
implements ModifiableRootNode,
ActionListener {
    protected String _viewHeaderString = "Code Sources";
    protected CodeSource[] _codeSources;
    protected DeploymentManager _manager;
    protected ViewableJTree _tree;
    protected static JMenuItem _uploadMenuItem;
    protected static Vector _menuItems;

    public CodeSourceRootNode(CodeSource[] codeSources, DeploymentManager manager) {
        this._codeSources = codeSources;
        this._manager = manager;
    }

    public String childType() {
        return "Code Source";
    }

    public Collection getPopupMenuItems(ViewableJTree tree) {
        ActionListener[] lsnrs = _uploadMenuItem.getActionListeners();
        for (int i = 0; i < lsnrs.length; ++i) {
            _uploadMenuItem.removeActionListener(lsnrs[i]);
        }
        _uploadMenuItem.addActionListener(this);
        this._tree = tree;
        return _menuItems;
    }

    public ViewableJTreeNode addNewChildNode() {
        DataEntryElement[] childElements = new DataEntryElement[]{new StringDataEntryElement("Path", true)};
        DataEntryDialog dialog = DataEntryDialog.createSimpleDataEntryDialog(childElements, "New " + this.childType(), "Enter Path to new Code Source");
        if (!dialog.showDialog()) {
            return null;
        }
        String path = childElements[0].getValueAsString();
        if (path == null || path.length() == 0) {
            GuiUtil.errDialog("You must enter a value for Path.");
            return null;
        }
        try {
            SharedLibrary lib = this.getParentSharedLibrary();
            if (lib == null) {
                GuiUtil.errDialog("The parent shared library no longer exists");
                return null;
            }
            CodeSource[] codeSources = lib.getCodeSources();
            for (int cs = 0; cs < codeSources.length; ++cs) {
                if (!codeSources[cs].getPath().equals(path)) continue;
                GuiUtil.errDialog(this.childType() + " already exists.");
                return null;
            }
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.modifySharedLibrary(new Target[]{((SharedLibraryNode)this.getParent()).getTarget()}, lib.getName(), lib.getVersion(), null, null, new String[]{path}, null, null, null);
            CodeSource codeSource = new CodeSource(path);
            CodeSourceNode node = new CodeSourceNode(codeSource, this._manager);
            this.addJTreeChild(node);
            return node;
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception adding " + this.childType() + ": " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private SharedLibrary getParentSharedLibrary() {
        SharedLibraryNode parent = (SharedLibraryNode)this.getParent();
        SharedLibrary parentLib = parent.getSharedLibrary();
        SharedLibraryRootNode parentRoot = (SharedLibraryRootNode)parent.getParent();
        parentRoot.setRebuildChildJTree(true);
        SharedLibrary[] shLibs = parentRoot.getSharedLibraries();
        int libNo = -1;
        for (int lib = 0; lib < shLibs.length; ++lib) {
            if (!shLibs[lib].getName().equals(parentLib.getName()) || !shLibs[lib].getVersion().equals(parentLib.getVersion())) continue;
            libNo = lib;
            break;
        }
        if (libNo != -1) {
            return shLibs[libNo];
        }
        return null;
    }

    public String viewHeaderString() {
        return this._viewHeaderString;
    }

    public String toString() {
        return "Code Sources";
    }

    public void buildChildJTree() {
        for (int cs = 0; cs < this._codeSources.length; ++cs) {
            this.addJTreeChild(new CodeSourceNode(this._codeSources[cs], this._manager));
        }
    }

    public boolean leaf() {
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        SharedLibrary lib = this.getParentSharedLibrary();
        if (lib == null) {
            GuiUtil.errDialog("The parent shared library no longer exists");
            return;
        }
        File codeSourceFile = GuiUtil.promptUserToSpecifyFile("Specify Code Source to Upload");
        String message = "<html>Upload Code Source <font color=red>" + codeSourceFile.getName() + "</font> to shared library <font color=red>" + lib.getName() + "</font>?";
        if (GuiUtil.showYesNoDialog("Confirm Upload Code Source", message) == 1) {
            return;
        }
        try {
            CodeSource[] codeSources = lib.getCodeSources();
            for (int cs = 0; cs < codeSources.length; ++cs) {
                if (!codeSources[cs].getPath().equals(codeSourceFile.getName())) continue;
                GuiUtil.errDialog("Code Source already exists.");
                return;
            }
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.modifySharedLibrary(new Target[]{((SharedLibraryNode)this.getParent()).getTarget()}, lib.getName(), lib.getVersion(), null, new File[]{codeSourceFile}, null, null, null, null);
            CodeSource codeSource = new CodeSource(codeSourceFile.getName());
            CodeSourceNode node = new CodeSourceNode(codeSource, this._manager);
            this.addJTreeChild(node);
            ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged(this);
            TreePath path = this._tree.getSelectionPath();
            path = path.pathByAddingChild(this);
            this._tree.makeVisible(path);
            this._tree.setSelectionPath(path);
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception adding " + this.childType() + ": " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
    }

    static {
        _menuItems = new Vector();
        _uploadMenuItem = new JMenuItem("Upload Code Source");
        _uploadMenuItem.setBackground(Deployer.MenuBackgroundColor);
        _uploadMenuItem.setFont(GuiUtil.getRegularFont());
        _menuItems.add(_uploadMenuItem);
    }
}

