/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.ConfigurableElement;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataElementPane;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;

public class ConfigPropertiesPanel
extends JPanel
implements PropertyChangeListener {
    private Hashtable _elements = new Hashtable();

    public ConfigPropertiesPanel(ConfigurableElement node) {
        this(node, false);
    }

    public ConfigPropertiesPanel(ConfigurableElement node, boolean editable) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBackground(Deployer.ViewBackgroundColor);
        try {
            DataElement[] elementArray;
            if (node instanceof ViewableJTreeNode) {
                JLabel label = GuiUtil.createHeaderLabel(((ViewableJTreeNode)((Object)node)).viewHeaderString());
                this.add(label);
            }
            if ((elementArray = node.fetchAttributeElements()) == null) {
                return;
            }
            for (int i = 0; i < elementArray.length; ++i) {
                if (elementArray[i] == null) continue;
                this._elements.put(elementArray[i].getName(), elementArray[i]);
            }
            DataElementPane dataPanel = new DataElementPane(elementArray, true, editable);
            dataPanel.setAlignmentX(0.0f);
            Dimension prefSize = dataPanel.getPreferredSize();
            dataPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, prefSize.height));
            this.add(dataPanel);
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        DataEntryElement element;
        String propertyName = event.getPropertyName();
        if (propertyName != null && (element = (DataEntryElement)this._elements.get(propertyName)) != null) {
            Object newValue = event.getNewValue();
            element.setValue(newValue.toString(), false);
        }
    }
}

